/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.utils.math;

import net.dermetfan.utils.ArrayUtils;

public class MathUtils {
    public static int crossSum(int n) {
        int csum = 0;
        while (n > 0) {
            csum += n % 10;
            n /= 10;
        }
        return csum;
    }

    public static int factorial(int n) {
        return (int)MathUtils.factorial((float)n);
    }

    public static float factorial(float n) {
        if (n < 0.0f) {
            throw new IllegalArgumentException("n must be >= 0: " + n);
        }
        return n <= 1.0f ? 1.0f : n * MathUtils.factorial(n - 1.0f);
    }

    public static boolean between(float value, float min, float max) {
        return MathUtils.between(value, min, max, false);
    }

    public static boolean between(float value, float min, float max, boolean inclusive) {
        min = Math.min(min, max);
        max = Math.max(min, max);
        return inclusive ? value >= min && value <= max : value > min && value < max;
    }

    public static float det(float x1, float y1, float x2, float y2, float x3, float y3) {
        return x1 * y2 + x2 * y3 + x3 * y1 - y1 * x2 - y2 * x3 - y3 * x1;
    }

    public static float normalize(float value, float range) {
        return MathUtils.normalize(value, 0.0f, range);
    }

    public static float normalize(float value, float min, float max) {
        float over;
        if (min == max) {
            return min;
        }
        float oldMin = min;
        float oldMax = max;
        min = Math.min(min, max);
        max = Math.max(oldMin, max);
        float under = value < min ? Math.abs(min - value) : 0.0f;
        float f = over = value > max ? value - Math.abs(max) : 0.0f;
        if (under > 0.0f) {
            return MathUtils.normalize(oldMax + (oldMax > oldMin ? -under : under), min, max);
        }
        if (over > 0.0f) {
            return MathUtils.normalize(oldMin + (oldMin < oldMax ? over : -over), min, max);
        }
        return value;
    }

    public static float mirror(float value, float baseline) {
        return baseline * 2.0f - value;
    }

    public static float replaceNaN(float value, float replacement) {
        return Float.isNaN(value) ? replacement : value;
    }

    public static <T> T elementAtSum(float sum, float[] values, T[] elements, int valuesOffset, int valuesLength, int elementsOffset, int elementsLength) {
        float total = 0.0f;
        for (int i = valuesOffset; i < valuesOffset + valuesLength; ++i) {
            float f;
            total += values[i];
            if (!(f >= sum)) continue;
            return elements[elementsOffset + i - valuesOffset];
        }
        return total <= 0.0f ? elements[elementsOffset] : elements[elementsOffset + elementsLength - 1];
    }

    public static <T> T elementAtSum(float sum, float[] values, T[] elements) {
        return MathUtils.elementAtSum(sum, values, elements, 0, values.length, 0, elements.length);
    }

    public static float[] clamp(float[] items, float min, float max, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            items[i] = com.badlogic.gdx.math.MathUtils.clamp(items[i], min, max);
        }
        return items;
    }

    public static float[] clamp(float[] items, float min, float max) {
        return MathUtils.clamp(items, min, max, 0, items.length);
    }

    public static float[] abs(float[] items, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            items[i] = Math.abs(items[i]);
        }
        return items;
    }

    public static float[] abs(float[] items) {
        return MathUtils.abs(items, 0, items.length);
    }

    public static float[] add(float[] items, float value, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            items[n] = items[n] + value;
        }
        return items;
    }

    public static float[] add(float[] items, float value) {
        return MathUtils.add(items, value, 0, items.length);
    }

    public static float[] sub(float[] items, float value, int offset, int length) {
        return MathUtils.add(items, -value, offset, length);
    }

    public static float[] sub(float[] items, float value) {
        return MathUtils.sub(items, value, 0, items.length);
    }

    public static float[] mul(float[] items, float factor, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            items[n] = items[n] * factor;
        }
        return items;
    }

    public static float[] mul(float[] items, float factor) {
        return MathUtils.mul(items, factor, 0, items.length);
    }

    public static float[] div(float[] items, float divisor, int offset, int length) {
        return MathUtils.mul(items, 1.0f / divisor, offset, length);
    }

    public static float[] div(float[] items, float divisor) {
        return MathUtils.div(items, divisor, 0, items.length);
    }

    public static float approachZero(float value, float amount) {
        if ((amount = Math.abs(amount)) > Math.abs(value) || value == 0.0f) {
            return 0.0f;
        }
        return value - (value > 0.0f ? amount : -amount);
    }

    public static float sum(float[] items, int offset, int length) {
        float sum = 0.0f;
        for (int i = offset; i < offset + length; ++i) {
            sum += items[i];
        }
        return sum;
    }

    public static float sum(float[] items) {
        return MathUtils.sum(items, 0, items.length);
    }

    public static float amplitude2(float[] items, int offset, int length) {
        return MathUtils.max(items, offset, length) - MathUtils.min(items, offset, length);
    }

    public static float amplitude2(float[] items) {
        return MathUtils.amplitude2(items, 0, items.length);
    }

    public static float max(float[] items, int offset, int length) {
        ArrayUtils.checkRegion(items, offset, length);
        if (length == 0) {
            return Float.NaN;
        }
        float max = Float.NEGATIVE_INFINITY;
        for (int i = offset; i < offset + length; ++i) {
            float f = items[i];
            if (!(f > max)) continue;
            max = f;
        }
        return max;
    }

    public static float max(float[] items) {
        return MathUtils.max(items, 0, items.length);
    }

    public static float min(float[] items, int offset, int length) {
        ArrayUtils.checkRegion(items, offset, length);
        if (length == 0) {
            return Float.NaN;
        }
        float min = Float.POSITIVE_INFINITY;
        for (int i = offset; i < offset + length; ++i) {
            float f = items[i];
            if (!(f < min)) continue;
            min = f;
        }
        return min;
    }

    public static float min(float[] items) {
        return MathUtils.min(items, 0, items.length);
    }

    public static float nearest(float value, float[] items, float minDiff, int offset, int length) {
        if (value == Float.POSITIVE_INFINITY) {
            return MathUtils.max(items, offset, length);
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return MathUtils.min(items, offset, length);
        }
        float smallestDiff = Float.POSITIVE_INFINITY;
        float nearest = Float.NaN;
        for (int i = offset; i < offset + length; ++i) {
            float diff = Math.abs(value - items[i]);
            if (diff < minDiff || !(diff < smallestDiff)) continue;
            smallestDiff = diff;
            nearest = items[i];
        }
        return nearest;
    }

    public static float nearest(float value, float[] items, float minDiff) {
        return MathUtils.nearest(value, items, minDiff, 0, items.length);
    }

    public static float nearest(float value, float[] items, int offset, int length) {
        return MathUtils.nearest(value, items, 0.0f, offset, length);
    }

    public static float nearest(float value, float[] items) {
        return MathUtils.nearest(value, items, 0, items.length);
    }

    public static float[] scale(float[] items, float min, float max, int offset, int length) {
        float tmp = MathUtils.amplitude2(items, offset, length) / (max - min);
        int i = offset;
        while (i < offset + length) {
            int n = i++;
            items[n] = items[n] / tmp;
        }
        tmp = min - MathUtils.min(items, offset, length);
        i = offset;
        while (i < offset + length) {
            int n = i++;
            items[n] = items[n] + tmp;
        }
        return items;
    }

    public static float[] scale(float[] items, float min, float max) {
        return MathUtils.scale(items, min, max, 0, items.length);
    }
}

