/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.utils.math;

import net.dermetfan.utils.ArrayUtils;
import net.dermetfan.utils.math.MathUtils;

public class GeometryUtils {
    private static float[] floats = new float[127];

    public static void setFloats(float[] floats) {
        GeometryUtils.floats = floats;
    }

    public static float[] getFloats() {
        return floats;
    }

    public static boolean between(float x, float y, float aX, float aY, float bX, float bY, boolean inclusive) {
        return MathUtils.det(x, y, aX, aY, bX, bY) == 0.0f && MathUtils.between(x, aX, bX, inclusive) && MathUtils.between(y, aY, bY, inclusive);
    }

    public static boolean between(float x, float y, float aX, float aY, float bX, float bY) {
        return GeometryUtils.between(x, y, aX, aY, bX, bY, true);
    }

    public static float[] add(float[] items, int offset, int length, float x, float y) {
        for (int i = offset + 1; i < offset + length; i += 2) {
            int n = i - 1;
            items[n] = items[n] + x;
            int n2 = i;
            items[n2] = items[n2] + y;
        }
        return items;
    }

    public static float[] add(float[] vertices, float x, float y) {
        return GeometryUtils.add(vertices, 0, vertices.length, x, y);
    }

    public static float[] sub(float[] items, int offset, int length, float x, float y) {
        return GeometryUtils.add(items, offset, length, -x, -y);
    }

    public static float[] sub(float[] items, float x, float y) {
        return GeometryUtils.sub(items, 0, items.length, x, y);
    }

    public static float[] addX(float[] items, int offset, int length, float value) {
        return GeometryUtils.add(items, offset, length, value, 0.0f);
    }

    public static float[] addX(float[] items, float value) {
        return GeometryUtils.addX(items, 0, items.length, value);
    }

    public static float[] addY(float[] items, int offset, int length, float value) {
        return GeometryUtils.add(items, offset, length, 0.0f, value);
    }

    public static float[] addY(float[] items, float value) {
        return GeometryUtils.addY(items, 0, items.length, value);
    }

    public static float[] subX(float[] items, int offset, int length, float value) {
        return GeometryUtils.sub(items, offset, length, value, 0.0f);
    }

    public static float[] subX(float[] items, float value) {
        return GeometryUtils.subX(items, 0, items.length, value);
    }

    public static float[] subY(float[] items, int offset, int length, float value) {
        return GeometryUtils.sub(items, offset, length, 0.0f, value);
    }

    public static float[] subY(float[] items, float value) {
        return GeometryUtils.subY(items, 0, items.length, value);
    }

    public static float width(float[] vertices, int offset, int length) {
        return MathUtils.amplitude2(GeometryUtils.filterX(vertices, offset, length, floats), 0, length / 2);
    }

    public static float width(float[] vertices) {
        return GeometryUtils.width(vertices, 0, vertices.length);
    }

    public static float height(float[] vertices, int offset, int length) {
        return MathUtils.amplitude2(GeometryUtils.filterY(vertices, offset, length, floats), 0, length / 2);
    }

    public static float height(float[] vertices) {
        return GeometryUtils.height(vertices, 0, vertices.length);
    }

    public static float depth(float[] vertices, int offset, int length) {
        return MathUtils.amplitude2(GeometryUtils.filterZ(vertices, offset, length, floats), 0, length / 3);
    }

    public static float depth(float[] vertices) {
        return GeometryUtils.depth(vertices, 0, vertices.length);
    }

    public static float[] filterX(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, -1, 2, dest, destOffset);
    }

    public static float[] filterX(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterX(vertices, offset, length, dest, 0);
    }

    public static float[] filterX(float[] vertices, float[] dest) {
        return GeometryUtils.filterX(vertices, 0, vertices.length, dest);
    }

    public static float[] filterX(float[] vertices, int offset, int length) {
        return GeometryUtils.filterX(vertices, offset, length, new float[length / 2]);
    }

    public static float[] filterX(float[] vertices) {
        return GeometryUtils.filterX(vertices, new float[vertices.length / 2]);
    }

    public static float[] filterY(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, 0, 2, dest, destOffset);
    }

    public static float[] filterY(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterY(vertices, offset, length, dest, 0);
    }

    public static float[] filterY(float[] vertices, float[] dest) {
        return GeometryUtils.filterY(vertices, 0, vertices.length, dest);
    }

    public static float[] filterY(float[] vertices, int offset, int length) {
        return GeometryUtils.filterY(vertices, offset, length, new float[length / 2]);
    }

    public static float[] filterY(float[] vertices) {
        return GeometryUtils.filterY(vertices, new float[vertices.length / 2]);
    }

    public static float[] filterZ(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, 0, 3, dest, destOffset);
    }

    public static float[] filterZ(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterZ(vertices, offset, length, dest, 0);
    }

    public static float[] filterZ(float[] vertices, float[] dest) {
        return GeometryUtils.filterZ(vertices, 0, vertices.length, dest);
    }

    public static float[] filterZ(float[] vertices, int offset, int length) {
        return GeometryUtils.filterZ(vertices, offset, length, new float[length / 3]);
    }

    public static float[] filterZ(float[] vertices) {
        return GeometryUtils.filterZ(vertices, new float[vertices.length / 3]);
    }

    public static float[] filterW(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, 0, 4, dest, destOffset);
    }

    public static float[] filterW(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterW(vertices, offset, length, dest, 0);
    }

    public static float[] filterW(float[] vertices, float[] dest) {
        return GeometryUtils.filterW(vertices, 0, vertices.length, dest);
    }

    public static float[] filterW(float[] vertices, int offset, int length) {
        return GeometryUtils.filterW(vertices, offset, length, new float[length / 4]);
    }

    public static float[] filterW(float[] vertices) {
        return GeometryUtils.filterW(vertices, new float[vertices.length / 4]);
    }

    public static float minX(float[] vertices, int offset, int length) {
        return MathUtils.min(GeometryUtils.filterX(vertices, offset, length, floats), 0, length / 2);
    }

    public static float minX(float[] vertices) {
        return GeometryUtils.minX(vertices, 0, vertices.length);
    }

    public static float minY(float[] vertices, int offset, int length) {
        return MathUtils.min(GeometryUtils.filterY(vertices, offset, length, floats), 0, length / 2);
    }

    public static float minY(float[] vertices) {
        return GeometryUtils.minY(vertices, 0, vertices.length);
    }

    public static float maxX(float[] vertices, int offset, int length) {
        return MathUtils.max(GeometryUtils.filterX(vertices, offset, length, floats), 0, length / 2);
    }

    public static float maxX(float[] vertices) {
        return GeometryUtils.maxX(vertices, 0, vertices.length);
    }

    public static float maxY(float[] vertices, int offset, int length) {
        return MathUtils.max(GeometryUtils.filterY(vertices, offset, length, floats), 0, length / 2);
    }

    public static float maxY(float[] vertices) {
        return GeometryUtils.maxY(vertices, 0, vertices.length);
    }

    public static float[] rotate(float x, float y, float width, float height, float radians, float[] output, int offset) {
        if (output == null || offset + 8 > output.length - 1) {
            output = new float[8];
        }
        float rad = (float)(Math.sqrt(height * height + width * width) / 2.0);
        float theta = (float)Math.atan2(height, width);
        float x0 = (float)((double)rad * Math.cos(theta + radians));
        float y0 = (float)((double)rad * Math.sin(theta + radians));
        float x1 = (float)((double)rad * Math.cos(-theta + radians));
        float y1 = (float)((double)rad * Math.sin(-theta + radians));
        float offsetX = x + width / 2.0f;
        float offsetY = y + height / 2.0f;
        output[offset] = offsetX + x0;
        output[offset + 1] = offsetY + y0;
        output[offset + 2] = offsetX + x1;
        output[offset + 3] = offsetY + y1;
        output[offset + 4] = offsetX - x0;
        output[offset + 5] = offsetY - y0;
        output[offset + 6] = offsetX - x1;
        output[offset + 7] = offsetY - y1;
        return output;
    }

    public static float invertAxis(float coord, float axisSize) {
        return MathUtils.mirror(coord, axisSize / 2.0f);
    }

    public static float[] invertAxes(float[] vertices, int offset, int length, boolean x, boolean y) {
        if (!x && !y) {
            return vertices;
        }
        float height = GeometryUtils.height(vertices, offset, length);
        float width = GeometryUtils.width(vertices, offset, length);
        for (int i = (x ? 0 : 1) + offset; i < offset + length; i += x ^ y ? 2 : 1) {
            vertices[i] = i % 2 == 0 ? GeometryUtils.invertAxis(vertices[i], width) : GeometryUtils.invertAxis(vertices[i], height);
        }
        return vertices;
    }

    public static float[] invertAxes(float[] vertices, boolean x, boolean y) {
        return GeometryUtils.invertAxes(vertices, 0, vertices.length, x, y);
    }

    public static float[] toYDown(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        GeometryUtils.invertAxes(vertices, offset, length, false, true);
        return GeometryUtils.subY(vertices, offset, length, GeometryUtils.height(vertices, offset, length));
    }

    public static float[] toYDown(float[] vertices) {
        return GeometryUtils.toYDown(vertices, 0, vertices.length);
    }

    public static float[] toYUp(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        GeometryUtils.invertAxes(vertices, offset, length, false, true);
        return GeometryUtils.subY(vertices, offset, length, GeometryUtils.height(vertices, offset, length));
    }

    public static float[] toYUp(float[] vertices) {
        return GeometryUtils.toYUp(vertices, 0, vertices.length);
    }
}

