/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.utils;

import net.dermetfan.utils.math.MathUtils;

public class Appender {
    private CharSequence[] appendices;
    private float[] durations;
    private float time;
    private int index;

    public static CharSequence append(CharSequence seq, CharSequence appendix) {
        return seq.toString() + appendix;
    }

    public static CharSequence appendixAt(float time, CharSequence[] appendices, float[] durations) {
        return MathUtils.elementAtSum(time, durations, appendices);
    }

    public Appender(CharSequence appendices, float durations) {
        this.set(new CharSequence[]{appendices}, new float[]{durations});
    }

    public Appender(CharSequence[] appendices, float durations) {
        this(appendices, new float[appendices.length]);
        for (int i = 0; i < appendices.length; ++i) {
            this.durations[i] = durations;
        }
    }

    public Appender(CharSequence[] appendices, float[] durations) {
        this.set(appendices, durations);
    }

    public float update(float delta) {
        float f;
        this.time += delta;
        if (f > this.durations[this.index]) {
            this.time -= this.durations[this.index];
            if (++this.index >= this.appendices.length) {
                this.index = 0;
            }
            if (this.time > this.durations[this.index]) {
                this.time -= (float)((int)(this.time / this.durations[this.index])) * this.durations[this.index];
            }
        }
        return this.index;
    }

    public CharSequence appendixAt(float time) {
        return Appender.appendixAt(time, this.appendices, this.durations);
    }

    public CharSequence append(CharSequence seq) {
        return Appender.append(seq, this.appendices[com.badlogic.gdx.math.MathUtils.clamp(this.index, 0, this.appendices.length)]);
    }

    public CharSequence append(CharSequence seq, float time) {
        return Appender.append(seq, this.appendixAt(time));
    }

    public CharSequence updateAndAppend(CharSequence seq, float delta) {
        this.update(delta);
        return this.append(seq);
    }

    public void set(CharSequence[] appendices, float[] durations) {
        if (appendices.length != durations.length) {
            throw new IllegalArgumentException("appendices[] and durations[] must have the same length: " + appendices.length + ", " + durations.length);
        }
        this.appendices = appendices;
        this.durations = durations;
    }

    public void set(CharSequence[] appendices, float durations) {
        this.appendices = appendices;
        this.durations = new float[appendices.length];
        for (int i = 0; i < appendices.length; ++i) {
            this.durations[i] = durations;
        }
    }

    public CharSequence[] getAppendices() {
        return this.appendices;
    }

    public void setAppendices(CharSequence[] appendices) {
        this.set(appendices, this.durations);
    }

    public float[] getDurations() {
        return this.durations;
    }

    public void setDurations(float[] durations) {
        this.set(this.appendices, durations);
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

