/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import net.dermetfan.gdx.scenes.scene2d.Scene2DUtils;
import net.dermetfan.gdx.scenes.scene2d.utils.PolygonRegionDrawable;

public class JigsawPuzzle {
    private final Array<Piece> pieces;

    public JigsawPuzzle() {
        this.pieces = new Array(Piece.class);
    }

    public JigsawPuzzle(int pieces) {
        this.pieces = new Array(pieces);
    }

    public JigsawPuzzle(Piece ... pieces) {
        this.pieces = new Array<Piece>(pieces);
    }

    public void solve(Piece relativeTo) {
        if (!this.pieces.contains(relativeTo, true)) {
            throw new IllegalArgumentException("the reference piece is not part of the puzzle");
        }
        for (Piece piece : this.pieces) {
            if (piece == relativeTo) continue;
            piece.place(relativeTo);
        }
    }

    public void add(Piece piece) {
        if (!this.pieces.contains(piece, true)) {
            this.pieces.add(piece);
        }
    }

    public boolean remove(Piece piece) {
        return this.pieces.removeValue(piece, true);
    }

    @Deprecated
    public Piece findClosest(Piece piece) {
        float distance = Float.POSITIVE_INFINITY;
        Piece closest = null;
        for (Piece other : this.pieces) {
            float dist;
            if (other == piece || !((dist = Vector2.dst(other.getX() + other.getSlotX(), other.getY() + other.getSlotY(), piece.getX() + piece.getSlotX(), piece.getY() + piece.getSlotY())) < distance)) continue;
            distance = dist;
            closest = other;
        }
        return closest;
    }

    public boolean isSolved(float tolerance) {
        Piece reference = this.pieces.first();
        for (Piece piece : this.pieces) {
            if (piece.isPlacedCorrectly(reference, tolerance)) continue;
            return false;
        }
        return true;
    }

    public Array<Piece> getPieces() {
        return this.pieces;
    }

    public static class Target
    extends DragAndDrop.Target {
        private JigsawPuzzle puzzle;
        private float tolerance;

        public Target(Group group, JigsawPuzzle puzzle, float tolerance) {
            super(group);
            this.puzzle = puzzle;
            this.tolerance = tolerance;
        }

        @Override
        public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            return true;
        }

        @Override
        public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            Actor dragged = payload.getDragActor();
            Scene2DUtils.addAtStageCoordinates(dragged, (Group)this.getActor());
            if (dragged instanceof Piece) {
                Piece piece = (Piece)dragged;
                for (int i = 0; i < this.puzzle.getPieces().size; ++i) {
                    Piece ref = this.puzzle.getPieces().get(i);
                    if (ref == piece || !piece.isPlacedCorrectly(ref, this.tolerance)) continue;
                    piece.place(ref);
                    this.placed(piece);
                    break;
                }
            }
        }

        protected void placed(Piece piece) {
            if (this.puzzle.isSolved(this.tolerance)) {
                this.solved();
            }
        }

        protected void solved() {
        }

        public JigsawPuzzle getPuzzle() {
            return this.puzzle;
        }

        public void setPuzzle(JigsawPuzzle puzzle) {
            this.puzzle = puzzle;
        }

        public float getTolerance() {
            return this.tolerance;
        }

        public void setTolerance(float tolerance) {
            this.tolerance = tolerance;
        }
    }

    public static class Source
    extends DragAndDrop.Source {
        private DragAndDrop dragAndDrop;
        private JigsawPuzzle puzzle;
        private float moveBackDuration = 0.5f;
        private final DragAndDrop.Payload payload = new DragAndDrop.Payload();
        private final Vector2 vec2 = new Vector2();

        public Source(Group board, DragAndDrop dragAndDrop, JigsawPuzzle puzzle) {
            super(board);
            this.dragAndDrop = dragAndDrop;
            this.puzzle = puzzle;
        }

        public Source(Group board, DragAndDrop dragAndDrop, JigsawPuzzle puzzle, float moveBackDuration) {
            this(board, dragAndDrop, puzzle);
            this.moveBackDuration = moveBackDuration;
        }

        @Override
        public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
            Actor actor = this.getActor().hit(x, y, true);
            if (actor == this.getActor() || !(actor instanceof Piece) || !this.puzzle.getPieces().contains((Piece)actor, true)) {
                return null;
            }
            this.payload.setDragActor(actor);
            ((Group)this.getActor()).localToDescendantCoordinates(actor, this.vec2.set(x, y));
            this.dragAndDrop.setDragActorPosition(-this.vec2.x, -this.vec2.y + actor.getHeight());
            this.vec2.set(actor.getX(), actor.getY());
            return this.payload;
        }

        @Override
        public void dragStop(InputEvent event, float x, float y, int pointer, DragAndDrop.Payload payload, DragAndDrop.Target target) {
            final Actor actor = payload.getDragActor();
            if (actor.getParent() == null) {
                this.getActor().getStage().addActor(actor);
                this.getActor().localToStageCoordinates(this.vec2);
                actor.addAction(Actions.sequence((Action)Actions.moveTo(this.vec2.x, this.vec2.y, this.moveBackDuration), (Action)Actions.run(new Runnable(){

                    @Override
                    public void run() {
                        ((Group)Source.this.getActor()).addActor(actor);
                        Source.this.getActor().stageToLocalCoordinates(Source.this.vec2);
                        actor.setPosition(((Source)Source.this).vec2.x, ((Source)Source.this).vec2.y);
                    }
                })));
            }
        }

        public DragAndDrop getDragAndDrop() {
            return this.dragAndDrop;
        }

        public void setDragAndDrop(DragAndDrop dragAndDrop) {
            this.dragAndDrop = dragAndDrop;
        }

        public JigsawPuzzle getPuzzle() {
            return this.puzzle;
        }

        public void setPuzzle(JigsawPuzzle puzzle) {
            this.puzzle = puzzle;
        }

        public float getMoveBackDuration() {
            return this.moveBackDuration;
        }

        public void setMoveBackDuration(float moveBackDuration) {
            this.moveBackDuration = moveBackDuration;
        }
    }

    public static class Piece
    extends Image {
        private float slotX;
        private float slotY;

        public Piece(Drawable drawable) {
            super(drawable);
        }

        @Override
        public void setDrawable(Drawable drawable) {
            super.setDrawable(drawable);
            if (drawable instanceof PolygonRegionDrawable) {
                PolygonRegionDrawable pd = (PolygonRegionDrawable)drawable;
                this.slotX = pd.getPolygonX();
                this.slotY = pd.getPolygonY();
            } else {
                this.slotY = 0.0f;
                this.slotX = 0.0f;
            }
        }

        @Override
        public Actor hit(float x, float y, boolean touchable) {
            float[] vertices;
            PolygonRegionDrawable drawable;
            Actor hit = super.hit(x, y, touchable);
            PolygonRegionDrawable polygonRegionDrawable = drawable = this.getDrawable() instanceof PolygonRegionDrawable ? (PolygonRegionDrawable)this.getDrawable() : null;
            if (hit == this && drawable != null && !Intersector.isPointInPolygon(vertices = drawable.getRegion().getVertices(), 0, vertices.length, x / this.getWidth() * drawable.getPolygonWidth() + this.slotX, y / this.getHeight() * drawable.getPolygonHeight() + this.slotY)) {
                return null;
            }
            return hit;
        }

        public void place(Piece reference) {
            Vector2 refPuzzlePoint = Pools.obtain(Vector2.class).set(reference.getX(), reference.getY()).sub(reference.slotX, reference.slotY);
            this.setPosition(refPuzzlePoint.x + this.slotX, refPuzzlePoint.y + this.slotY);
            Pools.free(refPuzzlePoint);
        }

        public boolean isPlacedCorrectly(Piece reference, float tolerance) {
            Vector2 puzzlePos = Pools.obtain(Vector2.class).set(-this.slotX, -this.slotY);
            Vector2 refPuzzlePoint = Pools.obtain(Vector2.class).set(-reference.slotX, -reference.slotY);
            this.localToStageCoordinates(puzzlePos);
            reference.localToStageCoordinates(refPuzzlePoint);
            boolean rel = puzzlePos.epsilonEquals(refPuzzlePoint, tolerance);
            Pools.free(puzzlePos);
            Pools.free(refPuzzlePoint);
            return rel;
        }

        public void setSlot(float slotX, float slotY) {
            this.slotX = slotX;
            this.slotY = slotY;
        }

        public float getSlotX() {
            return this.slotX;
        }

        public void setSlotX(float slotX) {
            this.slotX = slotX;
        }

        public float getSlotY() {
            return this.slotY;
        }

        public void setSlotY(float slotY) {
            this.slotY = slotY;
        }
    }
}

