/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.math;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.Ellipse;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.ShortArray;
import java.util.Comparator;
import net.dermetfan.gdx.math.BayazitDecomposer;
import net.dermetfan.gdx.math.MathUtils;
import net.dermetfan.gdx.utils.ArrayUtils;

public class GeometryUtils
extends net.dermetfan.utils.math.GeometryUtils {
    private static final Vector2 vec2_0 = new Vector2();
    private static final Vector2 vec2_1 = new Vector2();
    private static Array<Vector2> tmpVector2Array = new Array();
    private static final FloatArray tmpFloatArray = new FloatArray();
    private static final Comparator<Vector2> arrangeClockwiseComparator = new Comparator<Vector2>(){

        @Override
        public int compare(Vector2 a, Vector2 b) {
            if (a.x > b.x) {
                return 1;
            }
            if (a.x < b.x) {
                return -1;
            }
            return 0;
        }
    };

    public static boolean between(Vector2 point, Vector2 a, Vector2 b, boolean inclusive) {
        return GeometryUtils.between(point.x, point.y, a.x, a.y, b.x, b.y, inclusive);
    }

    public static boolean between(Vector2 point, Vector2 a, Vector2 b) {
        return GeometryUtils.between(point.x, point.y, a.x, a.y, b.x, b.y);
    }

    public static Vector2 abs(Vector2 vector) {
        vector.x = Math.abs(vector.x);
        vector.y = Math.abs(vector.y);
        return vector;
    }

    public static Vector3 abs(Vector3 vector) {
        vector.x = Math.abs(vector.x);
        vector.y = Math.abs(vector.y);
        vector.z = Math.abs(vector.z);
        return vector;
    }

    public static Array<Vector2> add(Array<Vector2> vertices, float x, float y) {
        for (Vector2 vertice : vertices) {
            vertice.add(x, y);
        }
        return vertices;
    }

    public static Array<Vector2> sub(Array<Vector2> vertices, float x, float y) {
        return GeometryUtils.add(vertices, -x, -y);
    }

    public static FloatArray add(FloatArray vertices, float x, float y) {
        GeometryUtils.add(vertices.items, 0, vertices.size, x, y);
        return vertices;
    }

    public static FloatArray sub(FloatArray vertices, float x, float y) {
        GeometryUtils.sub(vertices.items, 0, vertices.size, x, y);
        return vertices;
    }

    public static FloatArray addX(FloatArray vertices, float value) {
        GeometryUtils.addX(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static FloatArray subX(FloatArray vertices, float value) {
        GeometryUtils.subX(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static FloatArray addY(FloatArray vertices, float value) {
        GeometryUtils.addY(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static FloatArray subY(FloatArray vertices, float value) {
        GeometryUtils.subY(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static Vector2 size(Array<Vector2> vertices, Vector2 output) {
        return output.set(GeometryUtils.width(vertices), GeometryUtils.height(vertices));
    }

    public static Vector2 size(Array<Vector2> vertices) {
        return GeometryUtils.size(vertices, vec2_0);
    }

    public static float width(Array<Vector2> vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterX(vertices));
    }

    public static float height(Array<Vector2> vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterY(vertices));
    }

    public static float width(FloatArray vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterX(vertices));
    }

    public static float height(FloatArray vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterY(vertices));
    }

    public static float depth(FloatArray vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterZ(vertices));
    }

    public static FloatArray filterX(Array<Vector2> vertices, FloatArray output) {
        if (output == null) {
            output = new FloatArray(vertices.size);
        }
        output.clear();
        output.ensureCapacity(vertices.size);
        for (int i = 0; i < vertices.size; ++i) {
            output.add(vertices.get((int)i).x);
        }
        return output;
    }

    public static FloatArray filterX(Array<Vector2> vertices) {
        return GeometryUtils.filterX(vertices, tmpFloatArray);
    }

    public static FloatArray filterX(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, -1, 2, output);
    }

    public static FloatArray filterX(FloatArray vertices) {
        return GeometryUtils.filterX(vertices, tmpFloatArray);
    }

    public static FloatArray filterX3D(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, -2, 3, output);
    }

    public static FloatArray filterX3D(FloatArray vertices) {
        return GeometryUtils.filterX3D(vertices, tmpFloatArray);
    }

    public static FloatArray filterY(Array<Vector2> vertices, FloatArray output) {
        if (output == null) {
            output = new FloatArray(vertices.size);
        }
        output.clear();
        output.ensureCapacity(vertices.size);
        for (int i = 0; i < vertices.size; ++i) {
            output.add(vertices.get((int)i).y);
        }
        return output;
    }

    public static FloatArray filterY(Array<Vector2> vertices) {
        return GeometryUtils.filterY(vertices, tmpFloatArray);
    }

    public static FloatArray filterY(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, 2, output);
    }

    public static FloatArray filterY(FloatArray vertices) {
        return GeometryUtils.filterY(vertices, tmpFloatArray);
    }

    public static FloatArray filterY3D(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, -4, 3, output);
    }

    public static FloatArray filterY3D(FloatArray vertices) {
        return GeometryUtils.filterY3D(vertices, tmpFloatArray);
    }

    public static FloatArray filterZ(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, 3, output);
    }

    public static FloatArray filterZ(FloatArray vertices) {
        return GeometryUtils.filterZ(vertices, tmpFloatArray);
    }

    public static FloatArray filterW(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, 4, output);
    }

    public static FloatArray filterW(FloatArray vertices) {
        return GeometryUtils.filterW(vertices, tmpFloatArray);
    }

    public static float minX(Array<Vector2> vertices) {
        return MathUtils.min(GeometryUtils.filterX(vertices));
    }

    public static float minY(Array<Vector2> vertices) {
        return MathUtils.min(GeometryUtils.filterY(vertices));
    }

    public static float maxX(Array<Vector2> vertices) {
        return MathUtils.max(GeometryUtils.filterX(vertices));
    }

    public static float maxY(Array<Vector2> vertices) {
        return MathUtils.max(GeometryUtils.filterY(vertices));
    }

    public static float minX(FloatArray vertices) {
        return MathUtils.min(GeometryUtils.filterX(vertices));
    }

    public static float minY(FloatArray vertices) {
        return MathUtils.min(GeometryUtils.filterY(vertices));
    }

    public static float maxX(FloatArray vertices) {
        return MathUtils.max(GeometryUtils.filterX(vertices));
    }

    public static float maxY(FloatArray vertices) {
        return MathUtils.max(GeometryUtils.filterY(vertices));
    }

    public static Vector2 rotate(Vector2 point, Vector2 origin, float radians) {
        if (point.equals(origin)) {
            return point;
        }
        return point.sub(origin).rotateRad(radians).add(origin);
    }

    public static void rotateLine(Vector2 a, Vector2 b, float radians) {
        GeometryUtils.rotate(a, vec2_0.set(a).add(b).scl(0.5f), radians);
        GeometryUtils.rotate(b, vec2_0, radians);
    }

    public static FloatArray rotate(float x, float y, float width, float height, float radians, FloatArray output) {
        output.clear();
        output.ensureCapacity(8);
        GeometryUtils.rotate(x, y, width, height, radians, output.items, 0);
        return output;
    }

    public static FloatArray rotate(float x, float y, float width, float height, float radians) {
        return GeometryUtils.rotate(x, y, width, height, radians, tmpFloatArray);
    }

    public static FloatArray rotate(Rectangle rectangle, float radians, FloatArray output) {
        return GeometryUtils.rotate(rectangle.x, rectangle.y, rectangle.width, rectangle.height, radians, output);
    }

    public static FloatArray rotate(Rectangle rectangle, float radians) {
        return GeometryUtils.rotate(rectangle, radians, tmpFloatArray);
    }

    public static FloatArray toFloatArray(Array<Vector2> vector2s, FloatArray output) {
        if (output == null) {
            output = new FloatArray(vector2s.size * 2);
        }
        output.clear();
        output.ensureCapacity(vector2s.size * 2);
        int vi = -1;
        for (int i = 0; i < vector2s.size * 2; ++i) {
            if (i % 2 == 0) {
                output.add(vector2s.get((int)(++vi)).x);
                continue;
            }
            output.add(vector2s.get((int)vi).y);
        }
        return output;
    }

    public static FloatArray toFloatArray(Array<Vector2> vector2s) {
        return GeometryUtils.toFloatArray(vector2s, tmpFloatArray);
    }

    public static Array<Vector2> toVector2Array(FloatArray floats, Array<Vector2> output) {
        if (floats.size % 2 != 0) {
            throw new IllegalArgumentException("the float array's length is not dividable by two, so it won't make up a Vector2 array: " + floats.size);
        }
        if (output == null) {
            output = new Array(floats.size / 2);
        }
        output.clear();
        int fi = -1;
        for (int i = 0; i < floats.size / 2; ++i) {
            output.add(new Vector2(floats.get(++fi), floats.get(++fi)));
        }
        return output;
    }

    public static Array<Vector2> toVector2Array(FloatArray floats) {
        return GeometryUtils.toVector2Array(floats, tmpVector2Array);
    }

    public static Polygon[] toPolygonArray(Array<Vector2> vertices, int vertexCount) {
        IntArray vertexCounts = Pools.obtain(IntArray.class);
        vertexCounts.clear();
        vertexCounts.ensureCapacity(vertices.size / vertexCount);
        for (int i = 0; i < vertices.size / vertexCount; ++i) {
            vertexCounts.add(vertexCount);
        }
        Polygon[] polygons = GeometryUtils.toPolygonArray(vertices, vertexCounts);
        vertexCounts.clear();
        Pools.free(vertexCounts);
        return polygons;
    }

    public static Polygon[] toPolygonArray(Array<Vector2> vertices, IntArray vertexCounts) {
        Polygon[] polygons = new Polygon[vertexCounts.size];
        int vertice = -1;
        for (int i = 0; i < polygons.length; ++i) {
            tmpVector2Array.clear();
            tmpVector2Array.ensureCapacity(vertexCounts.get(i));
            for (int i2 = 0; i2 < vertexCounts.get(i); ++i2) {
                tmpVector2Array.add(vertices.get(++vertice));
            }
            polygons[i] = new Polygon(GeometryUtils.toFloatArray(tmpVector2Array).toArray());
        }
        return polygons;
    }

    public static boolean areVerticesClockwise(Polygon polygon) {
        return polygon.area() < 0.0f;
    }

    public static boolean areVerticesClockwise(FloatArray vertices) {
        return vertices.size <= 4 || GeometryUtils.polygonArea(vertices) < 0.0f;
    }

    public static boolean areVerticesClockwise(float[] vertices, int offset, int length) {
        return vertices.length <= 8 || com.badlogic.gdx.math.GeometryUtils.polygonArea(vertices, offset, length) < 0.0f;
    }

    public static boolean areVerticesClockwise(float[] vertices) {
        return GeometryUtils.areVerticesClockwise(vertices, 0, vertices.length);
    }

    public static boolean areVerticesClockwise(Array<Vector2> vertices) {
        return vertices.size <= 2 || GeometryUtils.areVerticesClockwise(GeometryUtils.toFloatArray(vertices));
    }

    public static float polygonArea(FloatArray vertices) {
        return com.badlogic.gdx.math.GeometryUtils.polygonArea(vertices.items, 0, vertices.size);
    }

    public static void arrangeClockwise(Array<Vector2> vertices) {
        int n = vertices.size;
        int i1 = 1;
        int i2 = vertices.size - 1;
        if (tmpVector2Array == null) {
            tmpVector2Array = new Array(vertices.size);
        }
        tmpVector2Array.clear();
        tmpVector2Array.addAll(vertices);
        tmpVector2Array.sort(arrangeClockwiseComparator);
        tmpVector2Array.set(0, vertices.first());
        Vector2 C = vertices.first();
        Vector2 D = vertices.get(n - 1);
        for (int i = 1; i < n - 1; ++i) {
            float det = net.dermetfan.utils.math.MathUtils.det(C.x, C.y, D.x, D.y, vertices.get((int)i).x, vertices.get((int)i).y);
            if (det < 0.0f) {
                tmpVector2Array.set(i1++, vertices.get(i));
                continue;
            }
            tmpVector2Array.set(i2--, vertices.get(i));
        }
        tmpVector2Array.set(i1, vertices.get(n - 1));
        vertices.clear();
        vertices.addAll(tmpVector2Array, 0, n);
    }

    public static FloatArray invertAxes(FloatArray vertices, boolean x, boolean y) {
        GeometryUtils.invertAxes(vertices.items, 0, vertices.size, x, y);
        return vertices;
    }

    public static FloatArray toYDown(FloatArray vertices) {
        GeometryUtils.toYDown(vertices.items, 0, vertices.size);
        return vertices;
    }

    public static FloatArray toYUp(FloatArray vertices) {
        GeometryUtils.toYUp(vertices.items, 0, vertices.size);
        return vertices;
    }

    public static Rectangle setToAABB(Rectangle aabb, FloatArray vertices) {
        return aabb.set(GeometryUtils.minX(vertices), GeometryUtils.minY(vertices), GeometryUtils.width(vertices), GeometryUtils.height(vertices));
    }

    public static Rectangle setToAABB(Rectangle aabb, Array<Vector2> vertices) {
        return aabb.set(GeometryUtils.minX(vertices), GeometryUtils.minY(vertices), GeometryUtils.width(vertices), GeometryUtils.height(vertices));
    }

    public static boolean isConvex(FloatArray vertices) {
        return GeometryUtils.isConvex(GeometryUtils.toVector2Array(vertices));
    }

    public static boolean isConvex(Polygon polygon) {
        tmpFloatArray.clear();
        tmpFloatArray.addAll(polygon.getVertices());
        return GeometryUtils.isConvex(tmpFloatArray);
    }

    public static boolean isConvex(Array<Vector2> vertices) {
        Vector2 v = vec2_1;
        float res = 0.0f;
        for (int i = 0; i < vertices.size; ++i) {
            Vector2 p = vertices.get(i);
            vec2_0.set(vertices.get((i + 1) % vertices.size));
            v.x = GeometryUtils.vec2_0.x - p.x;
            v.y = GeometryUtils.vec2_0.y - p.y;
            Vector2 u = vertices.get((i + 2) % vertices.size);
            if (i == 0) {
                res = u.x * v.y - u.y * v.x + v.x * p.y - v.y * p.x;
                continue;
            }
            float newres = u.x * v.y - u.y * v.x + v.x * p.y - v.y * p.x;
            if (!(newres > 0.0f && res < 0.0f) && (!(newres < 0.0f) || !(res > 0.0f))) continue;
            return false;
        }
        return true;
    }

    public static Polygon[] triangulate(Polygon concave) {
        Array polygonVertices = Pools.obtain(Array.class);
        polygonVertices.clear();
        tmpFloatArray.clear();
        tmpFloatArray.addAll(concave.getTransformedVertices());
        polygonVertices.addAll(GeometryUtils.toVector2Array(tmpFloatArray));
        ShortArray indices = new EarClippingTriangulator().computeTriangles(tmpFloatArray);
        Array vertices = Pools.obtain(Array.class);
        vertices.clear();
        vertices.ensureCapacity(indices.size);
        for (int i = 0; i < indices.size; ++i) {
            vertices.set(i, polygonVertices.get(indices.get(i)));
        }
        Polygon[] polygons = GeometryUtils.toPolygonArray((Array<Vector2>)vertices, 3);
        polygonVertices.clear();
        vertices.clear();
        Pools.free(polygonVertices);
        Pools.free(vertices);
        return polygons;
    }

    public static Polygon[] decompose(Polygon concave) {
        tmpFloatArray.clear();
        tmpFloatArray.addAll(concave.getTransformedVertices());
        Array<Array<Vector2>> convexPolys = BayazitDecomposer.convexPartition(new Array<Vector2>(GeometryUtils.toVector2Array(tmpFloatArray)));
        Polygon[] convexPolygons = new Polygon[convexPolys.size];
        for (int i = 0; i < convexPolygons.length; ++i) {
            convexPolygons[i] = new Polygon(GeometryUtils.toFloatArray(convexPolys.get(i)).toArray());
        }
        return convexPolygons;
    }

    public static Vector2 keepWithin(Vector2 position, float width, float height, float x2, float y2, float width2, float height2) {
        if (width2 < width) {
            position.x = x2 + width2 / 2.0f - width / 2.0f;
        } else if (position.x < x2) {
            position.x = x2;
        } else if (position.x + width > x2 + width2) {
            position.x = x2 + width2 - width;
        }
        if (height2 < height) {
            position.y = y2 + height2 / 2.0f - height / 2.0f;
        } else if (position.y < y2) {
            position.y = y2;
        } else if (position.y + height > y2 + height2) {
            position.y = y2 + height2 - height;
        }
        return position;
    }

    public static Vector2 keepWithin(float x, float y, float width, float height, float rectX, float rectY, float rectWidth, float rectHeight) {
        return GeometryUtils.keepWithin(vec2_0.set(x, y), width, height, rectX, rectY, rectWidth, rectHeight);
    }

    public static Rectangle keepWithin(Rectangle rect, Rectangle other) {
        return rect.setPosition(GeometryUtils.keepWithin(rect.x, rect.y, rect.width, rect.height, other.x, other.y, other.width, other.height));
    }

    public static void keepWithin(OrthographicCamera camera, float x, float y, float width, float height) {
        vec2_0.set(GeometryUtils.keepWithin(camera.position.x - camera.viewportWidth / 2.0f * camera.zoom, camera.position.y - camera.viewportHeight / 2.0f * camera.zoom, camera.viewportWidth * camera.zoom, camera.viewportHeight * camera.zoom, x, y, width, height));
        camera.position.x = GeometryUtils.vec2_0.x + camera.viewportWidth / 2.0f * camera.zoom;
        camera.position.y = GeometryUtils.vec2_0.y + camera.viewportHeight / 2.0f * camera.zoom;
    }

    public static int intersectSegments(Vector2 a, Vector2 b, FloatArray polygon, Vector2 intersection1, Vector2 intersection2) {
        FloatArray intersections = Pools.obtain(FloatArray.class);
        GeometryUtils.intersectSegments(a.x, a.y, b.x, b.y, polygon, true, intersections);
        int size = intersections.size;
        if (size >= 2) {
            intersection1.set(intersections.get(0), intersections.get(1));
            if (size == 4) {
                intersection2.set(intersections.get(2), intersections.get(3));
            } else if (size > 4) assert (false) : "more intersection points with a convex polygon found than possible: " + size;
        }
        Pools.free(intersections);
        return size / 2;
    }

    public static void intersectSegments(Vector2 a, Vector2 b, FloatArray segments, boolean polygon, Array<Vector2> intersections) {
        FloatArray fa = Pools.obtain(FloatArray.class);
        GeometryUtils.intersectSegments(a.x, a.y, b.x, b.y, segments, polygon, fa);
        if (fa.size < 1) {
            intersections.clear();
            Pools.free(fa);
            return;
        }
        intersections.ensureCapacity(fa.size / 2 - intersections.size);
        for (int i = 1; i < fa.size; i += 2) {
            if (intersections.size > i / 2) {
                intersections.get(i / 2).set(fa.get(i - 1), fa.get(i));
                continue;
            }
            intersections.add(new Vector2(fa.get(i - 1), fa.get(i)));
        }
        Pools.free(fa);
    }

    public static void intersectSegments(float x1, float y1, float x2, float y2, FloatArray segments, boolean polygon, FloatArray intersections) {
        if (polygon && segments.size < 6) {
            throw new IllegalArgumentException("a polygon consists of at least 3 points: " + segments.size);
        }
        if (segments.size < 4) {
            throw new IllegalArgumentException("segments does not contain enough vertices to represent at least one segment: " + segments.size);
        }
        if (segments.size % 2 != 0) {
            throw new IllegalArgumentException("malformed segments; the number of vertices is not dividable by 2: " + segments.size);
        }
        intersections.clear();
        vec2_0.setZero();
        int n = segments.size - (polygon ? 0 : 2);
        for (int i = 0; i < n; i += 2) {
            float y4;
            float x4;
            float y3;
            float x3 = segments.get(i);
            if (!Intersector.intersectSegments(x1, y1, x2, y2, x3, y3 = segments.get(i + 1), x4 = ArrayUtils.wrapIndex(i + 2, segments), y4 = ArrayUtils.wrapIndex(i + 3, segments), vec2_0)) continue;
            intersections.add(GeometryUtils.vec2_0.x);
            intersections.add(GeometryUtils.vec2_0.y);
        }
        Pools.free(vec2_0);
    }

    public static <T extends Shape2D> T reset(T shape) {
        if (shape instanceof Polygon) {
            return (T)GeometryUtils.reset((Polygon)shape);
        }
        if (shape instanceof Polyline) {
            return (T)GeometryUtils.reset((Polyline)shape);
        }
        if (shape instanceof Rectangle) {
            return (T)GeometryUtils.reset((Rectangle)shape);
        }
        if (shape instanceof Circle) {
            return (T)GeometryUtils.reset((Circle)shape);
        }
        if (shape instanceof Ellipse) {
            return (T)GeometryUtils.reset((Ellipse)shape);
        }
        return shape;
    }

    public static Polygon reset(Polygon polygon) {
        polygon.setPosition(0.0f, 0.0f);
        polygon.setRotation(0.0f);
        polygon.setOrigin(0.0f, 0.0f);
        polygon.setScale(1.0f, 1.0f);
        float[] vertices = polygon.getVertices();
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = 0.0f;
        }
        polygon.setVertices(vertices);
        return polygon;
    }

    public static Polyline reset(Polyline polyline) {
        polyline.setPosition(0.0f, 0.0f);
        polyline.setRotation(0.0f);
        polyline.setOrigin(0.0f, 0.0f);
        polyline.setScale(1.0f, 1.0f);
        float[] vertices = polyline.getVertices();
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = 0.0f;
        }
        polyline.dirty();
        return polyline;
    }

    public static Rectangle reset(Rectangle rectangle) {
        return rectangle.set(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Circle reset(Circle circle) {
        circle.set(0.0f, 0.0f, 0.0f);
        return circle;
    }

    public static Ellipse reset(Ellipse ellipse) {
        ellipse.set(0.0f, 0.0f, 0.0f, 0.0f);
        return ellipse;
    }
}

