/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class AnimatedSprite
extends Sprite {
    private Animation animation;
    private float time;
    private boolean playing = true;
    private boolean autoUpdate = true;
    private boolean useFrameRegionSize;
    private boolean centerFrames;
    private float oldX;
    private float oldY;
    private float oldWidth;
    private float oldHeight;
    private float oldOriginX;
    private float oldOriginY;

    public AnimatedSprite(Animation animation) {
        super(animation.getKeyFrame(0.0f));
        this.animation = animation;
    }

    public void update() {
        this.update(Gdx.graphics.getDeltaTime());
    }

    public void update(float delta) {
        this.oldX = this.getX();
        this.oldY = this.getY();
        this.oldWidth = this.getWidth();
        this.oldHeight = this.getHeight();
        this.oldOriginX = this.getOriginX();
        this.oldOriginY = this.getOriginY();
        if (this.playing) {
            this.setRegion(this.animation.getKeyFrame(this.time += delta));
            if (this.useFrameRegionSize) {
                this.setSize(this.getRegionWidth(), this.getRegionHeight());
            }
        }
    }

    @Override
    public void draw(Batch batch) {
        boolean centerFramesEnabled;
        if (this.autoUpdate) {
            this.update();
        }
        boolean bl = centerFramesEnabled = this.centerFrames && this.useFrameRegionSize;
        if (centerFramesEnabled) {
            float differenceX = this.oldWidth - (float)this.getRegionWidth();
            float differenceY = this.oldHeight - (float)this.getRegionHeight();
            this.setOrigin(this.oldOriginX - differenceX / 2.0f, this.oldOriginY - differenceY / 2.0f);
            this.setBounds(this.oldX + differenceX / 2.0f, this.oldY + differenceY / 2.0f, this.oldWidth - differenceX, this.oldHeight - differenceY);
        }
        super.draw(batch);
        if (centerFramesEnabled) {
            this.setOrigin(this.oldOriginX, this.oldOriginY);
            this.setBounds(this.oldX, this.oldY, this.oldWidth, this.oldHeight);
        }
    }

    public void flipFrames(boolean flipX, boolean flipY) {
        this.flipFrames(flipX, flipY, false);
    }

    public void flipFrames(boolean flipX, boolean flipY, boolean set) {
        this.flipFrames(0.0f, this.animation.getAnimationDuration(), flipX, flipY, set);
    }

    public void flipFrames(float startTime, float endTime, boolean flipX, boolean flipY) {
        this.flipFrames(startTime, endTime, flipX, flipY, false);
    }

    public void flipFrames(float startTime, float endTime, boolean flipX, boolean flipY, boolean set) {
        for (float t = startTime; t < endTime; t += this.animation.getFrameDuration()) {
            TextureRegion frame = this.animation.getKeyFrame(t);
            frame.flip(set ? flipX && !frame.isFlipX() : flipX, set ? flipY && !frame.isFlipY() : flipY);
        }
    }

    public void play() {
        this.playing = true;
    }

    public void pause() {
        this.playing = false;
    }

    public void stop() {
        this.playing = false;
        this.time = 0.0f;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public float getTime() {
        return this.time;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public boolean isAnimationFinished() {
        return this.animation.isAnimationFinished(this.time);
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isUseFrameRegionSize() {
        return this.useFrameRegionSize;
    }

    public void setUseFrameRegionSize(boolean useFrameRegionSize) {
        this.useFrameRegionSize = useFrameRegionSize;
    }

    public boolean isCenterFrames() {
        return this.centerFrames;
    }

    public void setCenterFrames(boolean centerFrames) {
        this.centerFrames = centerFrames;
    }
}

