/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class AnnotationAssetManager
extends AssetManager {
    public AnnotationAssetManager() {
    }

    public AnnotationAssetManager(FileHandleResolver resolver) {
        super(resolver);
    }

    public void load(Object container) {
        for (Field field : ClassReflection.getDeclaredFields(container.getClass())) {
            if (!field.isAnnotationPresent(Asset.class) || !field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class).load()) continue;
            this.load(field, container);
        }
    }

    public void load(Class<?> container) {
        for (Field field : ClassReflection.getDeclaredFields(container)) {
            if (!field.isAnnotationPresent(Asset.class) || !field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class).load()) continue;
            this.load(field);
        }
    }

    public void load(Field field, Object container) {
        int assetCount = AnnotationAssetManager.getAssetCount(field, container);
        for (int i = 0; i < assetCount; ++i) {
            boolean single;
            boolean bl = single = assetCount == 1;
            if (single) {
                i = -1;
            }
            String path = AnnotationAssetManager.getAssetPath(field, container, i);
            Class<?> type = AnnotationAssetManager.getAssetType(field, container, i);
            AssetLoaderParameters params = AnnotationAssetManager.getAssetLoaderParameters(field, container, i);
            if (path == null || type == null) {
                Gdx.app.debug(ClassReflection.getSimpleName(this.getClass()), '@' + ClassReflection.getSimpleName(Asset.class) + " (" + path + ", " + type + ") " + field.getName());
            }
            this.load(path, type, params);
            if (single) break;
        }
    }

    public void load(Field field) {
        this.load(field, null);
    }

    public static int getAssetCount(Field field, Object container) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            if (field.getType().getSimpleName().endsWith("[]")) {
                return ((Object[])field.get(container)).length;
            }
            return field.get(container) == null ? 0 : 1;
        }
        catch (ReflectionException e) {
            Gdx.app.error("AnnotationAssetManager", "could not access field \"" + field.getName() + "\" of class " + ClassReflection.getSimpleName(field.getDeclaringClass()) + " and instance " + container, e);
            return 1;
        }
    }

    public static String getAssetPath(Field field, Object container, int index) {
        String path = null;
        try {
            Object content;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            Object object = content = index < 0 ? field.get(container) : ((Object[])field.get(container))[index];
            path = content instanceof AssetDescriptor ? ((AssetDescriptor)content).fileName : (content instanceof FileHandle ? ((FileHandle)content).path() : content.toString());
        }
        catch (ReflectionException | IllegalArgumentException e) {
            Gdx.app.error("AnnotationAssetManager", "could not access field \"" + field.getName() + "\"", e);
        }
        return path;
    }

    public static String getAssetPath(Field field, Object container) {
        return AnnotationAssetManager.getAssetPath(field, container, -1);
    }

    public static Class<?> getAssetType(Field field, Object container, int index) {
        if (field.isAnnotationPresent(Asset.class)) {
            return field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class).value();
        }
        if (!ClassReflection.isAssignableFrom(AssetDescriptor.class, field.getType()) && index < 0) {
            return null;
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            Object content;
            Object object = content = index < 0 ? field.get(container) : ((Object[])field.get(container))[index];
            if (content instanceof AssetDescriptor) {
                return ((AssetDescriptor)content).type;
            }
        }
        catch (ReflectionException e) {
            Gdx.app.error("AnnotationAssetManager", "could not access field \"" + field.getName() + "\"", e);
        }
        return null;
    }

    public static Class<?> getAssetType(Field field, Object container) {
        return AnnotationAssetManager.getAssetType(field, container, -1);
    }

    public static <T> AssetLoaderParameters<T> getAssetLoaderParameters(Field field, Object container, int index) {
        String params;
        if (field.isAnnotationPresent(Asset.class) && (params = field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class).params()).length() > 0) {
            Field paramsField = null;
            if (params.contains(".")) {
                int lastPeriod = params.lastIndexOf(46);
                String className = params.substring(0, lastPeriod);
                String fieldName = params.substring(lastPeriod + 1);
                try {
                    paramsField = ClassReflection.getDeclaredField(ClassReflection.forName(className), fieldName);
                }
                catch (ReflectionException e) {
                    Gdx.app.error("AnnotationAssetManager", "could not access class " + className, e);
                }
            } else {
                try {
                    paramsField = ClassReflection.getDeclaredField(field.getDeclaringClass(), params);
                }
                catch (ReflectionException e) {
                    Gdx.app.error("AnnotationAssetManager", "could not access field \"" + field.getName() + "\" of class " + ClassReflection.getSimpleName(field.getDeclaringClass()), e);
                }
            }
            if (paramsField != null) {
                if (ClassReflection.isAssignableFrom(AssetLoaderParameters.class, paramsField.getType())) {
                    try {
                        if (!paramsField.isAccessible()) {
                            paramsField.setAccessible(true);
                        }
                        return (AssetLoaderParameters)paramsField.get(container);
                    }
                    catch (ReflectionException e) {
                        Gdx.app.error("AnnotationAssetManager", "could not access value of field \"" + paramsField.getName() + "\" of class " + ClassReflection.getSimpleName(paramsField.getDeclaringClass()) + " and instance " + container, e);
                    }
                } else {
                    Gdx.app.debug("AnnotationAssetManager", "field \"" + paramsField.getName() + "\" of class " + ClassReflection.getSimpleName(paramsField.getDeclaringClass()) + " and instance " + container + " is not assignable from AssetLoaderParameters");
                }
            }
        }
        if (!ClassReflection.isAssignableFrom(AssetDescriptor.class, field.getType()) && index < 0) {
            return null;
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            Object content;
            Object object = content = index < 0 ? field.get(container) : ((Object[])field.get(container))[index];
            if (content instanceof AssetDescriptor) {
                return ((AssetDescriptor)content).params;
            }
        }
        catch (ReflectionException | IllegalArgumentException e) {
            Gdx.app.error("AnnotationAssetManager", "could not access field\"" + field.getName() + "\"", e);
        }
        return null;
    }

    public static <T> AssetLoaderParameters<T> getAssetLoaderParameters(Field field, Object container) {
        return AnnotationAssetManager.getAssetLoaderParameters(field, container, -1);
    }

    public <T> AssetDescriptor<T> createAssetDescriptor(Field field, Object container) {
        Class fieldType = field.getType();
        Class<?> type = AnnotationAssetManager.getAssetType(field, container, -1);
        if (fieldType == AssetDescriptor.class) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                AssetDescriptor alreadyExistingDescriptor = (AssetDescriptor)field.get(container);
                if (alreadyExistingDescriptor.type == type) {
                    return alreadyExistingDescriptor;
                }
                return new AssetDescriptor(alreadyExistingDescriptor.file, type, alreadyExistingDescriptor.params);
            }
            catch (ReflectionException | IllegalArgumentException e) {
                Gdx.app.error(ClassReflection.getSimpleName(this.getClass()), "couldn't access field \"" + field.getName() + "\"", e);
            }
        } else {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if (fieldType == FileHandle.class) {
                    return new AssetDescriptor((FileHandle)field.get(container), type);
                }
                return new AssetDescriptor(field.get(container).toString(), type);
            }
            catch (ReflectionException | IllegalArgumentException e) {
                Gdx.app.error(ClassReflection.getSimpleName(this.getClass()), "couldn't access field \"" + field.getName() + "\"", e);
            }
        }
        return null;
    }

    public <T> AssetDescriptor<T> createAssetDescriptor(Field field) {
        return this.createAssetDescriptor(field, null);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Asset {
        public boolean load() default true;

        public Class<?> value() default void.class;

        public String params() default "";
    }
}

