/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx;

import com.badlogic.gdx.utils.Array;

public class CutsceneManager {
    private final Array<Cutscene> cutscenes = new Array();

    public void start(Cutscene cutscene) {
        this.cutscenes.add(cutscene);
        cutscene.init();
    }

    public void update(float delta) {
        for (Cutscene cutscene : this.cutscenes) {
            if (!cutscene.update(delta)) continue;
            this.end(cutscene);
        }
    }

    public void end(Cutscene cutscene) {
        this.cutscenes.removeValue(cutscene, true);
        cutscene.end();
    }

    public Array<Cutscene> getCutscenes() {
        return this.cutscenes;
    }

    public static interface Cutscene {
        public void init();

        public boolean update(float var1);

        public void end();
    }
}

