/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;

public class CharSequenceInterpolator {
    private Interpolation interpolation = Interpolation.linear;
    private float charsPerSecond;
    private float time;

    public static float duration(int length, float charsPerSecond) {
        return (float)length * (1.0f / charsPerSecond);
    }

    public static float charsPerSecondFor(float duration, int length) {
        return (float)length / duration;
    }

    public static float linear(float time, float charsPerSecond, int length) {
        return time / CharSequenceInterpolator.duration(length, charsPerSecond);
    }

    public static CharSequence interpolate(CharSequence seq, float time, float charsPerSecond, Interpolation interpolation) {
        return CharSequenceInterpolator.interpolate(seq, time, charsPerSecond, 0, seq.length(), interpolation);
    }

    public static CharSequence interpolate(CharSequence seq, float time, float charsPerSecond, int beginIndex, int endIndex, Interpolation interpolation) {
        return seq.subSequence(beginIndex, (int)MathUtils.clamp(net.dermetfan.utils.math.MathUtils.replaceNaN(interpolation.apply(beginIndex, endIndex, CharSequenceInterpolator.linear(time, charsPerSecond, endIndex - beginIndex)), 0.0f), (float)beginIndex, (float)endIndex));
    }

    public CharSequenceInterpolator(float charsPerSecond) {
        this.charsPerSecond = charsPerSecond;
    }

    public void update(float delta) {
        this.time += delta;
    }

    public CharSequence interpolate(CharSequence seq) {
        return CharSequenceInterpolator.interpolate(seq, this.time, this.charsPerSecond, this.interpolation);
    }

    public CharSequence updateAndInterpolate(CharSequence seq, float delta) {
        this.update(delta);
        return this.interpolate(seq);
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    public float getCharsPerSecond() {
        return this.charsPerSecond;
    }

    public void setCharsPerSecond(float charsPerSecond) {
        this.charsPerSecond = charsPerSecond;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
    }
}

