/*
 * Decompiled with CFR 0.152.
 */
package com.uriopass.audiovisualization;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.io.Mpg123Decoder;
import com.badlogic.gdx.files.FileHandle;
import com.uriopass.audiovisualization.PlayBackThread;
import java.io.File;

public class SoundManager {
    public AudioDevice device;
    Mpg123Decoder decoder;
    public PlayBackThread playBackThread;

    public void load(String file) {
        FileHandle f = new FileHandle(new File(file));
        this.load(f);
    }

    public void load(FileHandle f) {
        this.decoder = new Mpg123Decoder(f);
        Gdx.app.log("Mp3", "channels: " + this.decoder.getChannels() + ", rate: " + this.decoder.getRate() + ", length: " + this.decoder.getLength());
        this.device = Gdx.audio.newAudioDevice(this.decoder.getRate(), this.decoder.getChannels() == 1);
        if (this.playBackThread != null && this.playBackThread.isAlive()) {
            this.playBackThread.stop = true;
        }
        this.playBackThread = new PlayBackThread(this.device, this.decoder);
        this.playBackThread.stop = false;
    }

    public void start() {
        this.playBackThread.start();
    }

    public void stop() {
        this.playBackThread.stop = true;
    }
}

