/*
 * Decompiled with CFR 0.152.
 */
package com.uriopass.audiovisualization;

import java.util.Random;

public class Ball {
    public float x;
    public float y;
    public float vx;
    public float vy;
    public float angle;
    public float size;
    public float random = 0.0f;
    boolean sizeLimit = true;
    public int r;
    public int g;
    public int b;
    public Random rand;

    public Ball(int x, int y, Random r) {
        this.x = x;
        this.y = y;
        this.size = 100.0f;
        this.rand = r;
        this.generateColor();
    }

    public void generateColor() {
        this.r = (int)(this.rand.nextFloat() * 255.0f);
        this.g = (int)(this.rand.nextFloat() * 255.0f);
        this.b = (int)(this.rand.nextFloat() * 255.0f);
    }

    public void update(int width, int height, float delta) {
        this.x += this.vx * delta;
        this.y += this.vy * delta;
        if (this.x > (float)width) {
            this.x = width;
            this.angle = (float)((double)this.angle + 1.5707963267948966);
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.angle = (float)((double)this.angle + 1.5707963267948966);
        }
        if (this.y > (float)height) {
            this.y = height;
            this.angle = (float)((double)this.angle + 1.5707963267948966);
        }
        if (this.y < 0.0f) {
            this.y = 0.0f;
            this.angle = (float)((double)this.angle + 1.5707963267948966);
        }
        this.size -= this.size * 1.2f * delta;
        if (this.size < 100.0f && this.sizeLimit) {
            this.size = 100.0f;
        }
        if (this.size > 500.0f) {
            this.size = 500.0f;
        }
    }
}

