/*
 * Decompiled with CFR 0.152.
 */
package com.uriopass.audiovisualization;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.analysis.FFT;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisSlider;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.FileChooserAdapter;
import com.uriopass.audiovisualization.Ball;
import com.uriopass.audiovisualization.PlayBackThread;
import com.uriopass.audiovisualization.SoundManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class AudioVisualization
extends ApplicationAdapter {
    boolean motionBlur = false;
    boolean waveLength = true;
    boolean monochrome = false;
    boolean aligned = false;
    float puissance = 0.0f;
    int nbBaloons = 15;
    boolean microphone = false;
    ArrayList<Ball> balls;
    Ball beatBall;
    private Stage stage;
    private Table table;
    private ShapeRenderer shapeRenderer;
    String musicDir = "C:/Users/Uriopass/Music/";
    String songName = "getup.mp3";
    Random r;
    FileChooser choser;
    FFT fft;
    SoundManager sm;
    public static int samples = 1024;
    SpriteBatch sb;
    VisSlider slide;
    float deltaTime = 0.008333334f;
    float angle = 0.0f;
    int last = 0;
    boolean sens = true;
    int moyenneFrames = 300;
    float[] lastMeanSum = new float[this.nbBaloons];
    float[][] meanSum = new float[this.moyenneFrames][this.nbBaloons];
    float[] globalMeanSumTab = new float[this.moyenneFrames];
    float globalSum = 0.0f;
    int width;
    int height;
    float globalMeanSum = 0.0f;
    ShapeRenderer sr;
    float lastLength = 0.0f;
    float r2;
    float g;
    float b;
    float a;
    HashMap<Integer, Sprite> circles;
    int[] sizes = new int[]{100, 200, 500, 1000};

    @Override
    public void create() {
        this.r = new Random(Integer.valueOf(154).hashCode());
        this.width = Gdx.graphics.getWidth();
        this.height = Gdx.graphics.getHeight();
        this.sm = new SoundManager();
        this.fft = new FFT(samples, 44100.0f);
        this.balls = new ArrayList();
        this.beatBall = new Ball(this.width / 2, this.height / 2, this.r);
        int i = 0;
        while (i < this.nbBaloons) {
            this.balls.add(new Ball((int)(this.r.nextFloat() * (float)this.width), (int)(this.r.nextFloat() * (float)this.height), this.r));
            this.balls.get((int)i).angle = (float)((double)this.r.nextFloat() * Math.PI * 2.0);
            ++i;
        }
        this.beatBall.sizeLimit = false;
        VisUI.load();
        this.stage = new Stage();
        Gdx.input.setInputProcessor(this.stage);
        this.table = new Table();
        this.table.setFillParent(true);
        this.stage.addActor(this.table);
        this.slide = new VisSlider(0.0f, 3.0f, 0.03f, false);
        this.slide.setBounds(Gdx.graphics.getWidth() / 2 - 50, Gdx.graphics.getHeight() - 20, 100.0f, 20.0f);
        this.slide.setValue(1.0f);
        this.choser = new FileChooser("Music", FileChooser.Mode.OPEN);
        this.choser.setBounds(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.choser.setSelectionMode(FileChooser.SelectionMode.FILES_AND_DIRECTORIES);
        this.choser.setListener(new FileChooserAdapter(){

            @Override
            public void selected(FileHandle file) {
                AudioVisualization.this.sm.load(file);
                AudioVisualization.this.sm.start();
            }
        });
        this.table.addActor(this.choser);
        this.table.addActor(this.slide);
        this.sb = new SpriteBatch();
        this.sr = new ShapeRenderer();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void render() {
        Gdx.gl.glClear(16384);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.puissance = this.slide.getValue();
        this.deltaTime = Gdx.graphics.getDeltaTime();
        boolean beat2 = false;
        if (this.motionBlur) {
            System.out.println("Motion blur not supported");
        }
        if (this.sm.playBackThread != null && !this.sm.playBackThread.stop) {
            PlayBackThread cfr_ignored_0 = this.sm.playBackThread;
            this.fft.forward(PlayBackThread.lastSamples);
            float[] sum = new float[this.nbBaloons];
            this.sr.begin(ShapeRenderer.ShapeType.Filled);
            this.sr.setColor(0.5f, 0.0f, 0.0f, 0.5f);
            int i = 0;
            while (i < this.fft.specSize() / 2) {
                float a = this.fft.getBand(i) * this.puissance;
                float b = a * (float)((i + 3) / 3);
                int n = i % 15;
                sum[n] = sum[n] + b;
                this.globalSum += b;
                if (this.waveLength) {
                    this.sr.rect((float)this.width * (((float)i + 0.0f) / (float)(this.fft.specSize() / 2)), 0.0f, 5.0f, b);
                }
                ++i;
            }
            this.sr.end();
            this.globalMeanSum -= this.globalMeanSumTab[this.moyenneFrames - 1];
            i = this.moyenneFrames - 1;
            while (i > 0) {
                this.globalMeanSumTab[i] = this.globalMeanSumTab[i - 1];
                --i;
            }
            this.globalSum /= 10.0f;
            this.globalMeanSumTab[0] = this.globalSum;
            this.globalMeanSum += this.globalSum;
            this.globalSum -= this.globalMeanSum / (float)this.moyenneFrames;
            if (this.globalSum < 0.0f) {
                this.globalSum /= 10.0f;
            }
            i = 0;
            while (i < this.nbBaloons) {
                int n = i;
                this.lastMeanSum[n] = this.lastMeanSum[n] - this.meanSum[this.moyenneFrames - 1][i];
                ++i;
            }
            i = this.moyenneFrames - 1;
            while (i > 0) {
                int j = 0;
                while (j < this.nbBaloons) {
                    this.meanSum[i][j] = this.meanSum[i - 1][j];
                    ++j;
                }
                --i;
            }
            i = 0;
            while (i < this.nbBaloons) {
                this.meanSum[0][i] = sum[i];
                int n = i;
                this.lastMeanSum[n] = this.lastMeanSum[n] + sum[i];
                int n2 = i;
                sum[n2] = sum[n2] - this.lastMeanSum[i] / (float)this.moyenneFrames;
                ++i;
            }
            i = 0;
            while (i < this.nbBaloons) {
                Ball b = this.balls.get(i);
                b.size += sum[i] / 10.0f;
                ++i;
            }
            float totalMass = 300 * this.nbBaloons;
            float countedMass = 0.0f;
            for (Ball b : this.balls) {
                countedMass += b.size;
            }
            if (countedMass > totalMass) {
                float toRemove = countedMass - totalMass;
                for (Ball ball : this.balls) {
                    float ratio = ball.size / countedMass;
                    ball.size -= ratio * toRemove;
                }
            }
            this.sb.begin();
            this.setColor(0.5f, 0.0f, 0.0f, 0.3f);
            this.beatBall.update(this.width, this.height, this.deltaTime);
            this.drawCircle(this.beatBall.x, this.beatBall.y, this.beatBall.size);
            Gdx.graphics.setTitle("Visu : " + Gdx.graphics.getFramesPerSecond());
            if (beat2) {
                this.sens = !this.sens;
                for (Ball b : this.balls) {
                    b.random = b.rand.nextFloat() - 0.5f;
                    b.random *= 2.0f;
                }
            }
            float rawLength = 100.0f + this.globalSum * this.globalSum / 3.0f;
            float f = this.lastLength + (rawLength - this.lastLength) / 10.0f;
            int i2 = 0;
            while (i2 < this.nbBaloons) {
                float angle;
                if (this.monochrome) {
                    float a = ((float)i2 + 0.0f) / (float)this.nbBaloons;
                    this.setColor(a, 1.0f - a, 0.0f, 0.5f);
                }
                Ball b = this.balls.get(i2);
                if (beat2 && !this.monochrome) {
                    b.generateColor();
                }
                if (!this.monochrome) {
                    this.setColor((float)b.r / 255.0f, (float)b.g / 255.0f, (float)b.b / 255.0f, 0.39215687f);
                }
                if ((angle = this.globalSum) > 30.0f) {
                    angle = 30.0f;
                }
                angle += b.random * (angle * 100.0f / 100.0f);
                b.angle = b.angle + (float)(this.sens ? 1 : -1) * angle * this.deltaTime / 5.0f;
                if (f > 1000.0f) {
                    f = 1000.0f;
                }
                b.vx = (float)(Math.cos(b.angle) * (double)f);
                b.vy = (float)(Math.sin(b.angle) * (double)f);
                if (this.aligned) {
                    this.drawCircle(50.0f + ((float)i2 + 0.0f) / (float)this.nbBaloons * (float)(this.width - 100), this.height / 2, b.size);
                } else {
                    this.drawCircle(b.x, b.y, b.size);
                }
                b.update(this.width, this.height, this.deltaTime);
                ++i2;
            }
            this.lastLength = f;
            this.sb.end();
        } else if (!this.choser.isVisible()) {
            this.choser.setVisble(true);
            this.choser.setBounds(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        }
        this.stage.act(Gdx.graphics.getDeltaTime());
        this.stage.draw();
    }

    @Override
    public void dispose() {
        VisUI.dispose();
        this.stage.dispose();
        this.sr.dispose();
    }

    private void setColor(float r, float g, float b, float a) {
        this.r2 = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    private void drawCircle(float x, float y, float radius) {
        if (this.circles == null) {
            this.circles = new HashMap();
            int[] nArray = this.sizes;
            int n = this.sizes.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                Texture t = new Texture("circle" + s + ".png");
                t.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                this.circles.put(s, new Sprite(t));
                ++n2;
            }
        }
        int betterSize = 1000;
        int minVal = 10000;
        int[] nArray = this.sizes;
        int n = this.sizes.length;
        int n3 = 0;
        while (n3 < n) {
            int s = nArray[n3];
            int dif = (int)Math.abs(radius - (float)s);
            if (dif < minVal) {
                minVal = dif;
                betterSize = s;
            }
            ++n3;
        }
        Sprite toChange = null;
        toChange = this.circles.get(betterSize);
        toChange.setColor(this.r2, this.g, this.b, 1.0f);
        toChange.setScale(radius / toChange.getWidth());
        toChange.setPosition(x - toChange.getWidth() / 2.0f, y - toChange.getWidth() / 2.0f);
        toChange.draw(this.sb, this.a);
    }

    String sketchPath(String fileName) {
        return fileName;
    }

    InputStream createInput(String fileName) {
        try {
            return new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

