/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.tabbedpane;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Scaling;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.i18n.BundleText;
import com.kotcrab.vis.ui.util.dialog.DialogUtils;
import com.kotcrab.vis.ui.util.dialog.OptionDialogAdapter;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.tabbedpane.Tab;
import com.kotcrab.vis.ui.widget.tabbedpane.TabbedPaneListener;

public class TabbedPane {
    private TabbedPaneStyle style;
    private VisTable tabsTable;
    private VisTable mainTable;
    private Array<Tab> tabs;
    private ObjectMap<Tab, TabButtonTable> tabsButtonMap;
    private ButtonGroup<Button> group;
    private Tab activeTab;
    private Array<TabbedPaneListener> listeners;
    private boolean allowTabDeselect;

    public TabbedPane() {
        this(VisUI.getSkin().get(TabbedPaneStyle.class));
    }

    public TabbedPane(String styleName) {
        this(VisUI.getSkin().get(styleName, TabbedPaneStyle.class));
    }

    public TabbedPane(TabbedPaneStyle style) {
        this.style = style;
        this.listeners = new Array();
        this.group = new ButtonGroup();
        this.mainTable = new VisTable();
        this.tabsTable = new VisTable();
        this.mainTable.setBackground(style.background);
        this.tabs = new Array();
        this.tabsButtonMap = new ObjectMap();
        this.mainTable.add(this.tabsTable).left().expand();
        this.mainTable.row();
        if (style.bottomBar != null) {
            this.mainTable.add(new Image(style.bottomBar)).expand().fill().height(style.bottomBar.getMinHeight());
        }
    }

    public void setAllowTabDeselect(boolean allowTabDeselect) {
        this.allowTabDeselect = allowTabDeselect;
        if (allowTabDeselect) {
            this.group.setMinCheckCount(0);
        } else {
            this.group.setMinCheckCount(1);
        }
    }

    public boolean isAllowTabDeselect() {
        return this.allowTabDeselect;
    }

    public void add(Tab tab) {
        tab.setPane(this);
        this.tabs.add(tab);
        this.rebuildTabsTable();
        this.switchTab(tab);
    }

    public void insert(int index, Tab tab) {
        tab.setPane(this);
        this.tabs.insert(index, tab);
        this.rebuildTabsTable();
    }

    public boolean remove(Tab tab) {
        return this.remove(tab, true);
    }

    public boolean remove(final Tab tab, boolean ignoreTabDirty) {
        if (ignoreTabDirty) {
            return this.removeTab(tab);
        }
        if (!tab.isDirty() || this.mainTable.getStage() == null) {
            return this.removeTab(tab);
        }
        DialogUtils.showOptionDialog(this.mainTable.getStage(), this.get(Text.UNSAVED_DIALOG_TITLE), this.get(Text.UNSAVED_DIALOG_TEXT), DialogUtils.OptionDialogType.YES_NO_CANCEL, new OptionDialogAdapter(){

            @Override
            public void yes() {
                tab.save();
                TabbedPane.this.removeTab(tab);
            }

            @Override
            public void no() {
                TabbedPane.this.removeTab(tab);
            }
        });
        return false;
    }

    private boolean removeTab(Tab tab) {
        int index = this.tabs.indexOf(tab, true);
        boolean success = this.tabs.removeValue(tab, true);
        if (success) {
            tab.setPane(null);
            tab.dispose();
            this.notifyListenersRemoved(tab);
            if (this.tabs.size == 0) {
                this.notifyListenersRemovedAll();
            } else if (this.activeTab == tab && index != 0) {
                this.switchTab(--index);
            }
            this.rebuildTabsTable();
        }
        return success;
    }

    public void removeAll() {
        for (Tab tab : this.tabs) {
            tab.setPane(null);
            tab.dispose();
        }
        this.tabs.clear();
        this.rebuildTabsTable();
        this.notifyListenersRemovedAll();
    }

    public void switchTab(int index) {
        this.tabsButtonMap.get(this.tabs.get(index)).select();
    }

    public void switchTab(Tab tab) {
        this.tabsButtonMap.get(tab).select();
    }

    public void updateTabTitle(Tab tab) {
        this.tabsButtonMap.get((Tab)tab).button.setText(this.getTabTitle(tab));
    }

    private String getTabTitle(Tab tab) {
        String title = tab.getTabTitle();
        if (tab.isDirty()) {
            title = "*" + title;
        }
        return title;
    }

    private void rebuildTabsTable() {
        Tab lastSelectedTab = this.activeTab;
        this.tabsTable.clear();
        this.group.clear();
        this.tabsButtonMap.clear();
        for (Tab tab : this.tabs) {
            TabButtonTable buttonTable = new TabButtonTable(tab);
            this.tabsTable.add(buttonTable);
            this.tabsButtonMap.put(tab, buttonTable);
            this.group.add(buttonTable.button);
            if (this.tabs.size == 1 && lastSelectedTab != null) {
                buttonTable.select();
                this.notifyListenersSwitched(tab);
            }
            if (tab != lastSelectedTab) continue;
            buttonTable.select();
        }
    }

    public Table getTable() {
        return this.mainTable;
    }

    public Tab getActiveTab() {
        return this.activeTab;
    }

    public void addListener(TabbedPaneListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(TabbedPaneListener listener) {
        return this.listeners.removeValue(listener, true);
    }

    private void notifyListenersSwitched(Tab tab) {
        for (TabbedPaneListener listener : this.listeners) {
            listener.switchedTab(tab);
        }
    }

    private void notifyListenersRemoved(Tab tab) {
        for (TabbedPaneListener listener : this.listeners) {
            listener.removedTab(tab);
        }
    }

    private void notifyListenersRemovedAll() {
        for (TabbedPaneListener listener : this.listeners) {
            listener.removedAllTabs();
        }
    }

    public Array<Tab> getTabs() {
        return this.tabs;
    }

    private String get(Text text) {
        return VisUI.getTabbedPaneBundle().get(text.getName());
    }

    private static enum Text implements BundleText
    {
        UNSAVED_DIALOG_TITLE{

            @Override
            public String getName() {
                return "unsavedDialogTitle";
            }
        }
        ,
        UNSAVED_DIALOG_TEXT{

            @Override
            public String getName() {
                return "unsavedDialogText";
            }
        };


        @Override
        public String get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(Object ... arguments) {
            throw new UnsupportedOperationException();
        }
    }

    private class TabButtonTable
    extends VisTable {
        public VisTextButton button;
        public VisImageButton closeButton;
        private Tab tab;
        private VisTextButton.VisTextButtonStyle buttonStyle;
        private VisImageButton.VisImageButtonStyle closeButtonStyle;

        public TabButtonTable(Tab tab) {
            this.tab = tab;
            this.button = new VisTextButton(TabbedPane.this.getTabTitle(tab), ((TabbedPane)TabbedPane.this).style.buttonStyle);
            this.button.setFocusBorderEnabled(false);
            this.closeButton = new VisImageButton("close");
            this.closeButton.getImage().setScaling(Scaling.fill);
            this.closeButton.getImage().setColor(Color.RED);
            this.addListeners();
            this.buttonStyle = (VisTextButton.VisTextButtonStyle)this.button.getStyle();
            this.closeButtonStyle = this.closeButton.getStyle();
            this.add(this.button);
            if (tab.isCloseableByUser()) {
                this.add(this.closeButton).size(14.0f, this.button.getHeight());
            }
        }

        private void addListeners() {
            this.closeButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    TabButtonTable.this.closeTab();
                }
            });
            this.button.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int mouseButton) {
                    ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = ((TabButtonTable)TabButtonTable.this).buttonStyle.down;
                    if (mouseButton == 2) {
                        TabButtonTable.this.closeTab();
                    }
                    return false;
                }

                @Override
                public boolean mouseMoved(InputEvent event, float x, float y) {
                    if (TabbedPane.this.activeTab != TabButtonTable.this.tab) {
                        ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = ((TabButtonTable)TabButtonTable.this).buttonStyle.over;
                    }
                    return false;
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    if (TabbedPane.this.activeTab != TabButtonTable.this.tab) {
                        ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = ((TabButtonTable)TabButtonTable.this).buttonStyle.up;
                    }
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    if (TabbedPane.this.activeTab != TabButtonTable.this.tab && !Gdx.input.justTouched()) {
                        ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = ((TabButtonTable)TabButtonTable.this).buttonStyle.over;
                    }
                }
            });
            this.button.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (TabButtonTable.this.button.isChecked()) {
                        if (TabbedPane.this.activeTab != null) {
                            TabButtonTable table = (TabButtonTable)TabbedPane.this.tabsButtonMap.get(TabbedPane.this.activeTab);
                            if (table != null) {
                                table.deselect();
                            }
                            TabbedPane.this.activeTab.onHide();
                        }
                        TabbedPane.this.activeTab = TabButtonTable.this.tab;
                        TabbedPane.this.notifyListenersSwitched(TabButtonTable.this.tab);
                        TabButtonTable.this.tab.onShow();
                        ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = ((TabButtonTable)TabButtonTable.this).buttonStyle.down;
                        ((TabButtonTable)TabButtonTable.this).closeButtonStyle.over = null;
                    } else if (TabbedPane.this.group.getChecked() == null) {
                        if (TabbedPane.this.activeTab != null) {
                            TabButtonTable table = (TabButtonTable)TabbedPane.this.tabsButtonMap.get(TabbedPane.this.activeTab);
                            if (table != null) {
                                table.deselect();
                            }
                            TabbedPane.this.activeTab.onHide();
                        }
                        TabbedPane.this.activeTab = null;
                        TabbedPane.this.notifyListenersSwitched(null);
                    }
                }
            });
        }

        private void closeTab() {
            if (this.tab.isCloseableByUser()) {
                TabbedPane.this.remove(this.tab, false);
            }
        }

        public void select() {
            this.button.setChecked(true);
        }

        public void deselect() {
            this.closeButtonStyle.up = this.buttonStyle.up;
            this.closeButtonStyle.over = this.buttonStyle.over;
        }
    }

    public static class TabbedPaneStyle {
        public Drawable bottomBar;
        public Drawable background;
        public VisTextButton.VisTextButtonStyle buttonStyle;

        public TabbedPaneStyle() {
        }

        public TabbedPaneStyle(TabbedPaneStyle other) {
            this.bottomBar = other.bottomBar;
            this.background = other.background;
            this.buttonStyle = other.buttonStyle;
        }

        public TabbedPaneStyle(Drawable background, Drawable bottomBar, VisTextButton.VisTextButtonStyle buttonStyle) {
            this.background = background;
            this.bottomBar = bottomBar;
            this.buttonStyle = buttonStyle;
        }
    }
}

