/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.I18NBundle;
import com.kotcrab.vis.ui.util.dialog.DialogUtils;
import com.kotcrab.vis.ui.util.dialog.OptionDialogAdapter;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.FileChooserText;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

public class FilePopupMenu
extends PopupMenu {
    private FileChooser chooser;
    private I18NBundle bundle;
    private FileHandle file;
    private MenuItem delete;
    private MenuItem showInExplorer;
    private MenuItem addToFavorites;
    private MenuItem removeFromFavorites;

    public FilePopupMenu(String styleName, FileChooser fileChooser, I18NBundle bundle) {
        super(styleName);
        this.chooser = fileChooser;
        this.bundle = bundle;
        this.delete = new MenuItem(this.getText(FileChooserText.CONTEXT_MENU_DELETE));
        this.showInExplorer = new MenuItem(this.getText(FileChooserText.CONTEXT_MENU_SHOW_IN_EXPLORER));
        this.addToFavorites = new MenuItem(this.getText(FileChooserText.CONTEXT_MENU_ADD_TO_FAVORITES));
        this.removeFromFavorites = new MenuItem(this.getText(FileChooserText.CONTEXT_MENU_REMOVE_FROM_FAVORITES));
        this.delete.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                DialogUtils.showOptionDialog(FilePopupMenu.this.getStage(), FilePopupMenu.this.getText(FileChooserText.POPUP_TITLE), FilePopupMenu.this.getText(FileChooserText.CONTEXT_MENU_DELETE_WARNING), DialogUtils.OptionDialogType.YES_NO, new OptionDialogAdapter(){

                    @Override
                    public void yes() {
                        FilePopupMenu.this.file.delete();
                        FilePopupMenu.this.chooser.refresh();
                    }
                });
            }
        });
        this.showInExplorer.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                try {
                    if (FilePopupMenu.this.file.isDirectory()) {
                        Desktop.getDesktop().open(FilePopupMenu.this.file.file());
                    } else {
                        Desktop.getDesktop().open(FilePopupMenu.this.file.parent().file());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.addToFavorites.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                FilePopupMenu.this.chooser.addFavorite(FilePopupMenu.this.file);
            }
        });
        this.removeFromFavorites.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                FilePopupMenu.this.chooser.removeFavorite(FilePopupMenu.this.file);
            }
        });
    }

    public void build(Array<FileHandle> favorites, FileHandle file) {
        this.file = file;
        this.clearChildren();
        if (file.type() == Files.FileType.Absolute || file.type() == Files.FileType.External) {
            this.addItem(this.delete);
        }
        if (file.type() == Files.FileType.Absolute) {
            this.addItem(this.showInExplorer);
            if (file.isDirectory()) {
                if (favorites.contains(file, false)) {
                    this.addItem(this.removeFromFavorites);
                } else {
                    this.addItem(this.addToFavorites);
                }
            }
        }
    }

    public void buildForFavorite(Array<FileHandle> favorites, File file) {
        this.file = Gdx.files.absolute(file.getAbsolutePath());
        this.clearChildren();
        this.addItem(this.showInExplorer);
        if (favorites.contains(this.file, false)) {
            this.addItem(this.removeFromFavorites);
        }
    }

    private String getText(FileChooserText text) {
        return this.bundle.get(text.getName());
    }
}

