/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.dialog.DialogUtils;
import com.kotcrab.vis.ui.util.dialog.OptionDialogAdapter;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisSplitPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.kotcrab.vis.ui.widget.file.FavoritesIO;
import com.kotcrab.vis.ui.widget.file.FileChooserAdapter;
import com.kotcrab.vis.ui.widget.file.FileChooserListener;
import com.kotcrab.vis.ui.widget.file.FileChooserStyle;
import com.kotcrab.vis.ui.widget.file.FileChooserText;
import com.kotcrab.vis.ui.widget.file.FilePopupMenu;
import com.kotcrab.vis.ui.widget.file.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import javax.swing.filechooser.FileSystemView;

public class FileChooser
extends VisWindow {
    private static final long FILE_WATCHER_CHECK_DELAY_MILLIS = 2000L;
    private Mode mode;
    private SelectionMode selectionMode = SelectionMode.FILES;
    private FileChooserListener listener;
    private FileFilter fileFilter = new DefaultFileFilter();
    private boolean multiselectionEnabled = false;
    private int groupMultiselectKey = 59;
    private int multiselectKey = 129;
    private FavoritesIO favoritesIO;
    private Array<FileHandle> favorites;
    private FileHandle currentDirectory;
    private Array<FileItem> selectedItems = new Array();
    private ShortcutItem selectedShortcut;
    private Array<FileHandle> history = new Array();
    private Array<FileHandle> historyForward = new Array();
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private ObjectMap<File, String> fileRootsSystemNameCache = new ObjectMap();
    private Array<ShortcutItem> fileRootsCache = new Array();
    private boolean watchingFilesEnabled = true;
    private Thread fileWatcherThread;
    private boolean shortcutsListRebuildScheduled;
    private boolean filesListRebuildScheduled;
    private FileChooserStyle style;
    private I18NBundle bundle;
    private VisTable fileTable;
    private VisScrollPane fileScrollPane;
    private VisTable fileScrollPaneTable;
    private VisTable shortcutsTable;
    private VisScrollPane shortcutsScrollPane;
    private VisTable shortcutsScrollPaneTable;
    private VisImageButton backButton;
    private VisImageButton forwardButton;
    private VisTextField currentPath;
    private VisTextField selectedFileTextField;
    private FilePopupMenu fileMenu;

    public FileChooser(Mode mode) {
        super("");
        this.bundle = VisUI.getFileChooserBundle();
        this.mode = mode;
        this.getTitleLabel().setText(this.getText(FileChooserText.TITLE_CHOOSE_FILES));
        this.style = VisUI.getSkin().get(FileChooserStyle.class);
        this.init();
    }

    public FileChooser(String title, Mode mode) {
        this("default", title, mode);
    }

    public FileChooser(String styleName, String title, Mode mode) {
        super(title);
        this.mode = mode;
        this.bundle = VisUI.getFileChooserBundle();
        this.style = VisUI.getSkin().get(styleName, FileChooserStyle.class);
        this.init();
    }

    public FileChooser(I18NBundle bundle, Mode mode) {
        super("");
        this.mode = mode;
        this.bundle = bundle;
        this.getTitleLabel().setText(this.getText(FileChooserText.TITLE_CHOOSE_FILES));
        this.style = VisUI.getSkin().get(FileChooserStyle.class);
        this.init();
    }

    public FileChooser(I18NBundle bundle, String title, Mode mode) {
        super(title);
        this.mode = mode;
        this.bundle = bundle;
        this.style = VisUI.getSkin().get(FileChooserStyle.class);
        this.init();
    }

    public static void setFavoritesPrefsName(String name) {
        FavoritesIO.setFavoritesPrefsName(name);
    }

    private void init() {
        this.setModal(true);
        this.setResizable(true);
        this.setMovable(true);
        this.addCloseButton();
        this.closeOnEscape();
        this.favoritesIO = new FavoritesIO();
        this.favoritesIO.checkIfUsingDefaultName();
        this.favorites = this.favoritesIO.loadFavorites();
        this.createToolbar();
        this.createCenterContentPanel();
        this.createFileTextBox();
        this.createBottomButtons();
        this.fileMenu = new FilePopupMenu(this.style.popupMenuStyleName, this, this.bundle);
        this.rebuildShortcutsList();
        this.setDirectory(Gdx.files.absolute(System.getProperty("user.home")), HistoryPolicy.IGNORE);
        this.setSize(500.0f, 600.0f);
        this.centerWindow();
        this.validateSettings();
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 29 && Gdx.input.isKeyPressed(129)) {
                    FileChooser.this.selectAll();
                    return true;
                }
                return false;
            }
        });
    }

    private String getText(FileChooserText text) {
        return this.bundle.get(text.getName());
    }

    private void createToolbar() {
        VisTable toolbarTable = new VisTable(true);
        toolbarTable.defaults().minWidth(30.0f).right();
        this.add(toolbarTable).fillX().expandX().pad(3.0f).padRight(2.0f);
        this.backButton = new VisImageButton(this.style.iconArrowLeft);
        this.backButton.setGenerateDisabledImage(true);
        this.backButton.setDisabled(true);
        this.forwardButton = new VisImageButton(this.style.iconArrowRight);
        this.forwardButton.setGenerateDisabledImage(true);
        this.forwardButton.setDisabled(true);
        this.currentPath = new VisTextField();
        this.currentPath.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 66) {
                    FileHandle file = Gdx.files.absolute(FileChooser.this.currentPath.getText());
                    if (file.exists()) {
                        FileChooser.this.setDirectory(file, HistoryPolicy.ADD);
                    } else {
                        FileChooser.this.showDialog(FileChooser.this.getText(FileChooserText.POPUP_DIRECTORY_DOES_NOT_EXIST));
                        FileChooser.this.currentPath.setText(FileChooser.this.currentDirectory.path());
                    }
                }
                return false;
            }
        });
        VisImageButton folderParentButton = new VisImageButton(this.style.iconFolderParent);
        folderParentButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileHandle parent = FileChooser.this.currentDirectory.parent();
                if (FileUtils.isWindows() && FileChooser.this.currentDirectory.path().endsWith(":/")) {
                    return;
                }
                FileChooser.this.setDirectory(parent, HistoryPolicy.ADD);
            }
        });
        toolbarTable.add(this.backButton);
        toolbarTable.add(this.forwardButton);
        toolbarTable.add(this.currentPath).expand().fill();
        toolbarTable.add(folderParentButton);
        this.backButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.historyBack();
            }
        });
        this.forwardButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.historyForward();
            }
        });
    }

    private void createCenterContentPanel() {
        this.fileTable = new VisTable();
        this.fileScrollPane = this.createScrollPane(this.fileTable);
        this.fileScrollPaneTable = new VisTable();
        this.fileScrollPaneTable.add(this.fileScrollPane).pad(2.0f).top().expand().fillX();
        this.shortcutsTable = new VisTable();
        this.shortcutsScrollPane = this.createScrollPane(this.shortcutsTable);
        this.shortcutsScrollPaneTable = new VisTable();
        this.shortcutsScrollPaneTable.add(this.shortcutsScrollPane).pad(2.0f).top().expand().fillX();
        VisSplitPane splitPane = new VisSplitPane(this.shortcutsScrollPaneTable, this.fileScrollPaneTable, false);
        splitPane.setSplitAmount(0.3f);
        splitPane.setMinSplitAmount(0.05f);
        splitPane.setMaxSplitAmount(0.8913f);
        this.row();
        this.add(splitPane).expand().fill();
        this.row();
    }

    private void createFileTextBox() {
        VisTable table = new VisTable(true);
        VisLabel nameLabel = new VisLabel(this.getText(FileChooserText.FILE_NAME));
        this.selectedFileTextField = new VisTextField();
        table.add(nameLabel);
        table.add(this.selectedFileTextField).expand().fill();
        this.selectedFileTextField.addListener(new InputListener(){

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                FileChooser.this.deselectAll(false);
                return false;
            }
        });
        this.add(table).expandX().fillX().pad(3.0f).padRight(2.0f).padBottom(2.0f);
        this.row();
    }

    private void createBottomButtons() {
        VisTextButton cancelButton = new VisTextButton(this.getText(FileChooserText.CANCEL));
        VisTextButton confirmButton = new VisTextButton(this.mode == Mode.OPEN ? this.getText(FileChooserText.OPEN) : this.getText(FileChooserText.SAVE));
        VisTable buttonTable = new VisTable(true);
        buttonTable.defaults().minWidth(70.0f).right();
        this.add(buttonTable).padTop(3.0f).padBottom(3.0f).padRight(2.0f).fillX().expandX();
        buttonTable.add(cancelButton).expand().right();
        buttonTable.add(confirmButton);
        cancelButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.fadeOut();
                FileChooser.this.listener.canceled();
            }
        });
        confirmButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.selectionFinished();
            }
        });
    }

    private void selectionFinished() {
        Array<FileHandle> files;
        if (this.selectedItems.size == 1) {
            FileHandle selected;
            if (this.selectionMode == SelectionMode.FILES && (selected = this.selectedItems.get((int)0).file).isDirectory()) {
                this.setDirectory(selected, HistoryPolicy.ADD);
                return;
            }
            if (this.selectionMode == SelectionMode.DIRECTORIES && !(selected = this.selectedItems.get((int)0).file).isDirectory()) {
                this.showDialog(this.getText(FileChooserText.POPUP_ONLY_DIRECTORIES));
                return;
            }
        }
        if (this.selectedItems.size > 0 || this.mode == Mode.SAVE) {
            files = this.getFileListFromSelected();
            this.notifyListenerAndCloseDialog(files);
        } else if (this.selectionMode == SelectionMode.FILES) {
            this.showDialog(this.getText(FileChooserText.POPUP_CHOOSE_FILE));
        } else {
            files = new Array();
            files.add(this.currentDirectory);
            this.notifyListenerAndCloseDialog(files);
        }
    }

    @Override
    protected void close() {
        this.listener.canceled();
        super.close();
    }

    private void notifyListenerAndCloseDialog(Array<FileHandle> files) {
        if (files == null) {
            return;
        }
        if (this.mode == Mode.OPEN) {
            for (FileHandle file : files) {
                if (file.exists()) continue;
                this.showDialog(this.getText(FileChooserText.POPUP_SELECTED_FILE_DOES_NOT_EXIST));
                return;
            }
        }
        this.listener.selected(files);
        this.listener.selected(files.get(0));
        this.fadeOut();
    }

    private VisScrollPane createScrollPane(VisTable table) {
        VisScrollPane scrollPane = new VisScrollPane(table);
        scrollPane.setOverscroll(false, true);
        scrollPane.setFadeScrollBars(false);
        scrollPane.setScrollingDisabled(true, false);
        return scrollPane;
    }

    private Array<FileHandle> getFileListFromSelected() {
        Array<FileHandle> list = new Array<FileHandle>();
        if (this.mode == Mode.OPEN) {
            for (FileItem f : this.selectedItems) {
                list.add(f.file);
            }
            return list;
        }
        if (this.selectedItems.size > 0) {
            for (FileItem f : this.selectedItems) {
                list.add(f.file);
            }
            this.showOverwriteQuestion(list);
            return null;
        }
        String fileName = this.selectedFileTextField.getText();
        FileHandle file = this.currentDirectory.child(fileName);
        if (!FileUtils.isValidFileName(fileName)) {
            this.showDialog(this.getText(FileChooserText.POPUP_FILENAME_INVALID));
            return null;
        }
        if (file.exists()) {
            list.add(file);
            this.showOverwriteQuestion(list);
            return null;
        }
        list.add(file);
        return list;
    }

    private void showDialog(String text) {
        DialogUtils.showOKDialog(this.getStage(), this.getText(FileChooserText.POPUP_TITLE), text);
    }

    private void showOverwriteQuestion(final Array<FileHandle> filesList) {
        String text = filesList.size == 1 ? this.getText(FileChooserText.POPUP_FILE_EXIST_OVERWRITE) : this.getText(FileChooserText.POPUP_MULTIPLE_FILE_EXIST_OVERWRITE);
        DialogUtils.showOptionDialog(this.getStage(), this.getText(FileChooserText.POPUP_TITLE), text, DialogUtils.OptionDialogType.YES_NO, new OptionDialogAdapter(){

            @Override
            public void yes() {
                FileChooser.this.notifyListenerAndCloseDialog(filesList);
            }
        });
    }

    private void rebuildShortcutsList(boolean rebuildRootCache) {
        this.shortcutsTable.clear();
        String userHome = System.getProperty("user.home");
        String userName = System.getProperty("user.name");
        File desktop = this.fileSystemView.getHomeDirectory();
        this.shortcutsTable.add(new ShortcutItem(desktop, this.getText(FileChooserText.DESKTOP), this.style.iconFolder)).expand().fill().row();
        this.shortcutsTable.add(new ShortcutItem(new File(userHome), userName, this.style.iconFolder)).expand().fill().row();
        this.shortcutsTable.addSeparator();
        if (rebuildRootCache) {
            this.rebuildFileRootsCache();
        }
        for (ShortcutItem item : this.fileRootsCache) {
            this.shortcutsTable.add(item).expandX().fillX().row();
        }
        Array<FileHandle> favourites = this.favoritesIO.loadFavorites();
        if (favourites.size > 0) {
            this.shortcutsTable.addSeparator();
            for (FileHandle f : favourites) {
                this.shortcutsTable.add(new ShortcutItem(f.file(), f.name(), this.style.iconFolder)).expand().fill().row();
            }
        }
    }

    private void rebuildShortcutsList() {
        this.shortcutsListRebuildScheduled = false;
        this.rebuildShortcutsList(true);
    }

    private void rebuildFileRootsCache() {
        File[] roots;
        this.fileRootsCache.clear();
        for (File root : roots = File.listRoots()) {
            String displayName;
            if (!(this.mode == Mode.OPEN ? root.canRead() : root.canWrite())) continue;
            if (this.fileRootsSystemNameCache.containsKey(root)) {
                displayName = this.fileRootsSystemNameCache.get(root);
            } else {
                displayName = this.fileSystemView.getSystemDisplayName(root);
                this.fileRootsSystemNameCache.put(root, displayName);
            }
            ShortcutItem item = displayName != null && displayName.equals("/") ? new ShortcutItem(root, this.getText(FileChooserText.COMPUTER), this.style.iconDrive) : (displayName != null && !displayName.equals("") ? new ShortcutItem(root, displayName, this.style.iconDrive) : new ShortcutItem(root, root.toString(), this.style.iconDrive));
            this.fileRootsCache.add(item);
        }
    }

    private void rebuildFileList() {
        this.filesListRebuildScheduled = false;
        this.deselectAll();
        this.fileTable.clear();
        FileHandle[] files = this.currentDirectory.list(this.fileFilter);
        this.currentPath.setText(this.currentDirectory.path());
        if (files.length == 0) {
            return;
        }
        Array<FileHandle> fileList = FileUtils.sortFiles(files);
        for (FileHandle f : fileList) {
            if (f.file() != null && f.file().isHidden()) continue;
            this.fileTable.add(new FileItem(f, null)).expand().fill().row();
        }
        this.fileScrollPane.setScrollX(0.0f);
        this.fileScrollPane.setScrollY(0.0f);
    }

    public void refresh() {
        this.rebuildShortcutsList();
        this.rebuildFileList();
    }

    public void addFavorite(FileHandle favourite) {
        this.favorites.add(favourite);
        this.favoritesIO.saveFavorites(this.favorites);
        this.rebuildShortcutsList(false);
    }

    public boolean removeFavorite(FileHandle favorite) {
        boolean removed = this.favorites.removeValue(favorite, false);
        this.favoritesIO.saveFavorites(this.favorites);
        this.rebuildShortcutsList(false);
        return removed;
    }

    public void setVisble(boolean visible) {
        if (!this.isVisible() && visible) {
            this.deselectAll();
        }
        super.setVisible(visible);
    }

    private void deselectAll() {
        this.deselectAll(true);
    }

    private void deselectAll(boolean updateTextField) {
        for (FileItem item : this.selectedItems) {
            item.deselect(false);
        }
        this.selectedItems.clear();
        if (updateTextField) {
            this.setSelectedFileFieldText();
        }
    }

    private void selectAll() {
        Array<Cell> cells = this.fileTable.getCells();
        for (Cell c : cells) {
            FileItem item = (FileItem)c.getActor();
            item.select(false);
        }
        this.removeInvalidSelections();
        this.setSelectedFileFieldText();
    }

    private void setSelectedFileFieldText() {
        if (this.selectedItems.size == 0) {
            this.selectedFileTextField.setText("");
        } else if (this.selectedItems.size == 1) {
            this.selectedFileTextField.setText(this.selectedItems.get((int)0).file.name());
        } else {
            StringBuilder b = new StringBuilder();
            for (FileItem item : this.selectedItems) {
                b.append('\"');
                b.append(item.file.name());
                b.append("\" ");
            }
            this.selectedFileTextField.setText(b.toString());
        }
    }

    private void removeInvalidSelections() {
        if (this.selectionMode == SelectionMode.FILES) {
            for (FileItem item : this.selectedItems) {
                if (!item.file.isDirectory()) continue;
                item.deselect();
            }
        }
        if (this.selectionMode == SelectionMode.DIRECTORIES) {
            for (FileItem item : this.selectedItems) {
                if (item.file.isDirectory()) continue;
                item.deselect();
            }
        }
    }

    private void historyClear() {
        this.history.clear();
        this.historyForward.clear();
        this.forwardButton.setDisabled(true);
        this.backButton.setDisabled(true);
    }

    private void historyAdd() {
        this.history.add(this.currentDirectory);
        this.historyForward.clear();
        this.backButton.setDisabled(false);
        this.forwardButton.setDisabled(true);
    }

    private void historyBack() {
        FileHandle dir = this.history.pop();
        this.historyForward.add(this.currentDirectory);
        this.setDirectory(dir, HistoryPolicy.IGNORE);
        if (this.history.size == 0) {
            this.backButton.setDisabled(true);
        }
        this.forwardButton.setDisabled(false);
    }

    private void historyForward() {
        FileHandle dir = this.historyForward.pop();
        this.history.add(this.currentDirectory);
        this.setDirectory(dir, HistoryPolicy.IGNORE);
        if (this.historyForward.size == 0) {
            this.forwardButton.setDisabled(true);
        }
        this.backButton.setDisabled(false);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setDirectory(String directory) {
        this.setDirectory(Gdx.files.absolute(directory), HistoryPolicy.CLEAR);
    }

    public void setDirectory(File directory) {
        this.setDirectory(Gdx.files.absolute(directory.getAbsolutePath()), HistoryPolicy.CLEAR);
    }

    public void setDirectory(FileHandle directory) {
        this.setDirectory(directory, HistoryPolicy.CLEAR);
    }

    public void setDirectory(FileHandle directory, HistoryPolicy historyPolicy) {
        if (directory.equals(this.currentDirectory)) {
            return;
        }
        if (!directory.exists()) {
            throw new IllegalStateException("Provided directory does not exist!");
        }
        if (!directory.isDirectory()) {
            throw new IllegalStateException("Provided path is a file, not directory!");
        }
        if (historyPolicy == HistoryPolicy.ADD) {
            this.historyAdd();
        }
        this.currentDirectory = directory;
        this.rebuildFileList();
        if (historyPolicy == HistoryPolicy.CLEAR) {
            this.historyClear();
        }
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.rebuildFileList();
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        switch (selectionMode) {
            case FILES: {
                this.getTitleLabel().setText(this.getText(FileChooserText.TITLE_CHOOSE_FILES));
                break;
            }
            case DIRECTORIES: {
                this.getTitleLabel().setText(this.getText(FileChooserText.TITLE_CHOOSE_DIRECTORIES));
                break;
            }
            case FILES_AND_DIRECTORIES: {
                this.getTitleLabel().setText(this.getText(FileChooserText.TITLE_CHOOSE_FILES_AND_DIRECTORIES));
            }
        }
    }

    public boolean isMultiselectionEnabled() {
        return this.multiselectionEnabled;
    }

    public void setMultiselectionEnabled(boolean multiselectionEnabled) {
        this.multiselectionEnabled = multiselectionEnabled;
    }

    public void setListener(FileChooserListener listener) {
        this.listener = listener;
        this.validateSettings();
    }

    public int getMultiselectKey() {
        return this.multiselectKey;
    }

    public void setMultiselectKey(int multiselectKey) {
        this.multiselectKey = multiselectKey;
    }

    public int getGroupMultiselectKey() {
        return this.groupMultiselectKey;
    }

    public void setGroupMultiselectKey(int groupMultiselectKey) {
        this.groupMultiselectKey = groupMultiselectKey;
    }

    private void validateSettings() {
        if (this.listener == null) {
            this.listener = new FileChooserAdapter();
        }
    }

    public void setWatchingFilesEnabled(boolean watchingFilesEnabled) {
        if (this.getStage() != null) {
            throw new IllegalStateException("Pooling setting cannot be changed when file chooser is added to Stage!");
        }
        this.watchingFilesEnabled = watchingFilesEnabled;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.shortcutsListRebuildScheduled) {
            this.rebuildShortcutsList();
        }
        if (this.filesListRebuildScheduled) {
            this.rebuildFileList();
        }
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        this.deselectAll();
        if (this.watchingFilesEnabled) {
            if (stage != null) {
                this.startFileWatcher();
            } else {
                this.stopFileWatcher();
            }
        }
    }

    private void startFileWatcher() {
        if (this.fileWatcherThread != null) {
            throw new IllegalStateException("FileWatcheThread already running");
        }
        this.fileWatcherThread = new Thread(new Runnable(){
            File[] lastRoots;
            FileHandle lastCurrentDirectory;
            FileHandle[] lastCurrentFiles;

            @Override
            public void run() {
                this.lastRoots = File.listRoots();
                this.lastCurrentDirectory = FileChooser.this.currentDirectory;
                this.lastCurrentFiles = FileChooser.this.currentDirectory.list();
                while (FileChooser.this.fileWatcherThread != null) {
                    Object[] roots = File.listRoots();
                    if (roots.length != this.lastRoots.length || !Arrays.equals(this.lastRoots, roots)) {
                        FileChooser.this.shortcutsListRebuildScheduled = true;
                    }
                    this.lastRoots = roots;
                    if (this.lastCurrentDirectory.equals(FileChooser.this.currentDirectory)) {
                        Object[] currentFiles = FileChooser.this.currentDirectory.list();
                        if (this.lastCurrentFiles.length != currentFiles.length || !Arrays.equals(this.lastCurrentFiles, currentFiles)) {
                            FileChooser.this.filesListRebuildScheduled = true;
                        }
                        this.lastCurrentFiles = currentFiles;
                    } else {
                        this.lastCurrentFiles = FileChooser.this.currentDirectory.list();
                    }
                    this.lastCurrentDirectory = FileChooser.this.currentDirectory;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "FileWatcherThread");
        this.fileWatcherThread.setDaemon(true);
        this.fileWatcherThread.start();
    }

    private void stopFileWatcher() {
        if (this.fileWatcherThread == null) {
            throw new IllegalStateException("FileWatcherThread not running");
        }
        this.fileWatcherThread.interrupt();
        this.fileWatcherThread = null;
    }

    private class ShortcutItem
    extends Table {
        public File file;
        private VisLabel name;

        public ShortcutItem(File file, String customName, Drawable icon) {
            this.file = file;
            this.name = new VisLabel(customName);
            this.name.setEllipsis(true);
            this.add(new Image(icon)).padTop(3.0f);
            Cell<VisLabel> labelCell = this.add(this.name).expand().fill().padRight(6.0f);
            labelCell.width(new Value(){

                @Override
                public float get(Actor context) {
                    return FileChooser.this.shortcutsScrollPaneTable.getWidth() - (float)ShortcutItem.this.getUsedWidth() - 10.0f;
                }
            });
            this.addListener();
        }

        private int getUsedWidth() {
            Array<Cell> cells = this.getCells();
            int width = 0;
            for (Cell cell : cells) {
                if (cell.getActor() == this.name) continue;
                width = (int)((float)width + ((Actor)cell.getActor()).getWidth());
            }
            return width;
        }

        private void addListener() {
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == 1) {
                        FileChooser.this.fileMenu.buildForFavorite(FileChooser.this.favorites, ShortcutItem.this.file);
                        FileChooser.this.fileMenu.showMenu(ShortcutItem.this.getStage(), event.getStageX(), event.getStageY());
                    }
                }
            });
            this.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    FileChooser.this.deselectAll();
                    FileChooser.this.setSelectedFileFieldText();
                    ShortcutItem.this.select();
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (this.getTapCount() == 1) {
                        File file = ShortcutItem.this.file;
                        if (!file.exists()) {
                            FileChooser.this.showDialog(FileChooser.this.getText(FileChooserText.POPUP_DIRECTORY_DOES_NOT_EXIST));
                            return;
                        }
                        if (file.isDirectory()) {
                            FileChooser.this.setDirectory(Gdx.files.absolute(file.getAbsolutePath()), HistoryPolicy.ADD);
                            ShortcutItem.this.getStage().setScrollFocus(FileChooser.this.fileScrollPane);
                        }
                    }
                }
            });
        }

        private void select() {
            if (FileChooser.this.selectedShortcut != null) {
                FileChooser.this.selectedShortcut.deselect();
            }
            FileChooser.this.selectedShortcut = this;
            this.setBackground(((FileChooser)FileChooser.this).style.highlight);
        }

        private void deselect() {
            this.setBackground((Drawable)null);
        }
    }

    private class FileItem
    extends Table {
        public FileHandle file;
        private VisLabel name;
        private VisLabel size;

        public FileItem(final FileHandle file, Drawable icon) {
            this.file = file;
            this.setTouchable(Touchable.enabled);
            this.name = new VisLabel(file.name());
            this.name.setEllipsis(true);
            this.size = file.isDirectory() ? new VisLabel("") : new VisLabel(FileUtils.readableFileSize(file.length()));
            if (icon == null && file.isDirectory()) {
                icon = ((FileChooser)FileChooser.this).style.iconFolder;
            }
            if (icon != null) {
                this.add(new Image(icon)).padTop(3.0f);
            }
            Cell<VisLabel> labelCell = this.add(this.name).padLeft(icon == null ? 22.0f : 0.0f);
            labelCell.width(new Value(){

                @Override
                public float get(Actor context) {
                    int padding = file.isDirectory() ? 35 : 60;
                    return FileChooser.this.fileScrollPaneTable.getWidth() - (float)FileItem.this.getUsedWidth() - (float)padding;
                }
            });
            this.add(this.size).expandX().right().padRight(6.0f);
            this.addListener();
        }

        private int getUsedWidth() {
            Array<Cell> cells = this.getCells();
            int width = 0;
            for (Cell cell : cells) {
                if (cell.getActor() == this.name) continue;
                width = (int)((float)width + ((Actor)cell.getActor()).getWidth());
            }
            return width;
        }

        private void addListener() {
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == 1) {
                        FileChooser.this.fileMenu.build(FileChooser.this.favorites, FileItem.this.file);
                        FileChooser.this.fileMenu.showMenu(FileItem.this.getStage(), event.getStageX(), event.getStageY());
                    }
                }
            });
            this.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (FileChooser.this.selectedShortcut != null) {
                        FileChooser.this.selectedShortcut.deselect();
                    }
                    if (!FileChooser.this.multiselectionEnabled || !Gdx.input.isKeyPressed(FileChooser.this.multiselectKey) && !Gdx.input.isKeyPressed(FileChooser.this.groupMultiselectKey)) {
                        FileChooser.this.deselectAll();
                    }
                    boolean itemSelected = FileItem.this.select();
                    if (((FileChooser)FileChooser.this).selectedItems.size > 1 && FileChooser.this.multiselectionEnabled && Gdx.input.isKeyPressed(FileChooser.this.groupMultiselectKey)) {
                        this.selectGroup();
                    }
                    if (((FileChooser)FileChooser.this).selectedItems.size > 1) {
                        FileChooser.this.removeInvalidSelections();
                    }
                    FileChooser.this.setSelectedFileFieldText();
                    if (!itemSelected) {
                        return false;
                    }
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (this.getTapCount() == 2 && FileChooser.this.selectedItems.contains(FileItem.this, true)) {
                        FileHandle file = FileItem.this.file;
                        if (file.isDirectory()) {
                            FileChooser.this.setDirectory(file, HistoryPolicy.ADD);
                        } else {
                            FileChooser.this.selectionFinished();
                        }
                    }
                }

                private void selectGroup() {
                    int end;
                    int start;
                    int lastSelectionIndex;
                    Array<Cell> cells = FileChooser.this.fileTable.getCells();
                    int thisSelectionIndex = this.getItemId(cells, FileItem.this);
                    if (thisSelectionIndex > (lastSelectionIndex = this.getItemId(cells, (FileItem)FileChooser.this.selectedItems.get(((FileChooser)FileChooser.this).selectedItems.size - 2)))) {
                        start = lastSelectionIndex;
                        end = thisSelectionIndex;
                    } else {
                        start = thisSelectionIndex;
                        end = lastSelectionIndex;
                    }
                    for (int i = start; i < end; ++i) {
                        FileItem item = (FileItem)cells.get(i).getActor();
                        item.select(false);
                    }
                }

                private int getItemId(Array<Cell> cells, FileItem item) {
                    for (int i = 0; i < cells.size; ++i) {
                        if (cells.get(i).getActor() != item) continue;
                        return i;
                    }
                    throw new IllegalStateException("Item not found in cells");
                }
            });
        }

        private boolean select() {
            return this.select(true);
        }

        private boolean select(boolean deselectIfAlreadySelected) {
            if (deselectIfAlreadySelected && FileChooser.this.selectedItems.contains(this, true)) {
                this.deselect();
                return false;
            }
            this.setBackground(((FileChooser)FileChooser.this).style.highlight);
            if (!FileChooser.this.selectedItems.contains(this, true)) {
                FileChooser.this.selectedItems.add(this);
            }
            return true;
        }

        private void deselect() {
            this.deselect(true);
        }

        private void deselect(boolean removeFromList) {
            this.setBackground((Drawable)null);
            if (removeFromList) {
                FileChooser.this.selectedItems.removeValue(this, true);
            }
        }
    }

    private class DefaultFileFilter
    implements FileFilter {
        private DefaultFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isHidden()) {
                return false;
            }
            return !(FileChooser.this.mode == Mode.OPEN ? !f.canRead() : !f.canWrite());
        }
    }

    public static enum HistoryPolicy {
        ADD,
        CLEAR,
        IGNORE;

    }

    public static enum SelectionMode {
        FILES,
        DIRECTORIES,
        FILES_AND_DIRECTORIES;

    }

    public static enum Mode {
        OPEN,
        SAVE;

    }
}

