/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Pools;
import com.kotcrab.vis.ui.widget.VisImage;
import com.kotcrab.vis.ui.widget.color.ColorPickerStyle;

public class VerticalChannelBar
extends VisImage {
    private ColorPickerStyle style;
    private int maxValue;
    private float selectorY;
    private int value;

    public VerticalChannelBar(ColorPickerStyle style, Texture texture, int value, int maxValue, ChangeListener listener) {
        super(texture);
        this.style = style;
        this.maxValue = maxValue;
        this.setValue(value);
        this.addListener(listener);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                VerticalChannelBar.this.updateValueFromTouch(y);
                return true;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                VerticalChannelBar.this.updateValueFromTouch(y);
            }
        });
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.style.verticalSelector.draw(batch, this.getX(), this.getY() + this.getImageY() + this.selectorY - 2.5f, this.getImageWidth(), this.style.verticalSelector.getMinHeight());
    }

    public void setValue(int newValue) {
        this.value = newValue;
        if (this.value < 0) {
            this.value = 0;
        }
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
        this.selectorY = (float)this.value / (float)this.maxValue * 160.0f;
    }

    private void updateValueFromTouch(float y) {
        int newValue = (int)(y / 160.0f * (float)this.maxValue);
        this.setValue(newValue);
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    public int getValue() {
        return this.value;
    }
}

