/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Pools;
import com.kotcrab.vis.ui.widget.VisImage;
import com.kotcrab.vis.ui.widget.color.ColorPickerStyle;

public class Palette
extends VisImage {
    private ColorPickerStyle style;
    private int x;
    private int y;
    private int maxValue;
    private float selectorX;
    private float selectorY;

    public Palette(ColorPickerStyle style, Texture texture, int x, int y, int maxValue, ChangeListener listener) {
        super(texture);
        this.style = style;
        this.maxValue = maxValue;
        this.setValue(x, y);
        this.addListener(listener);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Palette.this.updateValueFromTouch(x, y);
                return true;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                Palette.this.updateValueFromTouch(x, y);
            }
        });
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.style.verticalSelector.draw(batch, this.getX(), this.getY() + this.selectorY - this.style.verticalSelector.getMinHeight() / 2.0f + 0.1f, this.getImageWidth(), this.style.verticalSelector.getMinHeight());
        this.style.horizontalSelector.draw(batch, this.getX() + this.selectorX - this.style.horizontalSelector.getMinWidth() / 2.0f + 0.1f, this.getY(), this.style.horizontalSelector.getMinWidth(), this.getImageHeight());
        this.style.cross.draw(batch, this.getX() + this.selectorX - this.style.cross.getMinWidth() / 2.0f + 0.1f, this.getY() + this.selectorY - this.style.cross.getMinHeight() / 2.0f + 0.1f, this.style.cross.getMinWidth(), this.style.cross.getMinHeight());
    }

    public void setValue(int v, int s) {
        this.x = v;
        this.y = s;
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.x > this.maxValue) {
            this.x = this.maxValue;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.y > this.maxValue) {
            this.y = this.maxValue;
        }
        this.selectorX = (float)this.x / (float)this.maxValue * 160.0f;
        this.selectorY = (float)this.y / (float)this.maxValue * 160.0f;
    }

    private void updateValueFromTouch(float touchX, float touchY) {
        int newX = (int)(touchX / 160.0f * (float)this.maxValue);
        int newY = (int)(touchY / 160.0f * (float)this.maxValue);
        this.setValue(newX, newY);
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    public int getS() {
        return this.x;
    }

    public int getV() {
        return this.y;
    }
}

