/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.I18NBundle;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.ColorUtils;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidableTextField;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.kotcrab.vis.ui.widget.color.AlphaImage;
import com.kotcrab.vis.ui.widget.color.ColorChannelWidget;
import com.kotcrab.vis.ui.widget.color.ColorPickerListener;
import com.kotcrab.vis.ui.widget.color.ColorPickerStyle;
import com.kotcrab.vis.ui.widget.color.ColorPickerText;
import com.kotcrab.vis.ui.widget.color.Palette;
import com.kotcrab.vis.ui.widget.color.VerticalChannelBar;

public class ColorPicker
extends VisWindow
implements Disposable {
    static final int FIELD_WIDTH = 50;
    static final int HEX_FIELD_WIDTH = 95;
    static final int PALETTE_SIZE = 160;
    static final int BAR_WIDTH = 130;
    static final int BAR_HEIGHT = 11;
    static final float VERTICAL_BAR_WIDTH = 15.0f;
    private ColorPickerStyle style;
    private I18NBundle bundle;
    private ColorPickerListener listener;
    private Color oldColor;
    private Color color;
    private Color tmpColor;
    private Pixmap barPixmap;
    private Texture barTexture;
    private VerticalChannelBar verticalBar;
    private Texture paletteTexture;
    private Pixmap palettePixmap;
    private Palette palette;
    private ColorChannelWidget hBar;
    private ColorChannelWidget sBar;
    private ColorChannelWidget vBar;
    private ColorChannelWidget rBar;
    private ColorChannelWidget gBar;
    private ColorChannelWidget bBar;
    private ColorChannelWidget aBar;
    private VisValidableTextField hexField;
    private VisTextButton restoreButton;
    private VisTextButton cancelButton;
    private VisTextButton okButton;
    private Image currentColor;
    private Image newColor;

    public ColorPicker() {
        this((String)null);
    }

    public ColorPicker(String title) {
        this("default", title, null);
    }

    public ColorPicker(String title, ColorPickerListener listener) {
        this("default", title, listener);
    }

    public ColorPicker(ColorPickerListener listener) {
        this("default", null, listener);
    }

    public ColorPicker(String styleName, String title, ColorPickerListener listener) {
        super(title != null ? title : "");
        this.listener = listener;
        this.style = VisUI.getSkin().get(styleName, ColorPickerStyle.class);
        this.bundle = VisUI.getColorPickerBundle();
        if (title == null) {
            this.getTitleLabel().setText(this.getText(ColorPickerText.TITLE));
        }
        this.setModal(true);
        this.setMovable(true);
        this.addCloseButton();
        this.closeOnEscape();
        this.oldColor = new Color(Color.BLACK);
        this.color = new Color(Color.BLACK);
        this.tmpColor = new Color(Color.BLACK);
        this.createColorWidgets();
        this.createUI();
        this.createListeners();
        this.updatePixmaps();
        this.pack();
        this.centerWindow();
    }

    private void createUI() {
        VisTable rightTable = new VisTable(true);
        rightTable.add(this.hBar).row();
        rightTable.add(this.sBar).row();
        rightTable.add(this.vBar).row();
        rightTable.add();
        rightTable.row();
        rightTable.add(this.rBar).row();
        rightTable.add(this.gBar).row();
        rightTable.add(this.bBar).row();
        rightTable.add();
        rightTable.row();
        rightTable.add(this.aBar).row();
        VisTable leftTable = new VisTable(true);
        leftTable.add(this.palette).size(160.0f);
        leftTable.row();
        leftTable.add(this.createColorsPreviewTable()).expandX().fillX();
        leftTable.row();
        leftTable.add(this.createHexTable()).expandX().left();
        this.add(leftTable).top().padRight(5.0f);
        this.add(this.verticalBar).size(15.0f, 160.0f).top();
        this.add(rightTable).expand().left().top().pad(4.0f);
        this.row();
        this.add(this.createButtons()).pad(3.0f).right().expandX().colspan(3);
    }

    private VisTable createColorsPreviewTable() {
        VisTable table = new VisTable(false);
        table.add(new VisLabel(this.getText(ColorPickerText.OLD))).spaceRight(3.0f);
        this.currentColor = new AlphaImage(this.style);
        table.add(this.currentColor).height(25.0f).expandX().fillX();
        table.row();
        table.add(new VisLabel(this.getText(ColorPickerText.NEW))).spaceRight(3.0f);
        this.newColor = new AlphaImage(this.style, true);
        table.add(this.newColor).height(25.0f).expandX().fillX();
        this.currentColor.setColor(this.color);
        this.newColor.setColor(this.color);
        return table;
    }

    private VisTable createHexTable() {
        VisTable table = new VisTable(true);
        table.add(new VisLabel(this.getText(ColorPickerText.HEX)));
        this.hexField = new VisValidableTextField("00000000");
        table.add(this.hexField).width(95.0f);
        table.row();
        this.hexField.setMaxLength(8);
        this.hexField.setProgrammaticChangeEvents(false);
        this.hexField.setTextFieldFilter(new VisTextField.TextFieldFilter(){

            @Override
            public boolean acceptChar(VisTextField textField, char c) {
                return Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
            }
        });
        this.hexField.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ColorPicker.this.hexField.getText().length() == 8) {
                    ColorPicker.this.setColor(Color.valueOf(ColorPicker.this.hexField.getText()));
                }
            }
        });
        return table;
    }

    private VisTable createButtons() {
        VisTable table = new VisTable(true);
        table.defaults().right();
        this.restoreButton = new VisTextButton(this.getText(ColorPickerText.RESTORE));
        table.add(this.restoreButton);
        this.okButton = new VisTextButton(this.getText(ColorPickerText.OK));
        table.add(this.okButton);
        this.cancelButton = new VisTextButton(this.getText(ColorPickerText.CANCEL));
        table.add(this.cancelButton);
        return table;
    }

    private void createColorWidgets() {
        this.palettePixmap = new Pixmap(100, 100, Pixmap.Format.RGB888);
        this.paletteTexture = new Texture(this.palettePixmap);
        this.barPixmap = new Pixmap(1, 360, Pixmap.Format.RGB888);
        for (int h = 0; h < 360; ++h) {
            ColorUtils.HSVtoRGB((float)(360 - h), 100.0f, 100.0f, this.tmpColor);
            this.barPixmap.drawPixel(0, h, Color.rgba8888(this.tmpColor));
        }
        this.barTexture = new Texture(this.barPixmap);
        this.palette = new Palette(this.style, this.paletteTexture, 0, 0, 100, new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorPicker.this.sBar.setValue(ColorPicker.this.palette.getV());
                ColorPicker.this.vBar.setValue(ColorPicker.this.palette.getS());
                ColorPicker.this.updateHSVValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }
        });
        this.verticalBar = new VerticalChannelBar(this.style, this.barTexture, 0, 360, new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorPicker.this.hBar.setValue(ColorPicker.this.verticalBar.getValue());
                ColorPicker.this.updateHSVValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }
        });
        this.hBar = new ColorChannelWidget(this.style, "H", 360, new ColorChannelWidget.ColorChannelWidgetListener(){

            @Override
            public void updateFields() {
                ColorPicker.this.verticalBar.setValue(ColorPicker.this.hBar.getValue());
                ColorPicker.this.updateHSVValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }

            @Override
            public void draw(Pixmap pixmap) {
                for (int h = 0; h < 360; ++h) {
                    ColorUtils.HSVtoRGB((float)h, (float)ColorPicker.this.sBar.getValue(), (float)ColorPicker.this.vBar.getValue(), ColorPicker.this.tmpColor);
                    pixmap.drawPixel(h, 0, Color.rgba8888(ColorPicker.this.tmpColor));
                }
            }
        });
        this.sBar = new ColorChannelWidget(this.style, "S", 100, new ColorChannelWidget.ColorChannelWidgetListener(){

            @Override
            public void updateFields() {
                ColorPicker.this.palette.setValue(ColorPicker.this.vBar.getValue(), ColorPicker.this.sBar.getValue());
                ColorPicker.this.updateHSVValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }

            @Override
            public void draw(Pixmap pixmap) {
                for (int s = 0; s < 100; ++s) {
                    ColorUtils.HSVtoRGB((float)ColorPicker.this.hBar.getValue(), (float)s, (float)ColorPicker.this.vBar.getValue(), ColorPicker.this.tmpColor);
                    pixmap.drawPixel(s, 0, Color.rgba8888(ColorPicker.this.tmpColor));
                }
            }
        });
        this.vBar = new ColorChannelWidget(this.style, "V", 100, new ColorChannelWidget.ColorChannelWidgetListener(){

            @Override
            public void updateFields() {
                ColorPicker.this.palette.setValue(ColorPicker.this.vBar.getValue(), ColorPicker.this.sBar.getValue());
                ColorPicker.this.updateHSVValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }

            @Override
            public void draw(Pixmap pixmap) {
                for (int v = 0; v < 100; ++v) {
                    ColorUtils.HSVtoRGB((float)ColorPicker.this.hBar.getValue(), (float)ColorPicker.this.sBar.getValue(), (float)v, ColorPicker.this.tmpColor);
                    pixmap.drawPixel(v, 0, Color.rgba8888(ColorPicker.this.tmpColor));
                }
            }
        });
        this.rBar = new ColorChannelWidget(this.style, "R", 255, new ColorChannelWidget.ColorChannelWidgetListener(){

            @Override
            public void updateFields() {
                ColorPicker.this.updateRGBValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }

            @Override
            public void draw(Pixmap pixmap) {
                for (int r = 0; r < 255; ++r) {
                    ColorPicker.this.tmpColor.set((float)r / 255.0f, ((ColorPicker)ColorPicker.this).color.g, ((ColorPicker)ColorPicker.this).color.b, 1.0f);
                    pixmap.drawPixel(r, 0, Color.rgba8888(ColorPicker.this.tmpColor));
                }
            }
        });
        this.gBar = new ColorChannelWidget(this.style, "G", 255, new ColorChannelWidget.ColorChannelWidgetListener(){

            @Override
            public void updateFields() {
                ColorPicker.this.updateRGBValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }

            @Override
            public void draw(Pixmap pixmap) {
                for (int g = 0; g < 255; ++g) {
                    ColorPicker.this.tmpColor.set(((ColorPicker)ColorPicker.this).color.r, (float)g / 255.0f, ((ColorPicker)ColorPicker.this).color.b, 1.0f);
                    pixmap.drawPixel(g, 0, Color.rgba8888(ColorPicker.this.tmpColor));
                }
            }
        });
        this.bBar = new ColorChannelWidget(this.style, "B", 255, new ColorChannelWidget.ColorChannelWidgetListener(){

            @Override
            public void updateFields() {
                ColorPicker.this.updateRGBValuesFromFields();
                ColorPicker.this.updatePixmaps();
            }

            @Override
            public void draw(Pixmap pixmap) {
                for (int b = 0; b < 255; ++b) {
                    ColorPicker.this.tmpColor.set(((ColorPicker)ColorPicker.this).color.r, ((ColorPicker)ColorPicker.this).color.g, (float)b / 255.0f, 1.0f);
                    pixmap.drawPixel(b, 0, Color.rgba8888(ColorPicker.this.tmpColor));
                }
            }
        });
        this.aBar = new ColorChannelWidget(this.style, "A", 255, true, new ColorChannelWidget.ColorChannelWidgetListener(){

            @Override
            public void updateFields() {
                if (ColorPicker.this.aBar.isInputValid()) {
                    ((ColorPicker)ColorPicker.this).color.a = (float)ColorPicker.this.aBar.getValue() / 255.0f;
                }
                ColorPicker.this.updatePixmaps();
            }

            @Override
            public void draw(Pixmap pixmap) {
                pixmap.fill();
                for (int i = 0; i < 255; ++i) {
                    ColorPicker.this.tmpColor.set(((ColorPicker)ColorPicker.this).color.r, ((ColorPicker)ColorPicker.this).color.g, ((ColorPicker)ColorPicker.this).color.b, (float)i / 255.0f);
                    pixmap.drawPixel(i, 0, Color.rgba8888(ColorPicker.this.tmpColor));
                }
            }
        });
    }

    private void createListeners() {
        this.restoreButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorPicker.this.setColor(ColorPicker.this.oldColor);
            }
        });
        this.okButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ColorPicker.this.listener != null) {
                    ColorPicker.this.listener.finished(new Color(ColorPicker.this.color));
                }
                ColorPicker.this.setColor(ColorPicker.this.color);
                ColorPicker.this.fadeOut();
            }
        });
        this.cancelButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorPicker.this.setColor(ColorPicker.this.oldColor);
                ColorPicker.this.close();
            }
        });
    }

    @Override
    protected void close() {
        if (this.listener != null) {
            this.listener.canceled();
        }
        super.close();
    }

    public ColorPickerListener getListener() {
        return this.listener;
    }

    public void setListener(ColorPickerListener listener) {
        this.listener = listener;
    }

    private void updatePixmaps() {
        for (int v = 0; v <= 100; ++v) {
            for (int s = 0; s <= 100; ++s) {
                ColorUtils.HSVtoRGB((float)this.hBar.getValue(), (float)s, (float)v, this.tmpColor);
                this.palettePixmap.drawPixel(v, 100 - s, Color.rgba8888(this.tmpColor));
            }
        }
        this.paletteTexture.draw(this.palettePixmap, 0, 0);
        this.newColor.setColor(this.color);
        this.hBar.redraw();
        this.sBar.redraw();
        this.vBar.redraw();
        this.rBar.redraw();
        this.gBar.redraw();
        this.bBar.redraw();
        this.aBar.redraw();
        this.hexField.setText(this.color.toString().toUpperCase());
        this.hexField.setCursorPosition(this.hexField.getMaxLength());
    }

    @Override
    public void setColor(Color c) {
        this.currentColor.setColor(new Color(c));
        this.oldColor = new Color(c);
        this.color = new Color(c);
        this.updateFieldsFromColor();
        this.updatePixmaps();
    }

    private String getText(ColorPickerText text) {
        return this.bundle.get(text.getName());
    }

    @Override
    public void dispose() {
        this.paletteTexture.dispose();
        this.barTexture.dispose();
        this.palettePixmap.dispose();
        this.barPixmap.dispose();
        this.hBar.dispose();
        this.sBar.dispose();
        this.vBar.dispose();
        this.rBar.dispose();
        this.gBar.dispose();
        this.bBar.dispose();
        this.aBar.dispose();
    }

    private void updateFieldsFromColor() {
        int[] hsv = ColorUtils.RGBtoHSV(this.color);
        int ch = hsv[0];
        int cs = hsv[1];
        int cv = hsv[2];
        int cr = MathUtils.round(this.color.r * 255.0f);
        int cg = MathUtils.round(this.color.g * 255.0f);
        int cb = MathUtils.round(this.color.b * 255.0f);
        int ca = MathUtils.round(this.color.a * 255.0f);
        this.hBar.setValue(ch);
        this.sBar.setValue(cs);
        this.vBar.setValue(cv);
        this.rBar.setValue(cr);
        this.gBar.setValue(cg);
        this.bBar.setValue(cb);
        this.aBar.setValue(ca);
        this.verticalBar.setValue(this.hBar.getValue());
        this.palette.setValue(this.vBar.getValue(), this.sBar.getValue());
    }

    private void updateHSVValuesFromFields() {
        int[] hsv = ColorUtils.RGBtoHSV(this.color);
        int h = hsv[0];
        int s = hsv[1];
        int v = hsv[2];
        if (this.hBar.isInputValid()) {
            h = this.hBar.getValue();
        }
        if (this.sBar.isInputValid()) {
            s = this.sBar.getValue();
        }
        if (this.vBar.isInputValid()) {
            v = this.vBar.getValue();
        }
        this.color = ColorUtils.HSVtoRGB((float)h, (float)s, (float)v, this.color.a);
        int cr = MathUtils.round(this.color.r * 255.0f);
        int cg = MathUtils.round(this.color.g * 255.0f);
        int cb = MathUtils.round(this.color.b * 255.0f);
        this.rBar.setValue(cr);
        this.gBar.setValue(cg);
        this.bBar.setValue(cb);
    }

    private void updateRGBValuesFromFields() {
        int r = MathUtils.round(this.color.r * 255.0f);
        int g = MathUtils.round(this.color.g * 255.0f);
        int b = MathUtils.round(this.color.b * 255.0f);
        if (this.rBar.isInputValid()) {
            r = this.rBar.getValue();
        }
        if (this.gBar.isInputValid()) {
            g = this.gBar.getValue();
        }
        if (this.bBar.isInputValid()) {
            b = this.bBar.getValue();
        }
        this.color.set((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, this.color.a);
        int[] hsv = ColorUtils.RGBtoHSV(this.color);
        int ch = hsv[0];
        int cs = hsv[1];
        int cv = hsv[2];
        this.hBar.setValue(ch);
        this.sBar.setValue(cs);
        this.vBar.setValue(cv);
        this.verticalBar.setValue(this.hBar.getValue());
        this.palette.setValue(this.vBar.getValue(), this.sBar.getValue());
    }
}

