/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Disposable;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.color.AlphaChannelBar;
import com.kotcrab.vis.ui.widget.color.ChannelBar;
import com.kotcrab.vis.ui.widget.color.ColorInputField;
import com.kotcrab.vis.ui.widget.color.ColorPickerStyle;

public class ColorChannelWidget
extends VisTable
implements Disposable {
    private ColorPickerStyle style;
    private int value;
    private int maxValue;
    private ColorChannelWidgetListener drawer;
    private boolean useAlpha;
    private ColorInputField inputField;
    private Texture texture;
    private Pixmap pixmap;
    private ChannelBar bar;
    private ChangeListener barListener;

    public ColorChannelWidget(ColorPickerStyle style, String label, int maxValue, ColorChannelWidgetListener drawer) {
        this(style, label, maxValue, false, drawer);
    }

    public ColorChannelWidget(ColorPickerStyle style, String label, int maxValue, boolean useAlpha, final ColorChannelWidgetListener drawer) {
        super(true);
        this.style = style;
        this.value = 0;
        this.maxValue = maxValue;
        this.drawer = drawer;
        this.useAlpha = useAlpha;
        this.barListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorChannelWidget.this.value = ColorChannelWidget.this.bar.getValue();
                drawer.updateFields();
                ColorChannelWidget.this.inputField.setValue(ColorChannelWidget.this.value);
            }
        };
        this.pixmap = useAlpha ? new Pixmap(maxValue, 1, Pixmap.Format.RGBA8888) : new Pixmap(maxValue, 1, Pixmap.Format.RGB888);
        this.texture = new Texture(this.pixmap);
        this.add(new VisLabel(label)).width(10.0f).center();
        this.inputField = new ColorInputField(maxValue, new ColorInputField.ColorInputFieldListener(){

            @Override
            public void changed(int newValue) {
                ColorChannelWidget.this.value = newValue;
                drawer.updateFields();
                ColorChannelWidget.this.bar.setValue(newValue);
            }
        });
        this.add(this.inputField).width(50.0f);
        this.bar = this.createBarImage();
        this.add(this.bar).size(130.0f, 11.0f);
        this.inputField.setValue(0);
    }

    @Override
    public void dispose() {
        this.pixmap.dispose();
        this.texture.dispose();
    }

    public void redraw() {
        this.drawer.draw(this.pixmap);
        this.texture.draw(this.pixmap, 0, 0);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.inputField.setValue(value);
        this.bar.setValue(value);
    }

    private ChannelBar createBarImage() {
        if (this.useAlpha) {
            return new AlphaChannelBar(this.style, this.texture, this.value, this.maxValue, this.barListener);
        }
        return new ChannelBar(this.style, this.texture, this.value, this.maxValue, this.barListener);
    }

    public boolean isInputValid() {
        return this.inputField.isInputValid();
    }

    static interface ColorChannelWidgetListener {
        public void updateFields();

        public void draw(Pixmap var1);
    }
}

