/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Pools;
import com.kotcrab.vis.ui.widget.VisImage;
import com.kotcrab.vis.ui.widget.color.ColorPickerStyle;

public class ChannelBar
extends VisImage {
    protected ColorPickerStyle style;
    private int maxValue;
    private int value;
    private float selectorX;

    public ChannelBar(ColorPickerStyle style, Texture texture, int value, int maxValue, ChangeListener listener) {
        super(texture);
        this.style = style;
        this.maxValue = maxValue;
        this.setValue(value);
        this.addListener(listener);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                ChannelBar.this.updateValueFromTouch(x);
                return true;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                ChannelBar.this.updateValueFromTouch(x);
            }
        });
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.style.barSelector.draw(batch, this.getX() + this.selectorX - this.style.barSelector.getMinWidth() / 2.0f, this.getY() - 2.0f, this.style.barSelector.getMinWidth(), this.style.barSelector.getMinHeight());
    }

    public void setValue(int newValue) {
        this.value = newValue;
        if (this.value < 0) {
            this.value = 0;
        }
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
        this.selectorX = (float)this.value / (float)this.maxValue * 130.0f;
    }

    public int getValue() {
        return this.value;
    }

    private void updateValueFromTouch(float x) {
        int newValue = (int)(x / 130.0f * (float)this.maxValue);
        this.setValue(newValue);
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }
}

