/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.InputValidator;
import com.kotcrab.vis.ui.widget.VisTextField;

public class VisValidableTextField
extends VisTextField {
    private Array<InputValidator> validators = new Array();
    private boolean validationEnabled = true;
    private boolean programmaticChangeEvents = true;
    private LastValidFocusListener restoreFocusListener;
    private boolean restoreLastValid = false;
    private String lastValid;
    private boolean changeListenerAdded;

    public VisValidableTextField() {
        this.init();
    }

    public VisValidableTextField(String text) {
        super(text);
        this.init();
    }

    public VisValidableTextField(InputValidator validator) {
        this.addValidator(validator);
        this.init();
    }

    public VisValidableTextField(InputValidator ... validators) {
        for (InputValidator validator : validators) {
            this.addValidator(validator);
        }
        this.init();
    }

    public VisValidableTextField(boolean restoreLastValid, InputValidator validator) {
        this.addValidator(validator);
        this.init();
        this.setRestoreLastValid(restoreLastValid);
    }

    public VisValidableTextField(boolean restoreLastValid, InputValidator ... validators) {
        for (InputValidator validator : validators) {
            this.addValidator(validator);
        }
        this.init();
        this.setRestoreLastValid(restoreLastValid);
    }

    private void init() {
        this.addListener(new InputListener(){

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                VisValidableTextField.this.validateInput();
                if (VisValidableTextField.this.changeListenerAdded) {
                    VisValidableTextField.this.fire(new ChangeListener.ChangeEvent());
                }
                return false;
            }
        });
    }

    @Override
    public void setText(String str) {
        super.setText(str);
        this.validateInput();
        if (this.programmaticChangeEvents) {
            this.fire(new ChangeListener.ChangeEvent());
        }
    }

    public void validateInput() {
        if (this.validationEnabled) {
            for (InputValidator validator : this.validators) {
                if (validator.validateInput(this.getText())) continue;
                this.setInputValid(false);
                return;
            }
        }
        this.setInputValid(true);
    }

    @Override
    public boolean addListener(EventListener listener) {
        if (listener instanceof ChangeListener) {
            this.changeListenerAdded = true;
        }
        return super.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener listener) {
        boolean result = super.removeListener(listener);
        for (EventListener fieldListener : this.getListeners()) {
            if (!(fieldListener instanceof ChangeListener)) continue;
            return result;
        }
        this.changeListenerAdded = false;
        return result;
    }

    public void addValidator(InputValidator validator) {
        this.validators.add(validator);
        this.validateInput();
    }

    public Array<InputValidator> getValidators() {
        return this.validators;
    }

    public InputValidator getValidator() {
        return this.validators.size == 0 ? null : this.validators.get(0);
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        this.validateInput();
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public boolean isRestoreLastValid() {
        return this.restoreLastValid;
    }

    public void setRestoreLastValid(boolean restoreLastValid) {
        if (this.hasSelection) {
            throw new IllegalStateException("Last valid text restore can't be changed while filed has selection");
        }
        this.restoreLastValid = restoreLastValid;
        if (restoreLastValid) {
            if (this.restoreFocusListener == null) {
                this.restoreFocusListener = new LastValidFocusListener();
            }
            this.addListener(this.restoreFocusListener);
        } else {
            this.removeListener(this.restoreFocusListener);
        }
    }

    private class LastValidFocusListener
    extends FocusListener {
        private LastValidFocusListener() {
        }

        @Override
        public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
            if (focused && VisValidableTextField.this.restoreLastValid) {
                VisValidableTextField.this.lastValid = VisValidableTextField.this.getText();
            }
            if (!focused && !VisValidableTextField.this.isInputValid() && VisValidableTextField.this.restoreLastValid) {
                VisValidableTextField.super.setText(VisValidableTextField.this.lastValid);
                VisValidableTextField.this.setInputValid(true);
            }
        }
    }
}

