/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.VisUI;

public class VisSplitPane
extends WidgetGroup {
    VisSplitPaneStyle style;
    private Actor firstWidget;
    private Actor secondWidget;
    boolean vertical;
    float splitAmount = 0.5f;
    float minAmount;
    float maxAmount = 1.0f;
    private Rectangle firstWidgetBounds = new Rectangle();
    private Rectangle secondWidgetBounds = new Rectangle();
    Rectangle handleBounds = new Rectangle();
    private Rectangle firstScissors = new Rectangle();
    private Rectangle secondScissors = new Rectangle();
    Vector2 lastPoint = new Vector2();
    Vector2 handlePosition = new Vector2();
    private boolean mouseOnHandle;

    public VisSplitPane(Actor firstWidget, Actor secondWidget, boolean vertical) {
        this(firstWidget, secondWidget, vertical, "default-" + (vertical ? "vertical" : "horizontal"));
    }

    public VisSplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, String styleName) {
        this(firstWidget, secondWidget, vertical, VisUI.getSkin().get(styleName, VisSplitPaneStyle.class));
    }

    public VisSplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, VisSplitPaneStyle style) {
        this.firstWidget = firstWidget;
        this.secondWidget = secondWidget;
        this.vertical = vertical;
        this.setStyle(style);
        this.setFirstWidget(firstWidget);
        this.setSecondWidget(secondWidget);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.initialize();
    }

    private void initialize() {
        this.addListener(new InputListener(){
            int draggingPointer = -1;

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (this.draggingPointer != -1) {
                    return false;
                }
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (VisSplitPane.this.handleBounds.contains(x, y)) {
                    FocusManager.getFocus();
                    this.draggingPointer = pointer;
                    VisSplitPane.this.lastPoint.set(x, y);
                    VisSplitPane.this.handlePosition.set(VisSplitPane.this.handleBounds.x, VisSplitPane.this.handleBounds.y);
                    return true;
                }
                return false;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == this.draggingPointer) {
                    this.draggingPointer = -1;
                }
            }

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                VisSplitPane.this.mouseOnHandle = VisSplitPane.this.handleBounds.contains(x, y);
                return false;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (pointer != this.draggingPointer) {
                    return;
                }
                Drawable handle = VisSplitPane.this.style.handle;
                if (!VisSplitPane.this.vertical) {
                    float dragX;
                    float delta = x - VisSplitPane.this.lastPoint.x;
                    float availWidth = VisSplitPane.this.getWidth() - handle.getMinWidth();
                    VisSplitPane.this.handlePosition.x = dragX = VisSplitPane.this.handlePosition.x + delta;
                    dragX = Math.max(0.0f, dragX);
                    dragX = Math.min(availWidth, dragX);
                    VisSplitPane.this.splitAmount = dragX / availWidth;
                    if (VisSplitPane.this.splitAmount < VisSplitPane.this.minAmount) {
                        VisSplitPane.this.splitAmount = VisSplitPane.this.minAmount;
                    }
                    if (VisSplitPane.this.splitAmount > VisSplitPane.this.maxAmount) {
                        VisSplitPane.this.splitAmount = VisSplitPane.this.maxAmount;
                    }
                    VisSplitPane.this.lastPoint.set(x, y);
                } else {
                    float dragY;
                    float delta = y - VisSplitPane.this.lastPoint.y;
                    float availHeight = VisSplitPane.this.getHeight() - handle.getMinHeight();
                    VisSplitPane.this.handlePosition.y = dragY = VisSplitPane.this.handlePosition.y + delta;
                    dragY = Math.max(0.0f, dragY);
                    dragY = Math.min(availHeight, dragY);
                    VisSplitPane.this.splitAmount = 1.0f - dragY / availHeight;
                    if (VisSplitPane.this.splitAmount < VisSplitPane.this.minAmount) {
                        VisSplitPane.this.splitAmount = VisSplitPane.this.minAmount;
                    }
                    if (VisSplitPane.this.splitAmount > VisSplitPane.this.maxAmount) {
                        VisSplitPane.this.splitAmount = VisSplitPane.this.maxAmount;
                    }
                    VisSplitPane.this.lastPoint.set(x, y);
                }
                VisSplitPane.this.invalidate();
            }
        });
    }

    public VisSplitPaneStyle getStyle() {
        return this.style;
    }

    public void setStyle(VisSplitPaneStyle style) {
        this.style = style;
        this.invalidateHierarchy();
    }

    @Override
    public void layout() {
        Actor secondWidget;
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        Actor firstWidget = this.firstWidget;
        if (firstWidget != null) {
            Rectangle firstWidgetBounds = this.firstWidgetBounds;
            firstWidget.setBounds(firstWidgetBounds.x, firstWidgetBounds.y, firstWidgetBounds.width, firstWidgetBounds.height);
            if (firstWidget instanceof Layout) {
                ((Layout)((Object)firstWidget)).validate();
            }
        }
        if ((secondWidget = this.secondWidget) != null) {
            Rectangle secondWidgetBounds = this.secondWidgetBounds;
            secondWidget.setBounds(secondWidgetBounds.x, secondWidgetBounds.y, secondWidgetBounds.width, secondWidgetBounds.height);
            if (secondWidget instanceof Layout) {
                ((Layout)((Object)secondWidget)).validate();
            }
        }
    }

    @Override
    public float getPrefWidth() {
        float width = 0.0f;
        if (this.firstWidget != null) {
            float f = width = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefWidth() : this.firstWidget.getWidth();
        }
        if (this.secondWidget != null) {
            width += this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefWidth() : this.secondWidget.getWidth();
        }
        if (!this.vertical) {
            width += this.style.handle.getMinWidth();
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        float height = 0.0f;
        if (this.firstWidget != null) {
            float f = height = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefHeight() : this.firstWidget.getHeight();
        }
        if (this.secondWidget != null) {
            height += this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefHeight() : this.secondWidget.getHeight();
        }
        if (this.vertical) {
            height += this.style.handle.getMinHeight();
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    private void calculateHorizBoundsAndPositions() {
        Drawable handle = this.style.handle;
        float height = this.getHeight();
        float availWidth = this.getWidth() - handle.getMinWidth();
        float leftAreaWidth = (int)(availWidth * this.splitAmount);
        float rightAreaWidth = availWidth - leftAreaWidth;
        float handleWidth = handle.getMinWidth();
        this.firstWidgetBounds.set(0.0f, 0.0f, leftAreaWidth, height);
        this.secondWidgetBounds.set(leftAreaWidth + handleWidth, 0.0f, rightAreaWidth, height);
        this.handleBounds.set(leftAreaWidth, 0.0f, handleWidth, height);
    }

    private void calculateVertBoundsAndPositions() {
        Drawable handle = this.style.handle;
        float width = this.getWidth();
        float height = this.getHeight();
        float availHeight = height - handle.getMinHeight();
        float topAreaHeight = (int)(availHeight * this.splitAmount);
        float bottomAreaHeight = availHeight - topAreaHeight;
        float handleHeight = handle.getMinHeight();
        this.firstWidgetBounds.set(0.0f, height - topAreaHeight, width, topAreaHeight);
        this.secondWidgetBounds.set(0.0f, 0.0f, width, bottomAreaHeight);
        this.handleBounds.set(0.0f, bottomAreaHeight, width, handleHeight);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        Color color = this.getColor();
        this.applyTransform(batch, this.computeTransform());
        if (this.firstWidget != null) {
            this.getStage().calculateScissors(this.firstWidgetBounds, this.firstScissors);
            if (ScissorStack.pushScissors(this.firstScissors)) {
                if (this.firstWidget.isVisible()) {
                    this.firstWidget.draw(batch, parentAlpha * color.a);
                }
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        if (this.secondWidget != null) {
            this.getStage().calculateScissors(this.secondWidgetBounds, this.secondScissors);
            if (ScissorStack.pushScissors(this.secondScissors)) {
                if (this.secondWidget.isVisible()) {
                    this.secondWidget.draw(batch, parentAlpha * color.a);
                }
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        Drawable handle = this.style.handle;
        if (this.mouseOnHandle && this.style.handleOver != null) {
            handle = this.style.handleOver;
        }
        batch.setColor(color.r, color.g, color.b, parentAlpha * color.a);
        handle.draw(batch, this.handleBounds.x, this.handleBounds.y, this.handleBounds.width, this.handleBounds.height);
        this.resetTransform(batch);
    }

    public void setSplitAmount(float split) {
        this.splitAmount = Math.max(Math.min(this.maxAmount, split), this.minAmount);
        this.invalidate();
    }

    public float getSplit() {
        return this.splitAmount;
    }

    public void setMinSplitAmount(float minAmount) {
        if (minAmount < 0.0f) {
            throw new GdxRuntimeException("minAmount has to be >= 0");
        }
        if (minAmount >= this.maxAmount) {
            throw new GdxRuntimeException("minAmount has to be < maxAmount");
        }
        this.minAmount = minAmount;
    }

    public void setMaxSplitAmount(float maxAmount) {
        if (maxAmount > 1.0f) {
            throw new GdxRuntimeException("maxAmount has to be >= 0");
        }
        if (maxAmount <= this.minAmount) {
            throw new GdxRuntimeException("maxAmount has to be > minAmount");
        }
        this.maxAmount = maxAmount;
    }

    public void setWidgets(Actor firstWidget, Actor secondWidget) {
        this.setFirstWidget(firstWidget);
        this.setSecondWidget(secondWidget);
    }

    public void setFirstWidget(Actor widget) {
        if (this.firstWidget != null) {
            super.removeActor(this.firstWidget);
        }
        this.firstWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    public void setSecondWidget(Actor widget) {
        if (this.secondWidget != null) {
            super.removeActor(this.secondWidget);
        }
        this.secondWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget(null).");
    }

    public static class VisSplitPaneStyle
    extends SplitPane.SplitPaneStyle {
        public Drawable handleOver;
    }
}

