/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisProgressBar;

public class VisSlider
extends VisProgressBar {
    int draggingPointer = -1;
    private ClickListener clickListener;

    public VisSlider(float min, float max, float stepSize, boolean vertical) {
        this(min, max, stepSize, vertical, VisUI.getSkin().get("default-" + (vertical ? "vertical" : "horizontal"), VisSliderStyle.class));
    }

    public VisSlider(float min, float max, float stepSize, boolean vertical, String styleName) {
        this(min, max, stepSize, vertical, VisUI.getSkin().get(styleName, VisSliderStyle.class));
    }

    public VisSlider(float min, float max, float stepSize, boolean vertical, VisSliderStyle style) {
        super(min, max, stepSize, vertical, style);
        this.shiftIgnoresSnap = true;
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (VisSlider.this.disabled) {
                    return false;
                }
                if (VisSlider.this.draggingPointer != -1) {
                    return false;
                }
                VisSlider.this.draggingPointer = pointer;
                VisSlider.this.calculatePositionAndValue(x, y);
                FocusManager.getFocus();
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer != VisSlider.this.draggingPointer) {
                    return;
                }
                VisSlider.this.draggingPointer = -1;
                if (!VisSlider.this.calculatePositionAndValue(x, y)) {
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    VisSlider.this.fire(changeEvent);
                    Pools.free(changeEvent);
                }
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                VisSlider.this.calculatePositionAndValue(x, y);
            }
        });
        this.clickListener = new ClickListener();
        this.addListener(this.clickListener);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        VisSliderStyle style = this.getStyle();
        boolean disabled = this.disabled;
        Drawable knob = disabled && style.disabledKnob != null ? style.disabledKnob : (this.isDragging() ? style.knobDown : (this.clickListener.isOver() ? style.knobOver : style.knob));
        Drawable bg = disabled && style.disabledBackground != null ? style.disabledBackground : style.background;
        Drawable knobBefore = disabled && style.disabledKnobBefore != null ? style.disabledKnobBefore : style.knobBefore;
        Drawable knobAfter = disabled && style.disabledKnobAfter != null ? style.disabledKnobAfter : style.knobAfter;
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        float knobHeight = knob == null ? 0.0f : knob.getMinHeight();
        float knobWidth = knob == null ? 0.0f : knob.getMinWidth();
        float value = this.getVisualValue();
        float min = this.getMinValue();
        float max = this.getMaxValue();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        if (this.vertical) {
            bg.draw(batch, x + (float)((int)((width - bg.getMinWidth()) * 0.5f)), y, bg.getMinWidth(), height);
            float positionHeight = height - (bg.getTopHeight() + bg.getBottomHeight());
            float knobHeightHalf = 0.0f;
            if (min != max) {
                if (knob == null) {
                    knobHeightHalf = knobBefore == null ? 0.0f : knobBefore.getMinHeight() * 0.5f;
                    this.position = (value - min) / (max - min) * (positionHeight - knobHeightHalf);
                    this.position = Math.min(positionHeight - knobHeightHalf, this.position);
                } else {
                    knobHeightHalf = knobHeight * 0.5f;
                    this.position = (value - min) / (max - min) * (positionHeight - knobHeight);
                    this.position = Math.min(positionHeight - knobHeight, this.position) + bg.getBottomHeight();
                }
                this.position = Math.max(0.0f, this.position);
            }
            if (knobBefore != null) {
                float offset = 0.0f;
                if (bg != null) {
                    offset = bg.getTopHeight();
                }
                knobBefore.draw(batch, x + (float)((int)((width - knobBefore.getMinWidth()) * 0.5f)), y + offset, knobBefore.getMinWidth(), (int)(this.position + knobHeightHalf));
            }
            if (knobAfter != null) {
                knobAfter.draw(batch, x + (float)((int)((width - knobAfter.getMinWidth()) * 0.5f)), y + (float)((int)(this.position + knobHeightHalf)), knobAfter.getMinWidth(), height - (float)((int)(this.position + knobHeightHalf)));
            }
            if (knob != null) {
                knob.draw(batch, x + (float)((int)((width - knobWidth) * 0.5f)), (int)(y + this.position), knobWidth, knobHeight);
            }
        } else {
            bg.draw(batch, x, y + (float)((int)((height - bg.getMinHeight()) * 0.5f)), width, bg.getMinHeight());
            float positionWidth = width - (bg.getLeftWidth() + bg.getRightWidth());
            float knobWidthHalf = 0.0f;
            if (min != max) {
                if (knob == null) {
                    knobWidthHalf = knobBefore == null ? 0.0f : knobBefore.getMinWidth() * 0.5f;
                    this.position = (value - min) / (max - min) * (positionWidth - knobWidthHalf);
                    this.position = Math.min(positionWidth - knobWidthHalf, this.position);
                } else {
                    knobWidthHalf = knobWidth * 0.5f;
                    this.position = (value - min) / (max - min) * (positionWidth - knobWidth);
                    this.position = Math.min(positionWidth - knobWidth, this.position) + bg.getLeftWidth();
                }
                this.position = Math.max(0.0f, this.position);
            }
            if (knobBefore != null) {
                float offset = 0.0f;
                if (bg != null) {
                    offset = bg.getLeftWidth();
                }
                knobBefore.draw(batch, x + offset, y + (float)((int)((height - knobBefore.getMinHeight()) * 0.5f)), (int)(this.position + knobWidthHalf), knobBefore.getMinHeight());
            }
            if (knobAfter != null) {
                knobAfter.draw(batch, x + (float)((int)(this.position + knobWidthHalf)), y + (float)((int)((height - knobAfter.getMinHeight()) * 0.5f)), width - (float)((int)(this.position + knobWidthHalf)), knobAfter.getMinHeight());
            }
            if (knob != null) {
                knob.draw(batch, (int)(x + this.position), (int)(y + (height - knobHeight) * 0.5f), knobWidth, knobHeight);
            }
        }
    }

    public void setStyle(VisSliderStyle style) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (!(style instanceof VisSliderStyle)) {
            throw new IllegalArgumentException("style must be a SliderStyle.");
        }
        super.setStyle(style);
    }

    @Override
    public VisSliderStyle getStyle() {
        return (VisSliderStyle)super.getStyle();
    }

    boolean calculatePositionAndValue(float x, float y) {
        float value;
        VisSliderStyle style = this.getStyle();
        Drawable knob = this.disabled && style.disabledKnob != null ? style.disabledKnob : style.knob;
        Drawable bg = this.disabled && style.disabledBackground != null ? style.disabledBackground : style.background;
        float oldPosition = this.position;
        float min = this.getMinValue();
        float max = this.getMaxValue();
        if (this.vertical) {
            float height = this.getHeight() - bg.getTopHeight() - bg.getBottomHeight();
            float knobHeight = knob == null ? 0.0f : knob.getMinHeight();
            this.position = y - bg.getBottomHeight() - knobHeight * 0.5f;
            value = min + (max - min) * (this.position / (height - knobHeight));
            this.position = Math.max(0.0f, this.position);
            this.position = Math.min(height - knobHeight, this.position);
        } else {
            float width = this.getWidth() - bg.getLeftWidth() - bg.getRightWidth();
            float knobWidth = knob == null ? 0.0f : knob.getMinWidth();
            this.position = x - bg.getLeftWidth() - knobWidth * 0.5f;
            value = min + (max - min) * (this.position / (width - knobWidth));
            this.position = Math.max(0.0f, this.position);
            this.position = Math.min(width - knobWidth, this.position);
        }
        float oldValue = value;
        boolean valueSet = this.setValue(value);
        if (value == oldValue) {
            this.position = oldPosition;
        }
        return valueSet;
    }

    public boolean isDragging() {
        return this.draggingPointer != -1;
    }

    public static class VisSliderStyle
    extends ProgressBar.ProgressBarStyle {
        public Drawable knobOver;
        public Drawable knobDown;

        public VisSliderStyle() {
        }

        public VisSliderStyle(Drawable background, Drawable knob) {
            super(background, knob);
        }

        public VisSliderStyle(VisSliderStyle style) {
            super(style);
            this.knobOver = style.knobOver;
            this.knobDown = style.knobDown;
        }
    }
}

