/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisWindow;

public class VisDialog
extends VisWindow {
    Table contentTable;
    Table buttonTable;
    private Skin skin;
    ObjectMap<Actor, Object> values = new ObjectMap();
    boolean cancelHide;
    Actor previousKeyboardFocus;
    Actor previousScrollFocus;
    FocusListener focusListener;
    protected InputListener ignoreTouchDown = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            event.cancel();
            return false;
        }
    };

    public VisDialog(String title) {
        super(title);
        this.skin = VisUI.getSkin();
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
        this.defaults().space(6.0f);
        this.contentTable = new Table(this.skin);
        this.add(this.contentTable).expand().fill();
        this.row();
        this.buttonTable = new Table(this.skin);
        this.add(this.buttonTable);
        this.contentTable.defaults().space(2.0f).padLeft(3.0f).padRight(3.0f);
        this.buttonTable.defaults().space(6.0f).padBottom(3.0f);
        this.buttonTable.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!VisDialog.this.values.containsKey(actor)) {
                    return;
                }
                while (actor.getParent() != VisDialog.this.buttonTable) {
                    actor = actor.getParent();
                }
                VisDialog.this.result(VisDialog.this.values.get(actor));
                if (!VisDialog.this.cancelHide) {
                    VisDialog.this.hide();
                }
                VisDialog.this.cancelHide = false;
            }
        });
        this.focusListener = new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            @Override
            public void scrollFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            private void focusChanged(FocusListener.FocusEvent event) {
                Actor newFocusedActor;
                Stage stage = VisDialog.this.getStage();
                if (VisDialog.this.isModal() && stage != null && stage.getRoot().getChildren().size > 0 && stage.getRoot().getChildren().peek() == VisDialog.this && (newFocusedActor = event.getRelatedActor()) != null && !newFocusedActor.isDescendantOf(VisDialog.this)) {
                    event.cancel();
                }
            }
        };
    }

    @Override
    protected void setStage(Stage stage) {
        if (stage == null) {
            this.addListener(this.focusListener);
        } else {
            this.removeListener(this.focusListener);
        }
        super.setStage(stage);
    }

    public Table getContentTable() {
        return this.contentTable;
    }

    public Table getButtonsTable() {
        return this.buttonTable;
    }

    public VisDialog text(String text) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.text(text, this.skin.get(Label.LabelStyle.class));
    }

    public VisDialog text(String text, Label.LabelStyle labelStyle) {
        return this.text(new Label((CharSequence)text, labelStyle));
    }

    public VisDialog text(Label label) {
        this.contentTable.add(label);
        return this;
    }

    public VisDialog button(String text) {
        return this.button(text, null);
    }

    public VisDialog button(String text, Object object) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.button(text, object, this.skin.get(VisTextButton.VisTextButtonStyle.class));
    }

    public VisDialog button(String text, Object object, VisTextButton.VisTextButtonStyle buttonStyle) {
        return this.button(new VisTextButton(text, buttonStyle), object);
    }

    public VisDialog button(Button button) {
        return this.button(button, null);
    }

    public VisDialog button(Button button, Object object) {
        this.buttonTable.add(button);
        this.setObject(button, object);
        return this;
    }

    public VisDialog show(Stage stage, Action action) {
        this.clearActions();
        this.removeCaptureListener(this.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        Actor actor = stage.getKeyboardFocus();
        if (actor != null && !actor.isDescendantOf(this)) {
            this.previousKeyboardFocus = actor;
        }
        this.previousScrollFocus = null;
        actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf(this)) {
            this.previousScrollFocus = actor;
        }
        this.pack();
        stage.addActor(this);
        stage.setKeyboardFocus(this);
        stage.setScrollFocus(this);
        if (action != null) {
            this.addAction(action);
        }
        return this;
    }

    public VisDialog show(Stage stage) {
        this.show(stage, Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.4f, Interpolation.fade)));
        this.setPosition(Math.round((stage.getWidth() - this.getWidth()) / 2.0f), Math.round((stage.getHeight() - this.getHeight()) / 2.0f));
        return this;
    }

    public void hide(Action action) {
        Stage stage = this.getStage();
        if (stage != null) {
            Actor actor;
            this.removeListener(this.focusListener);
            if (this.previousKeyboardFocus != null && this.previousKeyboardFocus.getStage() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((actor = stage.getKeyboardFocus()) == null || actor.isDescendantOf(this)) {
                stage.setKeyboardFocus(this.previousKeyboardFocus);
            }
            if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || actor.isDescendantOf(this)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        if (action != null) {
            this.addCaptureListener(this.ignoreTouchDown);
            this.addAction(Actions.sequence(action, (Action)Actions.removeListener(this.ignoreTouchDown, true), (Action)Actions.removeActor()));
        } else {
            this.remove();
        }
    }

    public void hide() {
        this.hide(Actions.sequence((Action)Actions.fadeOut(FADE_TIME, Interpolation.fade), (Action)Actions.removeListener(this.ignoreTouchDown, true), (Action)Actions.removeActor()));
    }

    public void setObject(Actor actor, Object object) {
        this.values.put(actor, object);
    }

    public VisDialog key(final int keycode, final Object object) {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode2) {
                if (keycode == keycode2) {
                    VisDialog.this.result(object);
                    if (!VisDialog.this.cancelHide) {
                        VisDialog.this.hide();
                    }
                    VisDialog.this.cancelHide = false;
                }
                return false;
            }
        });
        return this;
    }

    protected void result(Object object) {
    }

    public void cancel() {
        this.cancelHide = true;
    }
}

