/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;

public class Tooltip
extends VisTable {
    public static final float DEFAULT_FADE_TIME = 0.3f;
    public static final float DEFAULT_APPEAR_DELAY_TIME = 0.6f;
    private TooltipStyle style;
    private Actor target;
    private Actor content;
    private Cell<Actor> contentCell;
    private TooltipInputListener listener;
    private DisplayTask displayTask;
    private float fadeTime = 0.3f;
    private float appearDelayTime = 0.6f;

    public Tooltip(Actor target, String text) {
        this("default", target, text);
    }

    public Tooltip(Actor target, Actor content) {
        this("default", target, content);
    }

    public Tooltip(String styleName, Actor target, String text) {
        super(true);
        VisLabel label = new VisLabel(text);
        label.setAlignment(1);
        this.init(VisUI.getSkin().get(styleName, TooltipStyle.class), target, label);
    }

    public Tooltip(String styleName, Actor target, Actor content) {
        super(true);
        this.init(VisUI.getSkin().get(styleName, TooltipStyle.class), target, content);
    }

    public Tooltip(String text) {
        super(true);
        this.style = VisUI.getSkin().get(TooltipStyle.class);
        VisLabel label = new VisLabel(text);
        label.setAlignment(1);
        this.init(VisUI.getSkin().get("default", TooltipStyle.class), null, label);
    }

    public Tooltip(Actor content) {
        super(true);
        this.init(VisUI.getSkin().get("default", TooltipStyle.class), null, content);
    }

    public Tooltip(Actor target, Actor content, TooltipStyle style) {
        super(true);
        this.init(style, target, content);
    }

    public static void removeTooltip(Actor target) {
        Array<EventListener> listeners = target.getListeners();
        for (EventListener listener : listeners) {
            if (!(listener instanceof TooltipInputListener)) continue;
            target.removeListener(listener);
        }
    }

    private void init(TooltipStyle style, Actor target, Actor content) {
        this.target = target;
        this.content = content;
        this.listener = new TooltipInputListener();
        this.displayTask = new DisplayTask();
        this.style = style;
        this.setBackground(style.background);
        this.contentCell = this.add(content).padLeft(3.0f).padRight(3.0f).padBottom(2.0f);
        this.pack();
        if (target != null) {
            this.attach();
        }
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Tooltip.this.toFront();
                return true;
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (pointer == -1) {
                    Tooltip.this.clearActions();
                    Tooltip.this.addAction(Actions.sequence((Action)Actions.fadeIn(Tooltip.this.fadeTime, Interpolation.fade)));
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (pointer == -1) {
                    Tooltip.this.fadeOut();
                }
            }
        });
    }

    public void attach() {
        if (this.target == null) {
            return;
        }
        Array<EventListener> listeners = this.target.getListeners();
        for (EventListener listener : listeners) {
            if (!(listener instanceof TooltipInputListener)) continue;
            throw new IllegalStateException("More than one tooltip cannot be added to the same target!");
        }
        this.target.addListener(this.listener);
    }

    public void detach() {
        if (this.target == null) {
            return;
        }
        this.target.removeListener(this.listener);
    }

    public void setTarget(Actor newTarget) {
        this.detach();
        this.target = newTarget;
        this.attach();
    }

    private void fadeOut() {
        this.clearActions();
        this.addAction(Actions.sequence((Action)Actions.fadeOut(this.fadeTime, Interpolation.fade), (Action)Actions.removeActor()));
    }

    private VisTable fadeIn() {
        this.clearActions();
        this.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.addAction(Actions.sequence((Action)Actions.fadeIn(this.fadeTime, Interpolation.fade)));
        return this;
    }

    public Actor getContent() {
        return this.content;
    }

    public void setContent(Actor content) {
        this.content = content;
        this.contentCell.setActor(content);
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition((int)x, (int)y);
    }

    public float getAppearDelayTime() {
        return this.appearDelayTime;
    }

    public void setAppearDelayTime(float appearDelayTime) {
        this.appearDelayTime = appearDelayTime;
    }

    public float getFadeTime() {
        return this.fadeTime;
    }

    public void setFadeTime(float fadeTime) {
        this.fadeTime = fadeTime;
    }

    private void keepWithinStage() {
        Stage stage = this.getStage();
        Camera camera = stage.getCamera();
        if (camera instanceof OrthographicCamera) {
            OrthographicCamera orthographicCamera = (OrthographicCamera)camera;
            float parentWidth = stage.getWidth();
            float parentHeight = stage.getHeight();
            if (this.getX(16) - camera.position.x > parentWidth / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x + parentWidth / 2.0f / orthographicCamera.zoom, this.getY(16), 16);
            }
            if (this.getX(8) - camera.position.x < -parentWidth / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x - parentWidth / 2.0f / orthographicCamera.zoom, this.getY(8), 8);
            }
            if (this.getY(2) - camera.position.y > parentHeight / 2.0f / orthographicCamera.zoom) {
                this.setPosition(this.getX(2), camera.position.y + parentHeight / 2.0f / orthographicCamera.zoom, 2);
            }
            if (this.getY(4) - camera.position.y < -parentHeight / 2.0f / orthographicCamera.zoom) {
                this.setPosition(this.getX(4), camera.position.y - parentHeight / 2.0f / orthographicCamera.zoom, 4);
            }
        } else if (this.getParent() == stage.getRoot()) {
            float parentWidth = stage.getWidth();
            float parentHeight = stage.getHeight();
            if (this.getX() < 0.0f) {
                this.setX(0.0f);
            }
            if (this.getRight() > parentWidth) {
                this.setX(parentWidth - this.getWidth());
            }
            if (this.getY() < 0.0f) {
                this.setY(0.0f);
            }
            if (this.getTop() > parentHeight) {
                this.setY(parentHeight - this.getHeight());
            }
        }
    }

    public static class TooltipStyle {
        public Drawable background;

        public TooltipStyle() {
        }

        public TooltipStyle(Drawable background) {
            this.background = background;
        }
    }

    private class TooltipInputListener
    extends InputListener {
        private TooltipInputListener() {
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            Tooltip.this.toFront();
            Tooltip.this.fadeOut();
            return true;
        }

        @Override
        public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
            if (pointer == -1) {
                Vector2 targetPos = Tooltip.this.target.localToStageCoordinates(new Vector2());
                Tooltip.this.setX(targetPos.x + (Tooltip.this.target.getWidth() - Tooltip.this.getWidth()) / 2.0f);
                float tooltipY = targetPos.y - Tooltip.this.getHeight() - 6.0f;
                float stageHeight = Tooltip.this.target.getStage().getHeight();
                if (stageHeight - tooltipY > stageHeight) {
                    Tooltip.this.setY(targetPos.y + Tooltip.this.target.getHeight() + 6.0f);
                } else {
                    Tooltip.this.setY(tooltipY);
                }
                Tooltip.this.displayTask.cancel();
                Timer.schedule(Tooltip.this.displayTask, Tooltip.this.appearDelayTime);
            }
        }

        @Override
        public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
            if (pointer == -1) {
                Tooltip.this.displayTask.cancel();
                Tooltip.this.fadeOut();
            }
        }

        @Override
        public boolean mouseMoved(InputEvent event, float x, float y) {
            if (Tooltip.this.isVisible() && Tooltip.this.getActions().size == 0) {
                Tooltip.this.fadeOut();
            }
            return false;
        }
    }

    private class DisplayTask
    extends Timer.Task {
        private DisplayTask() {
        }

        @Override
        public void run() {
            Tooltip.this.target.getStage().addActor(Tooltip.this.fadeIn());
            Tooltip.this.keepWithinStage();
        }
    }
}

