/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.VisUI;

public class Separator
extends Widget {
    private SeparatorStyle style;

    public Separator() {
        this.style = VisUI.getSkin().get(SeparatorStyle.class);
    }

    public Separator(boolean vertical) {
        this.style = VisUI.getSkin().get(vertical ? "vertical" : "default", SeparatorStyle.class);
    }

    public Separator(String styleName) {
        this.style = VisUI.getSkin().get(styleName, SeparatorStyle.class);
    }

    public Separator(SeparatorStyle style) {
        this.style = style;
    }

    @Override
    public float getPrefHeight() {
        return this.style.thickness;
    }

    @Override
    public float getPrefWidth() {
        return this.style.thickness;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Color c = this.getColor();
        batch.setColor(c.r, c.g, c.b, c.a * parentAlpha);
        this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public SeparatorStyle getStyle() {
        return this.style;
    }

    public static class SeparatorStyle {
        public Drawable background;
        public int thickness;
        public boolean vertical;

        public SeparatorStyle() {
        }

        public SeparatorStyle(Drawable bg, int thickness) {
            this(bg, thickness, false);
        }

        public SeparatorStyle(Drawable bg, int thickness, boolean vertical) {
            this.background = bg;
            this.thickness = thickness;
            this.vertical = vertical;
        }
    }
}

