/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.InputValidator;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.Validators;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidableTextField;

public class NumberSelector
extends VisTable {
    private Array<NumberSelectorListener> listeners = new Array();
    private VisValidableTextField valueText;
    private ButtonRepeatTask buttonRepeatTask = new ButtonRepeatTask();
    private float buttonRepeatInitialTime = 0.4f;
    private float buttonRepeatTime = 0.08f;
    private int max;
    private int min;
    private int step;
    private int current;

    public NumberSelector(String name, int initialValue, int min, int max) {
        this(name, initialValue, min, max, 1);
    }

    public NumberSelector(String name, int initialValue, int min, int max, int step) {
        this("default", name, initialValue, min, max, step);
    }

    public NumberSelector(String styleName, String name, int initialValue, int min, int max, int step) {
        this(VisUI.getSkin().get(styleName, NumberSelectorStyle.class), name, initialValue, min, max, step);
    }

    public NumberSelector(NumberSelectorStyle style, String name, int initialValue, int min, int max, int step) {
        this.current = initialValue;
        this.max = max;
        this.min = min;
        this.step = step;
        this.valueText = new VisValidableTextField((InputValidator)Validators.INTEGERS){

            @Override
            public float getPrefWidth() {
                return 40.0f;
            }
        };
        this.valueText.setProgrammaticChangeEvents(false);
        this.valueText.setTextFieldFilter(new VisTextField.TextFieldFilter.DigitsOnlyFilter());
        this.valueText.setText(String.valueOf(this.current));
        this.valueText.addValidator(new InputValidator(){

            @Override
            public boolean validateInput(String input) {
                return NumberSelector.this.checkInput(input);
            }
        });
        VisTable buttonsTable = new VisTable();
        VisImageButton up = new VisImageButton(style.up);
        VisImageButton down = new VisImageButton(style.down);
        buttonsTable.add(up).height(12.0f).row();
        buttonsTable.add(down).height(12.0f);
        int padding = 0;
        if (name != null && name.length() != 0) {
            this.add(name);
            padding = 6;
        }
        this.add(this.valueText).fillX().expandX().height(24.0f).padLeft(padding).padRight(1.0f);
        this.add(buttonsTable).width(12.0f);
        up.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NumberSelector.this.getStage().setScrollFocus(NumberSelector.this.valueText);
                NumberSelector.this.increment();
            }
        });
        down.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NumberSelector.this.getStage().setScrollFocus(NumberSelector.this.valueText);
                NumberSelector.this.decrement();
            }
        });
        up.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!NumberSelector.this.buttonRepeatTask.isScheduled()) {
                    ((NumberSelector)NumberSelector.this).buttonRepeatTask.increment = true;
                    NumberSelector.this.buttonRepeatTask.cancel();
                    Timer.schedule(NumberSelector.this.buttonRepeatTask, NumberSelector.this.buttonRepeatInitialTime, NumberSelector.this.buttonRepeatTime);
                }
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                NumberSelector.this.buttonRepeatTask.cancel();
            }
        });
        down.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!NumberSelector.this.buttonRepeatTask.isScheduled()) {
                    ((NumberSelector)NumberSelector.this).buttonRepeatTask.increment = false;
                    NumberSelector.this.buttonRepeatTask.cancel();
                    Timer.schedule(NumberSelector.this.buttonRepeatTask, NumberSelector.this.buttonRepeatInitialTime, NumberSelector.this.buttonRepeatTime);
                }
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                NumberSelector.this.buttonRepeatTask.cancel();
            }
        });
        this.valueText.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NumberSelector.this.textChanged();
            }
        });
        this.valueText.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    NumberSelector.this.valueChanged();
                    NumberSelector.this.getStage().setScrollFocus(null);
                }
            }
        });
        this.valueText.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                NumberSelector.this.getStage().setScrollFocus(NumberSelector.this.valueText);
                return true;
            }

            @Override
            public boolean scrolled(InputEvent event, float x, float y, int amount) {
                if (amount == 1) {
                    NumberSelector.this.decrement();
                } else {
                    NumberSelector.this.increment();
                }
                return true;
            }
        });
    }

    private void textChanged() {
        if (this.valueText.getText().equals("")) {
            this.current = this.min;
        } else if (this.checkInput(this.valueText.getText())) {
            this.current = Integer.parseInt(this.valueText.getText());
        }
    }

    public void increment() {
        this.current = this.current + this.step > this.max ? this.max : (this.current += this.step);
        this.valueChanged();
    }

    public void decrement() {
        this.current = this.current - this.step < this.min ? this.min : (this.current -= this.step);
        this.valueChanged();
    }

    public void setValue(int newValue) {
        this.current = newValue > this.max ? this.max : (newValue < this.min ? this.min : newValue);
        this.valueChanged();
    }

    public int getValue() {
        return this.current;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
        if (this.current < min) {
            this.current = min;
            this.valueChanged();
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
        if (this.current > max) {
            this.current = max;
            this.valueChanged();
        }
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    private boolean checkInput(String input) {
        try {
            int x = Integer.parseInt(input);
            return x >= this.min && x <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void valueChanged() {
        int pos = this.valueText.getCursorPosition();
        this.valueText.setText(String.valueOf(this.current));
        this.valueText.setCursorPosition(pos);
        for (NumberSelectorListener listener : this.listeners) {
            listener.changed(this.current);
        }
    }

    public void addChangeListener(NumberSelectorListener listener) {
        if (listener != null && !this.listeners.contains(listener, true)) {
            this.listeners.add(listener);
        }
    }

    private class ButtonRepeatTask
    extends Timer.Task {
        boolean increment;

        private ButtonRepeatTask() {
        }

        @Override
        public void run() {
            if (this.increment) {
                NumberSelector.this.increment();
            } else {
                NumberSelector.this.decrement();
            }
        }
    }

    public static interface NumberSelectorListener {
        public void changed(int var1);
    }

    public static class NumberSelectorStyle {
        public Drawable up;
        public Drawable down;

        public NumberSelectorStyle() {
        }

        public NumberSelectorStyle(Drawable up, Drawable down) {
            this.up = up;
            this.down = down;
        }
    }
}

