/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.MenuBar;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.VisTextButton;

public class Menu
extends PopupMenu {
    private MenuBar menuBar;
    public VisTextButton openButton;
    public Drawable buttonDefault;
    private String title;

    public Menu(String title) {
        this(title, "default");
    }

    public Menu(String title, String styleName) {
        this(title, VisUI.getSkin().get(styleName, MenuStyle.class));
    }

    public Menu(String title, MenuStyle style) {
        super(style);
        this.title = title;
        this.openButton = new VisTextButton(title, new VisTextButton.VisTextButtonStyle(VisUI.getSkin().get(style.openButtonStyleName, VisTextButton.VisTextButtonStyle.class)));
        this.buttonDefault = this.openButton.getStyle().up;
        this.openButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (Menu.this.menuBar.getCurrentMenu() == Menu.this) {
                    Menu.this.menuBar.closeMenu();
                    return true;
                }
                Menu.this.switchMenu();
                event.stop();
                return true;
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (Menu.this.menuBar.getCurrentMenu() != null) {
                    Menu.this.switchMenu();
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    private void switchMenu() {
        this.menuBar.closeMenu();
        this.showMenu();
    }

    private void showMenu() {
        Vector2 pos = this.openButton.localToStageCoordinates(new Vector2(0.0f, 0.0f));
        this.setPosition(pos.x, pos.y - this.getHeight());
        this.openButton.getStage().addActor(this);
        this.menuBar.setCurrentMenu(this);
    }

    @Override
    public boolean remove() {
        boolean result = super.remove();
        this.menuBar.setCurrentMenu(null);
        return result;
    }

    void setMenuBar(MenuBar menuBar) {
        if (this.menuBar != null) {
            throw new IllegalStateException("Menu was already added to MenuBar");
        }
        this.menuBar = menuBar;
    }

    TextButton getOpenButton() {
        return this.openButton;
    }

    void selectButton() {
        this.openButton.getStyle().up = this.openButton.getStyle().over;
    }

    void deselectButton() {
        this.openButton.getStyle().up = this.buttonDefault;
    }

    public static class MenuStyle
    extends PopupMenu.PopupMenuStyle {
        public String openButtonStyleName;

        public MenuStyle() {
        }

        public MenuStyle(Drawable background, Drawable border, String openButtonStyleName) {
            super(background, border);
            this.openButtonStyleName = openButtonStyleName;
        }
    }
}

