/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisLabel;

public class LinkLabel
extends VisLabel {
    private static final String DEFAULT_COLOR_NAME = "link-label";
    private LinkLabelListener listener;
    private CharSequence url;

    public LinkLabel(CharSequence text) {
        super(text);
        this.setColor(VisUI.getSkin().getColor(DEFAULT_COLOR_NAME));
        this.init(text);
    }

    public LinkLabel(CharSequence text, CharSequence url) {
        super(text);
        this.setColor(VisUI.getSkin().getColor(DEFAULT_COLOR_NAME));
        this.init(url);
    }

    public LinkLabel(CharSequence text, int alignment) {
        super(text, alignment);
        this.setColor(VisUI.getSkin().getColor(DEFAULT_COLOR_NAME));
        this.init(text);
    }

    public LinkLabel(CharSequence text, Color textColor) {
        super(text, textColor);
        this.init(text);
    }

    public LinkLabel(CharSequence text, Label.LabelStyle style) {
        super(text, style);
        this.init(text);
    }

    public LinkLabel(CharSequence text, CharSequence url, String styleName) {
        super(text, styleName);
        this.init(url);
    }

    public LinkLabel(CharSequence text, String fontName, Color color) {
        super(text, fontName, color);
        this.init(text);
    }

    public LinkLabel(CharSequence text, String fontName, String colorName) {
        super(text, fontName, colorName);
        this.init(text);
    }

    private void init(CharSequence linkUrl) {
        this.url = linkUrl;
        this.addListener(new ClickListener(0){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (LinkLabel.this.listener == null) {
                    Gdx.net.openURI(LinkLabel.this.url.toString());
                } else {
                    LinkLabel.this.listener.clicked(LinkLabel.this.url.toString());
                }
            }
        });
    }

    public CharSequence getUrl() {
        return this.url;
    }

    public void setUrl(CharSequence url) {
        this.url = url;
    }

    public LinkLabelListener getListener() {
        return this.listener;
    }

    public void setListener(LinkLabelListener listener) {
        this.listener = listener;
    }

    public static interface LinkLabelListener {
        public void clicked(String var1);
    }
}

