/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;

public class CollapsibleWidget
extends WidgetGroup {
    private Table table;
    private boolean collapsed;
    private boolean actionRunning;
    private float currentHeight;

    public CollapsibleWidget(Table table) {
        this(table, false);
    }

    public CollapsibleWidget(Table table, boolean collapsed) {
        this.collapsed = collapsed;
        this.table = table;
        this.updateTouchable();
        this.addActor(table);
    }

    public void setCollapsed(boolean collapse, boolean withAnimation) {
        this.collapsed = collapse;
        this.actionRunning = true;
        this.updateTouchable();
        if (withAnimation) {
            this.addAction(new Action(){

                @Override
                public boolean act(float delta) {
                    if (CollapsibleWidget.this.collapsed) {
                        CollapsibleWidget.this.currentHeight = CollapsibleWidget.this.currentHeight - delta * 1000.0f;
                        if (CollapsibleWidget.this.currentHeight <= 0.0f) {
                            CollapsibleWidget.this.currentHeight = 0.0f;
                            CollapsibleWidget.this.collapsed = true;
                            CollapsibleWidget.this.actionRunning = false;
                        }
                    } else {
                        CollapsibleWidget.this.currentHeight = CollapsibleWidget.this.currentHeight + delta * 1000.0f;
                        if (CollapsibleWidget.this.currentHeight > CollapsibleWidget.this.table.getPrefHeight()) {
                            CollapsibleWidget.this.currentHeight = CollapsibleWidget.this.table.getPrefHeight();
                            CollapsibleWidget.this.collapsed = false;
                            CollapsibleWidget.this.actionRunning = false;
                        }
                    }
                    CollapsibleWidget.this.invalidateHierarchy();
                    return !CollapsibleWidget.this.actionRunning;
                }
            });
        } else {
            if (collapse) {
                this.currentHeight = 0.0f;
                this.collapsed = true;
            } else {
                this.currentHeight = this.table.getPrefHeight();
                this.collapsed = false;
            }
            this.actionRunning = false;
            this.invalidateHierarchy();
        }
    }

    public void setCollapsed(boolean collapse) {
        this.setCollapsed(collapse, true);
    }

    private void updateTouchable() {
        if (this.collapsed) {
            this.setTouchable(Touchable.disabled);
        } else {
            this.setTouchable(Touchable.enabled);
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.currentHeight > 1.0f) {
            batch.flush();
            boolean clipEnabled = this.clipBegin(this.getX(), this.getY(), this.getWidth(), this.currentHeight);
            super.draw(batch, parentAlpha);
            batch.flush();
            if (clipEnabled) {
                this.clipEnd();
            }
        }
    }

    @Override
    public void layout() {
        super.layout();
        this.table.setBounds(0.0f, 0.0f, this.table.getPrefWidth(), this.table.getPrefHeight());
        if (!this.actionRunning) {
            this.currentHeight = this.collapsed ? 0.0f : this.table.getPrefHeight();
        }
    }

    @Override
    public float getPrefWidth() {
        return this.table.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        if (!this.actionRunning) {
            if (this.collapsed) {
                return 0.0f;
            }
            return this.table.getPrefHeight();
        }
        return this.currentHeight;
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
    }
}

