/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.form;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.InputValidator;
import com.kotcrab.vis.ui.util.Validators;
import com.kotcrab.vis.ui.util.form.FormInputValidator;
import com.kotcrab.vis.ui.util.form.ValidatorWrapper;
import com.kotcrab.vis.ui.widget.VisValidableTextField;

public class SimpleFormValidator {
    private ChangeSharedListener changeListener = new ChangeSharedListener();
    private Array<VisValidableTextField> fields = new Array();
    private Button button;
    private Label errorMsgLabel;

    public SimpleFormValidator(Button buttonToDisable, Label errorMsgLabel) {
        this.button = buttonToDisable;
        this.errorMsgLabel = errorMsgLabel;
    }

    public void notEmpty(VisValidableTextField field, String errorMsg) {
        field.addValidator(new EmptyInputValidator(errorMsg));
        this.add(field);
    }

    public void integerNumber(VisValidableTextField field, String errorMsg) {
        field.addValidator(new ValidatorWrapper(errorMsg, Validators.INTEGERS));
        this.add(field);
    }

    public void floatNumber(VisValidableTextField field, String errorMsg) {
        field.addValidator(new ValidatorWrapper(errorMsg, Validators.FLOATS));
        this.add(field);
    }

    public void valueGreaterThan(VisValidableTextField field, String errorMsg, float value) {
        this.valueGreaterThan(field, errorMsg, value, false);
    }

    public void valueLesserThan(VisValidableTextField field, String errorMsg, float value) {
        this.valueLesserThan(field, errorMsg, value, false);
    }

    public void valueGreaterThan(VisValidableTextField field, String errorMsg, float value, boolean equals) {
        field.addValidator(new ValidatorWrapper(errorMsg, new Validators.GreaterThanValidator(value, equals)));
        this.add(field);
    }

    public void valueLesserThan(VisValidableTextField field, String errorMsg, float value, boolean equals) {
        field.addValidator(new ValidatorWrapper(errorMsg, new Validators.LesserThanValidator(value, equals)));
        this.add(field);
    }

    public void custom(VisValidableTextField field, FormInputValidator customValidator) {
        field.addValidator(customValidator);
        this.add(field);
    }

    protected void add(VisValidableTextField field) {
        this.fields.add(field);
        field.addListener(this.changeListener);
        this.checkAll();
    }

    private void checkAll() {
        this.button.setDisabled(false);
        this.errorMsgLabel.setText("");
        for (VisValidableTextField field : this.fields) {
            field.validateInput();
        }
        block1: for (VisValidableTextField field : this.fields) {
            if (field.isInputValid()) continue;
            Array<InputValidator> validators = field.getValidators();
            for (InputValidator v : validators) {
                FormInputValidator validator = (FormInputValidator)v;
                if (validator.getLastResult()) continue;
                this.errorMsgLabel.setText(validator.getErrorMsg());
                this.button.setDisabled(true);
                break block1;
            }
        }
    }

    private class ChangeSharedListener
    extends ChangeListener {
        private ChangeSharedListener() {
        }

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            SimpleFormValidator.this.checkAll();
        }
    }

    public static class EmptyInputValidator
    extends FormInputValidator {
        public EmptyInputValidator(String errorMsg) {
            super(errorMsg);
        }

        @Override
        public boolean validate(String input) {
            return !input.isEmpty();
        }
    }
}

