/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.form;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.kotcrab.vis.ui.util.form.FormInputValidator;
import com.kotcrab.vis.ui.util.form.SimpleFormValidator;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidableTextField;
import java.io.File;

public class FormValidator
extends SimpleFormValidator {
    public FormValidator(Button buttonToDisable, Label errorMsgLabel) {
        super(buttonToDisable, errorMsgLabel);
    }

    public void fileExists(VisValidableTextField field, String errorMsg) {
        field.addValidator(new FileExistsValidator(errorMsg));
        this.add(field);
    }

    public void fileExists(VisValidableTextField field, VisTextField relativeTo, String errorMsg) {
        field.addValidator(new FileExistsValidator(relativeTo, errorMsg));
        this.add(field);
    }

    public void fileExists(VisValidableTextField field, VisTextField relativeTo, String errorMsg, boolean errorIfRelativeEmpty) {
        field.addValidator(new FileExistsValidator(relativeTo, errorMsg, false, errorIfRelativeEmpty));
        this.add(field);
    }

    public void fileExists(VisValidableTextField field, File relativeTo, String errorMsg) {
        field.addValidator(new FileExistsValidator(relativeTo, errorMsg));
        this.add(field);
    }

    public void fileExists(VisValidableTextField field, FileHandle relativeTo, String errorMsg) {
        field.addValidator(new FileExistsValidator(relativeTo.file(), errorMsg));
        this.add(field);
    }

    public void fileNotExists(VisValidableTextField field, String errorMsg) {
        field.addValidator(new FileExistsValidator(errorMsg, true));
        this.add(field);
    }

    public void fileNotExists(VisValidableTextField field, VisTextField relativeTo, String errorMsg) {
        field.addValidator(new FileExistsValidator(relativeTo, errorMsg, true));
        this.add(field);
    }

    public void fileNotExists(VisValidableTextField field, File relativeTo, String errorMsg) {
        field.addValidator(new FileExistsValidator(relativeTo, errorMsg, true));
        this.add(field);
    }

    public void fileNotExists(VisValidableTextField field, FileHandle relativeTo, String errorMsg) {
        field.addValidator(new FileExistsValidator(relativeTo.file(), errorMsg, true));
        this.add(field);
    }

    public static class FileExistsValidator
    extends FormInputValidator {
        VisTextField relativeTo;
        File relativeToFile;
        boolean existNot;
        boolean errorIfRelativeEmpty;

        public FileExistsValidator(String errorMsg) {
            this(errorMsg, false);
        }

        public FileExistsValidator(VisTextField relativeTo, String errorMsg) {
            this(relativeTo, errorMsg, false);
        }

        public FileExistsValidator(File relativeTo, String errorMsg) {
            this(relativeTo, errorMsg, false);
        }

        public FileExistsValidator(String errorMsg, boolean existNot) {
            super(errorMsg);
            this.existNot = existNot;
        }

        public FileExistsValidator(VisTextField relativeTo, String errorMsg, boolean existNot) {
            super(errorMsg);
            this.relativeTo = relativeTo;
            this.existNot = existNot;
        }

        public FileExistsValidator(File relativeTo, String errorMsg, boolean existNot) {
            super(errorMsg);
            this.relativeToFile = relativeTo;
            this.existNot = existNot;
        }

        public FileExistsValidator(VisTextField relativeTo, String errorMsg, boolean existNot, boolean errorIfRelativeEmpty) {
            super(errorMsg);
            this.relativeTo = relativeTo;
            this.existNot = existNot;
            this.errorIfRelativeEmpty = errorIfRelativeEmpty;
        }

        @Override
        public boolean validate(String input) {
            File file;
            if (this.relativeTo != null) {
                if (this.relativeTo.getText().length() == 0 && !this.errorIfRelativeEmpty) {
                    return true;
                }
                file = new File(this.relativeTo.getText(), input);
            } else {
                file = this.relativeToFile != null ? new File(this.relativeToFile, input) : new File(input);
            }
            if (this.existNot) {
                return !file.exists();
            }
            return file.exists();
        }
    }
}

