/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.dialog;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.kotcrab.vis.ui.InputValidator;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.i18n.BundleText;
import com.kotcrab.vis.ui.util.TableUtils;
import com.kotcrab.vis.ui.util.dialog.ConfirmDialogListener;
import com.kotcrab.vis.ui.util.dialog.InputDialogListener;
import com.kotcrab.vis.ui.util.dialog.OptionDialogListener;
import com.kotcrab.vis.ui.widget.VisDialog;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidableTextField;
import com.kotcrab.vis.ui.widget.VisWindow;

public class DialogUtils {
    private static final int BUTTON_CANCEL = 0;
    private static final int BUTTON_YES = 1;
    private static final int BUTTON_NO = 2;
    private static final int BUTTON_OK = 3;
    private static final int BUTTON_DETAILS = 4;

    public static void showOKDialog(Stage stage, String title, String text) {
        VisDialog dialog = new VisDialog(title);
        dialog.text(text);
        dialog.button(DialogUtils.get(Text.OK)).padBottom(3.0f);
        dialog.pack();
        dialog.centerWindow();
        stage.addActor(dialog.fadeIn());
    }

    public static OptionDialog showOptionDialog(Stage stage, String title, String text, OptionDialogType type, OptionDialogListener listener) {
        OptionDialog dialog = new OptionDialog(title, text, type, listener);
        stage.addActor(dialog.fadeIn());
        return dialog;
    }

    public static <T> ConfirmDialog<T> showConfirmDialog(Stage stage, String title, String text, String[] buttons, T[] returns, ConfirmDialogListener<T> listener) {
        ConfirmDialog<T> dialog = new ConfirmDialog<T>(title, text, buttons, returns, listener);
        stage.addActor(dialog.fadeIn());
        return dialog;
    }

    public static void showInputDialog(Stage stage, String title, String fieldTitle, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, true, null, listener);
        stage.addActor(dialog.fadeIn());
    }

    public static void showInputDialog(Stage stage, String title, String fieldTitle, InputValidator validator, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, true, validator, listener);
        stage.addActor(dialog.fadeIn());
    }

    public static void showInputDialog(Stage stage, String title, String fieldTitle, boolean cancelable, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, cancelable, null, listener);
        stage.addActor(dialog.fadeIn());
    }

    public static void showInputDialog(Stage stage, String title, String fieldTitle, boolean cancelable, InputValidator validator, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, cancelable, validator, listener);
        stage.addActor(dialog.fadeIn());
    }

    public static void showErrorDialog(Stage stage, String text) {
        DialogUtils.showErrorDialog(stage, text, (String)null);
    }

    public static void showErrorDialog(Stage stage, String text, Exception exception) {
        if (exception == null) {
            DialogUtils.showErrorDialog(stage, text, (String)null);
        } else {
            DialogUtils.showErrorDialog(stage, text, DialogUtils.getStackTrace(exception));
        }
    }

    public static void showErrorDialog(Stage stage, String text, String details) {
        ErrorDialog dialog = new ErrorDialog(text, details);
        stage.addActor(dialog.fadeIn());
    }

    private static VisScrollPane createScrollPane(Actor widget) {
        VisScrollPane scrollPane = new VisScrollPane(widget);
        scrollPane.setOverscroll(false, true);
        scrollPane.setFadeScrollBars(false);
        return scrollPane;
    }

    private static String getStackTrace(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        String msg = throwable.getMessage();
        if (msg != null) {
            builder.append(msg);
            builder.append("\n\n");
        }
        for (StackTraceElement element : throwable.getStackTrace()) {
            builder.append(element);
            builder.append("\n");
        }
        return builder.toString();
    }

    private static String get(Text text) {
        return VisUI.getDialogUtilsBundle().get(text.getName());
    }

    private static enum Text implements BundleText
    {
        YES{

            @Override
            public String getName() {
                return "yes";
            }
        }
        ,
        NO{

            @Override
            public String getName() {
                return "no";
            }
        }
        ,
        CANCEL{

            @Override
            public String getName() {
                return "cancel";
            }
        }
        ,
        OK{

            @Override
            public String getName() {
                return "ok";
            }
        }
        ,
        ERROR{

            @Override
            public String getName() {
                return "error";
            }
        }
        ,
        DETAILS{

            @Override
            public String getName() {
                return "details";
            }
        }
        ,
        DETAILS_COLON{

            @Override
            public String getName() {
                return "detailsColon";
            }
        }
        ,
        COPY{

            @Override
            public String getName() {
                return "copy";
            }
        }
        ,
        COPIED{

            @Override
            public String getName() {
                return "copied";
            }
        };


        @Override
        public String get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(Object ... arguments) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ConfirmDialog<T>
    extends VisDialog {
        private ConfirmDialogListener<T> listener;

        public ConfirmDialog(String title, String text, String[] buttons, T[] returns, ConfirmDialogListener<T> listener) {
            super(title);
            this.listener = listener;
            this.text(text);
            for (int i = 0; i < buttons.length; ++i) {
                this.button(buttons[i], returns[i]);
            }
            this.padBottom(3.0f);
            this.pack();
            this.centerWindow();
        }

        @Override
        protected void result(Object object) {
            this.listener.result(object);
        }
    }

    public static class ErrorDialog
    extends VisDialog {
        private VisTable detailsTable = new VisTable(true);
        private Cell<?> detailsCell;

        public ErrorDialog(String text, String stackTrace) {
            super(DialogUtils.get(Text.ERROR));
            this.text(text);
            if (stackTrace != null) {
                final VisTextButton copyButton = new VisTextButton(DialogUtils.get(Text.COPY));
                final VisLabel errorLabel = new VisLabel(stackTrace);
                copyButton.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        Gdx.app.getClipboard().setContents(errorLabel.getText().toString());
                        copyButton.setText(DialogUtils.get(Text.COPIED));
                    }
                });
                this.detailsTable.add(new VisLabel(DialogUtils.get(Text.DETAILS_COLON))).left().expand().padTop(6.0f);
                this.detailsTable.add(copyButton);
                this.detailsTable.row();
                VisTable errorTable = new VisTable();
                errorTable.add(errorLabel).top().expand().fillX();
                this.detailsTable.add(DialogUtils.createScrollPane(errorTable)).colspan(2).width(600.0f).height(300.0f);
                this.getContentTable().row();
                this.detailsCell = this.getContentTable().add(this.detailsTable);
                this.detailsCell.setActor(null);
                this.button(DialogUtils.get(Text.DETAILS), (Object)4);
            }
            this.button(DialogUtils.get(Text.OK), (Object)3).padBottom(3.0f);
            this.pack();
            this.centerWindow();
        }

        @Override
        protected void result(Object object) {
            int result = (Integer)object;
            if (result == 4) {
                this.detailsCell.setActor(this.detailsCell.hasActor() ? null : this.detailsTable);
                this.pack();
                this.centerWindow();
                this.cancel();
            }
        }
    }

    public static class OptionDialog
    extends VisDialog {
        private OptionDialogListener listener;
        private VisTextButton yesButton = new VisTextButton(DialogUtils.access$000(Text.YES));
        private VisTextButton noButton = new VisTextButton(DialogUtils.access$000(Text.NO));
        private VisTextButton cancelButton = new VisTextButton(DialogUtils.access$000(Text.CANCEL));

        public OptionDialog(String title, String text, OptionDialogType type, OptionDialogListener listener) {
            super(title);
            this.listener = listener;
            this.text(text);
            this.defaults().padBottom(3.0f);
            switch (type) {
                case YES_NO: {
                    this.button(this.yesButton, (Object)1);
                    this.button(this.noButton, (Object)2);
                    break;
                }
                case YES_CANCEL: {
                    this.button(this.yesButton, (Object)1);
                    this.button(this.cancelButton, (Object)0);
                    break;
                }
                case YES_NO_CANCEL: {
                    this.button(this.yesButton, (Object)1);
                    this.button(this.noButton, (Object)2);
                    this.button(this.cancelButton, (Object)0);
                }
            }
            this.pack();
            this.centerWindow();
        }

        @Override
        protected void result(Object object) {
            int result = (Integer)object;
            if (result == 1) {
                this.listener.yes();
            }
            if (result == 2) {
                this.listener.no();
            }
            if (result == 0) {
                this.listener.cancel();
            }
        }

        public void setNoButtonText(String text) {
            this.noButton.setText(text);
        }

        public void setYesButtonText(String text) {
            this.yesButton.setText(text);
        }

        public void setCancelButtonText(String text) {
            this.cancelButton.setText(text);
        }
    }

    public static class InputDialog
    extends VisWindow {
        private InputDialogListener listener;
        private VisTextField field;
        private VisTextButton okButton;
        private VisTextButton cancelButton;

        public InputDialog(String title, String fieldTitle, boolean cancelable, InputValidator validator, InputDialogListener listener) {
            super(title);
            this.listener = listener;
            TableUtils.setSpacingDefaults(this);
            this.setModal(true);
            if (cancelable) {
                this.addCloseButton();
                this.closeOnEscape();
            }
            VisTable buttonsTable = new VisTable(true);
            this.cancelButton = new VisTextButton(DialogUtils.get(Text.CANCEL));
            buttonsTable.add(this.cancelButton);
            this.okButton = new VisTextButton(DialogUtils.get(Text.OK));
            buttonsTable.add(this.okButton);
            VisTable fieldTable = new VisTable(true);
            this.field = validator == null ? new VisTextField() : new VisValidableTextField(validator);
            if (fieldTitle != null) {
                fieldTable.add(new VisLabel(fieldTitle));
            }
            fieldTable.add(this.field).expand().fill();
            this.add(fieldTable).padTop(3.0f).spaceBottom(4.0f);
            this.row();
            this.add(buttonsTable).padBottom(3.0f);
            this.addListeners();
            if (validator != null) {
                this.addValidableFieldListener(this.field);
                this.okButton.setDisabled(!this.field.isInputValid());
            }
            this.pack();
            this.centerWindow();
            this.field.focusField();
        }

        @Override
        protected void close() {
            super.close();
            this.listener.canceled();
        }

        private void addValidableFieldListener(final VisTextField field) {
            field.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (field.isInputValid()) {
                        InputDialog.this.okButton.setDisabled(false);
                    } else {
                        InputDialog.this.okButton.setDisabled(true);
                    }
                }
            });
        }

        private void addListeners() {
            this.okButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    InputDialog.this.listener.finished(InputDialog.this.field.getText());
                    InputDialog.this.fadeOut();
                }
            });
            this.cancelButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    InputDialog.this.close();
                }
            });
            this.field.addListener(new InputListener(){

                @Override
                public boolean keyDown(InputEvent event, int keycode) {
                    if (keycode == 66 && !InputDialog.this.okButton.isDisabled()) {
                        InputDialog.this.listener.finished(InputDialog.this.field.getText());
                        InputDialog.this.fadeOut();
                    }
                    return super.keyDown(event, keycode);
                }
            });
        }
    }

    public static enum OptionDialogType {
        YES_NO,
        YES_NO_CANCEL,
        YES_CANCEL;

    }
}

