/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;

public class ColorUtils {
    public static Color HSVtoRGB(float h, float s, float v, float alpha) {
        Color c = ColorUtils.HSVtoRGB(h, s, v);
        c.a = alpha;
        return c;
    }

    public static Color HSVtoRGB(float h, float s, float v) {
        Color c = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        ColorUtils.HSVtoRGB(h, s, v, c);
        return c;
    }

    public static Color HSVtoRGB(float h, float s, float v, Color targetColor) {
        int b;
        int g;
        int r;
        if (h == 360.0f) {
            h = 359.0f;
        }
        h = (float)Math.max(0.0, Math.min(360.0, (double)h));
        s = (float)Math.max(0.0, Math.min(100.0, (double)s));
        v = (float)Math.max(0.0, Math.min(100.0, (double)v));
        int i = MathUtils.floor(h /= 60.0f);
        float f = h - (float)i;
        float p = (v /= 100.0f) * (1.0f - (s /= 100.0f));
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                r = MathUtils.round(255.0f * v);
                g = MathUtils.round(255.0f * t);
                b = MathUtils.round(255.0f * p);
                break;
            }
            case 1: {
                r = MathUtils.round(255.0f * q);
                g = MathUtils.round(255.0f * v);
                b = MathUtils.round(255.0f * p);
                break;
            }
            case 2: {
                r = MathUtils.round(255.0f * p);
                g = MathUtils.round(255.0f * v);
                b = MathUtils.round(255.0f * t);
                break;
            }
            case 3: {
                r = MathUtils.round(255.0f * p);
                g = MathUtils.round(255.0f * q);
                b = MathUtils.round(255.0f * v);
                break;
            }
            case 4: {
                r = MathUtils.round(255.0f * t);
                g = MathUtils.round(255.0f * p);
                b = MathUtils.round(255.0f * v);
                break;
            }
            default: {
                r = MathUtils.round(255.0f * v);
                g = MathUtils.round(255.0f * p);
                b = MathUtils.round(255.0f * q);
            }
        }
        targetColor.set((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, targetColor.a);
        return targetColor;
    }

    public static int[] RGBtoHSV(Color c) {
        return ColorUtils.RGBtoHSV(c.r, c.g, c.b);
    }

    public static int[] RGBtoHSV(float r, float g, float b) {
        float max;
        float min = Math.min(Math.min(r, g), b);
        float v = max = Math.max(Math.max(r, g), b);
        float delta = max - min;
        if (max == 0.0f) {
            float s = 0.0f;
            float h = 0.0f;
            return new int[]{MathUtils.round(h), MathUtils.round(s), MathUtils.round(v)};
        }
        float s = delta / max;
        float h = delta == 0.0f ? 0.0f : (r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta));
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        return new int[]{MathUtils.round(h), MathUtils.round(s *= 100.0f), MathUtils.round(v *= 100.0f)};
    }
}

