/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.layout;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.SnapshotArray;

public class GridGroup
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private float lastPrefHeight;
    private boolean sizeInvalid = true;
    private int itemSize = 256;
    private float spacing = 8.0f;

    public GridGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    public GridGroup(int itemSize) {
        this.itemSize = itemSize;
        this.setTouchable(Touchable.childrenOnly);
    }

    public GridGroup(float spacing) {
        this.spacing = spacing;
        this.setTouchable(Touchable.childrenOnly);
    }

    public GridGroup(int itemSize, float spacing) {
        this.spacing = spacing;
        this.itemSize = itemSize;
        this.setTouchable(Touchable.childrenOnly);
    }

    private void computeSize() {
        this.prefWidth = this.getWidth();
        this.prefHeight = 0.0f;
        this.sizeInvalid = false;
        if (this.getChildren().size == 0) {
            this.prefWidth = 0.0f;
            this.prefHeight = 0.0f;
            return;
        }
        float width = this.getWidth();
        float maxHeight = 0.0f;
        float tempX = this.spacing;
        int n = this.getChildren().size;
        for (int i = 0; i < n; ++i) {
            if (tempX + (float)this.itemSize + this.spacing >= width) {
                tempX = this.spacing;
                maxHeight += (float)this.itemSize + this.spacing;
            }
            tempX += (float)this.itemSize - this.spacing;
        }
        maxHeight = (float)this.itemSize + this.spacing * 2.0f >= this.prefWidth ? (maxHeight += this.spacing) : (maxHeight += (float)this.itemSize + this.spacing * 2.0f);
        this.prefHeight = maxHeight;
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
            if (this.lastPrefHeight != this.prefHeight) {
                this.lastPrefHeight = this.prefHeight;
                this.invalidateHierarchy();
            }
        }
        SnapshotArray<Actor> children = this.getChildren();
        float width = this.getWidth();
        boolean notEnoughSpace = (float)this.itemSize + this.spacing * 2.0f > width;
        float x = this.spacing;
        float y = notEnoughSpace ? this.getHeight() : this.getHeight() - (float)this.itemSize - this.spacing;
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            Actor child = (Actor)children.get(i);
            if (x + (float)this.itemSize + this.spacing > width) {
                x = this.spacing;
                y -= (float)this.itemSize + this.spacing;
            }
            child.setBounds(x, y, this.itemSize, this.itemSize);
            x += (float)this.itemSize + this.spacing;
        }
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
        this.invalidateHierarchy();
    }

    public int getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(int itemSize) {
        this.itemSize = itemSize;
        this.invalidateHierarchy();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }
}

