/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.building;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.kotcrab.vis.ui.building.TableBuilder;
import com.kotcrab.vis.ui.building.utilities.CellWidget;
import com.kotcrab.vis.ui.building.utilities.Padding;

public class GridTableBuilder
extends TableBuilder {
    private final int rowSize;

    public GridTableBuilder(int rowSize) {
        this.rowSize = rowSize;
    }

    public GridTableBuilder(Padding defaultWidgetPadding, int rowSize) {
        super(defaultWidgetPadding);
        this.rowSize = rowSize;
    }

    public GridTableBuilder(int rowSize, int estimatedWidgetsAmount, int estimatedRowsAmount) {
        super(estimatedWidgetsAmount, estimatedRowsAmount);
        this.rowSize = rowSize;
    }

    public GridTableBuilder(int rowSize, int estimatedWidgetsAmount, int estimatedRowsAmount, Padding defaultWidgetPadding) {
        super(estimatedWidgetsAmount, estimatedRowsAmount, defaultWidgetPadding);
        this.rowSize = rowSize;
    }

    @Override
    protected void fillTable(Table table) {
        int widgetsCounter = 0;
        for (CellWidget<? extends Actor> widget : this.getWidgets()) {
            widget.buildCell(table, this.getDefaultWidgetPadding());
            if (++widgetsCounter != this.rowSize) continue;
            widgetsCounter -= this.rowSize;
            table.row();
        }
    }
}

