/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.I18NBundle;
import java.util.Locale;

public class VisUI {
    public static final String VERSION = "0.7.7";
    private static int defaultTitleAlign = 8;
    private static Skin skin;
    private static I18NBundle fileChooserBundle;
    private static I18NBundle dialogUtilsBundle;
    private static I18NBundle tabbedPaneBundle;
    private static I18NBundle colorPickerBundle;
    private static int defaultSpacingTop;
    private static int defaultSpacingBottom;
    private static int defaultSpacingRight;
    private static int defaultSpacingLeft;

    public static void load() {
        VisUI.load(Gdx.files.classpath("com/kotcrab/vis/ui/uiskin.json"));
    }

    public static void load(FileHandle visSkinFile) {
        skin = new Skin(visSkinFile);
    }

    public static void load(Skin skin) {
        VisUI.skin = skin;
    }

    public static void dispose() {
        if (skin != null) {
            skin.dispose();
            skin = null;
        }
    }

    public static Skin getSkin() {
        if (skin == null) {
            throw new IllegalStateException("VisUI not loaded!");
        }
        return skin;
    }

    public static int getDefaultTitleAlign() {
        return defaultTitleAlign;
    }

    public static void setDefaultTitleAlign(int defaultTitleAlign) {
        VisUI.defaultTitleAlign = defaultTitleAlign;
    }

    public static I18NBundle getFileChooserBundle() {
        if (fileChooserBundle == null) {
            FileHandle file = Gdx.files.classpath("com/kotcrab/vis/ui/i18n/FileChooser");
            fileChooserBundle = I18NBundle.createBundle(file, new Locale("en"));
        }
        return fileChooserBundle;
    }

    public static void setFileChooserBundle(I18NBundle fileChooserBundle) {
        VisUI.fileChooserBundle = fileChooserBundle;
    }

    public static I18NBundle getDialogUtilsBundle() {
        if (dialogUtilsBundle == null) {
            FileHandle file = Gdx.files.classpath("com/kotcrab/vis/ui/i18n/DialogUtils");
            dialogUtilsBundle = I18NBundle.createBundle(file, new Locale("en"));
        }
        return dialogUtilsBundle;
    }

    public static void setDialogUtilsBundle(I18NBundle dialogUtilsBundle) {
        VisUI.dialogUtilsBundle = dialogUtilsBundle;
    }

    public static I18NBundle getTabbedPaneBundle() {
        if (tabbedPaneBundle == null) {
            FileHandle file = Gdx.files.classpath("com/kotcrab/vis/ui/i18n/TabbedPane");
            tabbedPaneBundle = I18NBundle.createBundle(file, new Locale("en"));
        }
        return tabbedPaneBundle;
    }

    public static void setTabbedPaneBundle(I18NBundle tabbedPaneBundle) {
        VisUI.tabbedPaneBundle = tabbedPaneBundle;
    }

    public static I18NBundle getColorPickerBundle() {
        if (colorPickerBundle == null) {
            FileHandle file = Gdx.files.classpath("com/kotcrab/vis/ui/i18n/ColorPicker");
            colorPickerBundle = I18NBundle.createBundle(file, new Locale("en"));
        }
        return colorPickerBundle;
    }

    public static void setColorPickerBundle(I18NBundle colorPickerBundle) {
        VisUI.colorPickerBundle = colorPickerBundle;
    }

    public static int getDefaultSpacingTop() {
        return defaultSpacingTop;
    }

    public static void setDefaultSpacingTop(int defaultSpacingTop) {
        VisUI.defaultSpacingTop = defaultSpacingTop;
    }

    public static int getDefaultSpacingBottom() {
        return defaultSpacingBottom;
    }

    public static void setDefaultSpacingBottom(int defaultSpacingBottom) {
        VisUI.defaultSpacingBottom = defaultSpacingBottom;
    }

    public static int getDefaultSpacingRight() {
        return defaultSpacingRight;
    }

    public static void setDefaultSpacingRight(int defaultSpacingRight) {
        VisUI.defaultSpacingRight = defaultSpacingRight;
    }

    public static int getDefaultSpacingLeft() {
        return defaultSpacingLeft;
    }

    public static void setDefaultSpacingLeft(int defaultSpacingLeft) {
        VisUI.defaultSpacingLeft = defaultSpacingLeft;
    }

    static {
        defaultSpacingTop = 0;
        defaultSpacingBottom = 8;
        defaultSpacingRight = 6;
        defaultSpacingLeft = 0;
    }
}

