/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FrameBufferCubemap
extends GLFrameBuffer<Cubemap> {
    private int currentSide;

    public FrameBufferCubemap(Pixmap.Format format, int width, int height, boolean hasDepth) {
        this(format, width, height, hasDepth, false);
    }

    public FrameBufferCubemap(Pixmap.Format format, int width, int height, boolean hasDepth, boolean hasStencil) {
        super(format, width, height, hasDepth, hasStencil);
    }

    @Override
    protected void setupTexture() {
        this.colorTexture = new Cubemap(this.width, this.height, this.width, this.format);
        ((Cubemap)this.colorTexture).setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        ((Cubemap)this.colorTexture).setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
    }

    @Override
    public void bind() {
        this.currentSide = -1;
        super.bind();
    }

    public boolean nextSide() {
        if (this.currentSide > 5) {
            throw new GdxRuntimeException("No remaining sides.");
        }
        if (this.currentSide == 5) {
            return false;
        }
        ++this.currentSide;
        this.bindSide(this.getSide());
        return true;
    }

    protected void bindSide(Cubemap.CubemapSide side) {
        Gdx.gl20.glFramebufferTexture2D(36160, 36064, side.glEnum, ((Cubemap)this.colorTexture).getTextureObjectHandle(), 0);
    }

    public Cubemap.CubemapSide getSide() {
        return this.currentSide < 0 ? null : Cubemap.CubemapSide.values()[this.currentSide];
    }
}

