/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.transform;

import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.SharedLibraryLoader;

public class SoundTouch
implements Disposable {
    public static int SETTING_USE_AA_FILTER = 0;
    public static int SETTING_AA_FILTER_LENGTH = 1;
    public static int SETTING_USE_QUICKSEEK = 2;
    public static int SETTING_SEQUENCE_MS = 3;
    public static int SETTING_SEEKWINDOW_MS = 4;
    public static int SETTING_OVERLAP_MS = 5;
    public static int SETTING_NOMINAL_INPUT_SEQUENCE = 6;
    public static int SETTING_NOMINAL_OUTPUT_SEQUENCE = 7;
    private final long addr;

    public SoundTouch() {
        new SharedLibraryLoader().load("gdx-audio");
        this.addr = this.newSoundTouchJni();
    }

    private native long newSoundTouchJni();

    @Override
    public void dispose() {
        this.disposeJni(this.addr);
    }

    private native void disposeJni(long var1);

    public void setRate(float newRate) {
        this.setRateJni(this.addr, newRate);
    }

    private native void setRateJni(long var1, float var3);

    public void setTempo(float newTempo) {
        this.setTempoJni(this.addr, newTempo);
    }

    private native void setTempoJni(long var1, float var3);

    public void setRateChange(float newRate) {
        this.setRateChangeJni(this.addr, newRate);
    }

    private native void setRateChangeJni(long var1, float var3);

    public void setTempoChange(float newTempo) {
        this.setTempoJni(this.addr, newTempo);
    }

    private native void setTempoChange(long var1, float var3);

    public void setPitch(float newPitch) {
        this.setPitchJni(this.addr, newPitch);
    }

    private native void setPitchJni(long var1, float var3);

    public void setPitchOctaves(float newPitch) {
        this.setPitchOctavesJni(this.addr, newPitch);
    }

    private native void setPitchOctavesJni(long var1, float var3);

    public void setPitchSemiTones(int newPitch) {
        this.setPitchSemiTonesJni(this.addr, newPitch);
    }

    private native void setPitchSemiTonesJni(long var1, int var3);

    public void setPitchSemiTones(float newPitch) {
        this.setPitchSemiTonesJni(this.addr, newPitch);
    }

    private native void setPitchSemiTonesJni(long var1, float var3);

    public void setChannels(int numChannels) {
        this.setChannelsJni(this.addr, numChannels);
    }

    private native void setChannelsJni(long var1, int var3);

    public void setSampleRate(int srate) {
        this.setSampleRateJni(this.addr, srate);
    }

    private native void setSampleRateJni(long var1, int var3);

    public void flush() {
        this.flushJni(this.addr);
    }

    private native void flushJni(long var1);

    public void putSamples(short[] samples, int offset, int numSamples) {
        this.putSamplesJni(this.addr, samples, offset, numSamples);
    }

    private native void putSamplesJni(long var1, short[] var3, int var4, int var5);

    public void clear() {
        this.clearJni(this.addr);
    }

    private native void clearJni(long var1);

    public boolean setSetting(int settingId, int value) {
        return this.setSettingJni(this.addr, settingId, value);
    }

    private native boolean setSettingJni(long var1, int var3, int var4);

    public int getSetting(int settingId) {
        return this.getSettingJni(this.addr, settingId);
    }

    private native int getSettingJni(long var1, int var3);

    public int numUnprocessedSamples() {
        return this.numUnprocessedSamplesJni(this.addr);
    }

    private native int numUnprocessedSamplesJni(long var1);

    public int numSamples() {
        return this.numSamplesJni(this.addr);
    }

    private native int numSamplesJni(long var1);

    public int receiveSamples(short[] samples, int offset, int maxSamples) {
        return this.receiveSamplesJni(this.addr, samples, offset, maxSamples);
    }

    private native int receiveSamplesJni(long var1, short[] var3, int var4, int var5);

    public static void main(String[] args) {
        SoundTouch soundTouch = new SoundTouch();
        soundTouch.setSampleRate(44100);
        soundTouch.setChannels(1);
        soundTouch.putSamples(new short[10240], 0, 10240);
        System.out.println(soundTouch.numSamples());
        soundTouch.dispose();
    }
}

