/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import data.FontManager;
import data.GSB;
import data.ScreenManager;
import game.Map;
import game.Player;
import screens.FinalView;

public class GameView
implements Screen {
    Player player = new Player();
    int goal;
    int score = 0;
    long initial;

    public GameView() {
        GSB.init();
        do {
            Map.init();
        } while (!Map.isConnexe());
        this.goal = Map.random.nextInt(30);
        FontManager.get(20).setColor(0.46666667f, 0.43137255f, 0.39607844f, 1.0f);
        FontManager.get(20, 1).setColor(Color.BLUE);
        this.initial = System.currentTimeMillis();
    }

    public void render(float delta) {
        Gdx.gl.glClearColor(0.73333335f, 0.6784314f, 0.627451f, 1.0f);
        Gdx.gl.glClear(16384);
        int seconds = (int)((System.currentTimeMillis() - this.initial) / 1000L);
        GSB.sb.begin();
        Map.render();
        this.player.render();
        FontManager.get(20).draw((Batch)GSB.sb, (CharSequence)("But : " + this.goal), 229.0f, 578.0f);
        FontManager.get(20).draw((Batch)GSB.sb, (CharSequence)("Temps : " + seconds + " s"), 40.0f, 578.0f);
        FontManager.get(20).draw((Batch)GSB.sb, (CharSequence)("Restant" + (this.score == 9 ? "" : "s") + " : " + (10 - this.score)), 358.0f, 578.0f);
        GSB.sb.end();
        this.player.update(delta);
        if (this.player.numerator == this.goal && this.player.denominator == 1) {
            this.goal = Map.random.nextInt(28) + 2;
            this.player.numerator = 1;
            ++this.score;
            do {
                Map.init();
            } while (!Map.isConnexe());
            if (this.score == 10) {
                FinalView.setTemps(this.initial);
                ScreenManager.setScreen("final");
            }
        }
    }

    public void resize(int width, int height) {
        GSB.resize(width, height);
        GSB.camera.position.x = 279.0f;
        GSB.camera.position.y = 279.0f;
        GSB.update();
    }

    public void show() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void hide() {
    }

    public void dispose() {
    }
}

