/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import data.FontManager;
import data.GSB;
import data.TextureManager;
import game.Map;
import tiles.OperationTile;

public class Player {
    public int numerator = 1;
    public int denominator = 1;
    public int x = 0;
    public int y = 0;
    public int nextX = 0;
    public int nextY = 0;
    public int averageX = 0;
    public int averageY = 0;
    boolean inAnimation = false;
    boolean changedDone = false;
    float animationTime = 0.2f;
    float animationProgression = 0.0f;
    int[] toChange;
    BitmapFont bigFont;
    BitmapFont smallFont = FontManager.getInstance(12);
    BitmapFont useFont;

    public Player() {
        this.smallFont.setColor(Color.RED);
        this.bigFont = FontManager.getInstance(17);
        this.bigFont.setColor(Color.RED);
        this.useFont = this.bigFont;
    }

    private void goTo(int gotox, int gotoy) {
        this.nextX = gotox;
        this.nextY = gotoy;
        this.averageX = (gotox + this.x) / 2;
        this.averageY = (gotoy + this.y) / 2;
        this.toChange = ((OperationTile)Map.tiles[this.averageY][this.averageX]).newValues(this.numerator, this.denominator);
        this.inAnimation = true;
    }

    private void doTheChanges() {
        ((OperationTile)Map.tiles[this.averageY][this.averageX]).inverseOperation();
        this.numerator = this.toChange[0];
        this.denominator = this.toChange[1];
        this.simplify();
        this.changedDone = true;
        this.useFont = this.denominator == 1 ? this.bigFont : this.smallFont;
    }

    public void update(float delta) {
        if (this.inAnimation) {
            this.animationProgression += delta / this.animationTime;
            if (this.animationProgression > 0.5f && !this.changedDone) {
                this.doTheChanges();
            }
            if (this.animationProgression >= 1.0f) {
                this.inAnimation = false;
                this.changedDone = false;
                this.animationProgression = 0.0f;
                this.x = this.nextX;
                this.y = this.nextY;
            }
        }
        if (!this.inAnimation) {
            if (Gdx.input.isKeyPressed(21) && this.x != 0 && !Map.isBlocked(this.x - 2, this.y) && !Map.isBlocked(this.x - 1, this.y)) {
                this.goTo(this.x - 2, this.y);
            }
            if (Gdx.input.isKeyPressed(22) && this.x < 7 && !Map.isBlocked(this.x + 2, this.y) && !Map.isBlocked(this.x + 1, this.y)) {
                this.goTo(this.x + 2, this.y);
            }
            if (Gdx.input.isKeyPressed(19) && this.y < 7 && !Map.isBlocked(this.x, this.y + 2) && !Map.isBlocked(this.x, this.y + 1)) {
                this.goTo(this.x, this.y + 2);
            }
            if (Gdx.input.isKeyPressed(20) && this.y != 0 && !Map.isBlocked(this.x, this.y - 2) && !Map.isBlocked(this.x, this.y - 1)) {
                this.goTo(this.x, this.y - 2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void simplify() {
        v0 = sign = this.numerator < 0;
        if (sign) {
            this.numerator *= -1;
        }
        a = Math.max(this.denominator, this.numerator);
        b = Math.min(this.numerator, this.denominator);
        if (b != 1) ** GOTO lbl13
        if (sign) {
            this.numerator *= -1;
        }
        return;
lbl-1000:
        // 1 sources

        {
            tmp = a %= b;
            a = b;
            b = tmp;
lbl13:
            // 2 sources

            ** while (b != 0)
        }
lbl14:
        // 1 sources

        this.numerator /= a;
        this.denominator /= a;
        if (sign) {
            this.numerator *= -1;
        }
    }

    public void render() {
        float renderX = this.x * 54 + 27 + 8 * this.x;
        float renderY = this.y * 54 + 27 + (this.useFont == this.bigFont ? 5 : 3) + 8 * this.y;
        float offsetY = 0.0f;
        float offsetX = 0.0f;
        if (this.inAnimation) {
            offsetX = this.animationProgression * (float)(this.nextX - this.x) * 62.0f;
            offsetY = this.animationProgression * (float)(this.nextY - this.y) * 62.0f;
        }
        if (this.denominator == 1) {
            GSB.sb.draw(TextureManager.get("player64.png"), (float)(this.x * 62) + offsetX, (float)(this.y * 62) + offsetY);
            this.bigFont.draw((Batch)GSB.sb, (CharSequence)("" + this.numerator), renderX + offsetX, renderY + offsetY, 0.0f, 1, false);
        } else {
            GSB.sb.draw(TextureManager.get("player642.png"), (float)(this.x * 62) + offsetX, (float)(this.y * 62) + offsetY);
            this.bigFont.draw((Batch)GSB.sb, (CharSequence)("" + this.numerator), renderX + offsetX, renderY + offsetY + 15.0f, 0.0f, 1, false);
            this.bigFont.draw((Batch)GSB.sb, (CharSequence)("" + this.denominator), renderX + offsetX, renderY + offsetY - 12.0f, 0.0f, 1, false);
        }
    }
}

