/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Constants;
import java.util.Random;
import tiles.BlockTile;
import tiles.EmptyTile;
import tiles.OperationTile;
import tiles.Tile;

public class Map {
    public static final int width = 9;
    public static final int height = 9;
    public static Tile[][] tiles = new Tile[9][9];
    public static Random random = new Random(Constants.seed);

    public static void init() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                Tile tile;
                boolean oddy;
                boolean oddx = j % 2 == 1;
                boolean bl = oddy = i % 2 == 1;
                if (oddx && oddy) {
                    tile = new BlockTile();
                } else if (!oddx && !oddy) {
                    tile = new EmptyTile();
                } else if ((double)random.nextFloat() > 0.2) {
                    char[] opers = new char[]{'+', '-', '+', '-', '/', 'x'};
                    char oper = opers[random.nextInt(6)];
                    int number = random.nextInt(5) + 1;
                    if (oper == '/' || oper == 'x') {
                        ++number;
                    }
                    tile = new OperationTile(String.valueOf(oper) + number);
                } else {
                    tile = new BlockTile();
                }
                tile.y = i;
                tile.x = j;
                Map.tiles[i][j] = tile;
                ++j;
            }
            ++i;
        }
    }

    public static boolean isConnexe() {
        int j;
        int[][] connexeTest = new int[5][5];
        int i = 0;
        while (i < connexeTest.length) {
            j = 0;
            while (j < connexeTest[i].length) {
                connexeTest[i][j] = 0;
                if (i == 0 && j == 0) {
                    connexeTest[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < connexeTest.length * connexeTest[0].length + 3) {
            boolean breakOrNot = true;
            int i2 = 0;
            while (i2 < connexeTest.length) {
                int j2 = 0;
                while (j2 < connexeTest[i2].length) {
                    if (connexeTest[i2][j2] == 1) {
                        boolean up;
                        boolean down = i2 > 0;
                        boolean left = j2 > 0;
                        boolean right = j2 < connexeTest[0].length - 1;
                        boolean bl = up = i2 < connexeTest.length - 1;
                        if (down && !Map.isBlocked(j2 * 2, i2 * 2 - 1) && connexeTest[i2 - 1][j2] == 0) {
                            connexeTest[i2 - 1][j2] = 1;
                            breakOrNot = false;
                        }
                        if (up && !Map.isBlocked(j2 * 2, i2 * 2 + 1) && connexeTest[i2 + 1][j2] == 0) {
                            connexeTest[i2 + 1][j2] = 1;
                            breakOrNot = false;
                        }
                        if (left && !Map.isBlocked(j2 * 2 - 1, i2 * 2) && connexeTest[i2][j2 - 1] == 0) {
                            connexeTest[i2][j2 - 1] = 1;
                            breakOrNot = false;
                        }
                        if (right && !Map.isBlocked(j2 * 2 + 1, i2 * 2) && connexeTest[i2][j2 + 1] == 0) {
                            connexeTest[i2][j2 + 1] = 1;
                            breakOrNot = false;
                        }
                        connexeTest[i2][j2] = 2;
                    }
                    ++j2;
                }
                ++i2;
            }
            if (breakOrNot) break;
            ++k;
        }
        i = 0;
        while (i < connexeTest.length) {
            j = 0;
            while (j < connexeTest[i].length) {
                if (connexeTest[i][j] == 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBlocked(int x, int y) {
        return Map.tiles[y][x].block;
    }

    public static void render() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                tiles[i][j].render();
                ++j;
            }
            ++i;
        }
    }
}

