/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;

public class GSB {
    public static SpriteBatch sb;
    public static SpriteBatch hud;
    public static ShapeRenderer srCam;
    public static ShapeRenderer srHud;
    public static OrthographicCamera camera;
    static float currAngle;

    static {
        currAngle = 0.0f;
    }

    public static void init() {
        camera = new OrthographicCamera();
        camera.setToOrtho(false, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        sb = new SpriteBatch();
        sb.setProjectionMatrix(GSB.camera.combined);
        hud = new SpriteBatch();
        hud.setProjectionMatrix(GSB.camera.combined);
        srCam = new ShapeRenderer();
        srCam.setProjectionMatrix(GSB.camera.combined);
        srHud = new ShapeRenderer();
        GSB.camera.position.x = GSB.camera.viewportWidth / 2.0f;
        GSB.camera.position.y = GSB.camera.viewportHeight / 2.0f;
        GSB.update();
    }

    public static void update() {
        camera.update();
        sb.setProjectionMatrix(GSB.camera.combined);
        srCam.setProjectionMatrix(GSB.camera.combined);
    }

    public static void setAngle(float angle) {
        camera.rotate(angle - currAngle);
        currAngle = angle;
        camera.update();
    }

    public static Rectangle getScreenBox() {
        Rectangle screen = new Rectangle();
        float width = GSB.camera.viewportWidth * GSB.camera.zoom;
        float height = GSB.camera.viewportHeight * GSB.camera.zoom;
        screen.x = GSB.camera.position.x - width / 2.0f;
        screen.y = GSB.camera.position.y - height / 2.0f;
        screen.width = width;
        screen.height = height;
        return screen;
    }

    public static void resize(int width, int height) {
        if (camera == null) {
            GSB.init();
        }
        Vector3 position = new Vector3(GSB.camera.position);
        float zoom = GSB.camera.zoom;
        GSB.init();
        GSB.camera.position.x = position.x;
        GSB.camera.position.y = position.y;
        GSB.camera.zoom = zoom;
        GSB.update();
    }
}

