/*
 * Decompiled with CFR 0.152.
 */
package net.Uriopass.TPE;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import net.Uriopass.TPE.MyFont;
import net.Uriopass.TPE.QuestionConfig;

public class QuestionAnswer {
    MyFont bigFont;
    MyFont font;
    Sprite reponseSprite;
    String reponse;
    String answered = "";
    String reponseQuestion;
    Sprite image1 = null;
    Sprite image2 = null;
    String explication;
    boolean inTransition = false;
    int opacity;
    int transitionSpeed = 3;
    boolean wayOfTransition;

    public QuestionAnswer(QuestionConfig c) {
        this.explication = c.explication;
        if (c.image1) {
            this.image1 = new Sprite(new Texture(c.pathImage1));
            this.image1.flip(false, true);
            this.image1.setPosition(c.image1x, c.image1y);
        }
        if (c.image2) {
            this.image2 = new Sprite(new Texture(c.pathImage2));
            this.image2.flip(false, true);
            this.image2.setPosition(c.image2x, c.image2y);
        }
        this.font = new MyFont("Calibri.ttf");
        this.font.setSize(20);
        this.bigFont = new MyFont("Calibri Bold.ttf");
        this.bigFont.setSize(30);
        this.reponse = c.reponse;
        if (c.reponse == "A") {
            this.reponseQuestion = c.reponseA;
        }
        if (c.reponse == "B") {
            this.reponseQuestion = c.reponseB;
        }
        if (c.reponse == "C") {
            this.reponseQuestion = c.reponseC;
        }
        if (c.reponse == "D") {
            this.reponseQuestion = c.reponseD;
        }
        this.reponseSprite = new Sprite(new Texture("scores.png"));
        this.reponseSprite.flip(false, true);
        this.reponseSprite.setCenterX(600.0f);
        this.reponseSprite.setY(0.0f);
    }

    public void setAnswered(String answered) {
        this.answered = answered;
    }

    public void update() {
        if (this.inTransition) {
            if (this.wayOfTransition) {
                this.opacity += this.transitionSpeed;
                if (this.opacity > 100) {
                    this.opacity = 100;
                    this.inTransition = false;
                }
            } else {
                this.opacity -= this.transitionSpeed;
                if (this.opacity < 0) {
                    this.opacity = 0;
                    this.inTransition = false;
                }
            }
        }
    }

    public void initTransition(boolean appear) {
        this.wayOfTransition = appear;
        this.inTransition = true;
    }

    public void drawExplanation(SpriteBatch sb) {
        this.font.getFont().drawWrapped(sb, this.explication, 300.0f, 100.0f, 500.0f);
    }

    public void draw(SpriteBatch sb) {
        if (this.inTransition) {
            Color c = this.bigFont.currentFont.getColor();
            c.set(c.r, c.g, c.b, (float)this.opacity / 100.0f);
            this.bigFont.setColor(c);
            this.font.setColor(c);
        }
        if (this.image1 != null) {
            this.image1.draw(sb, (float)this.opacity / 100.0f);
        }
        if (this.image2 != null) {
            this.image2.draw(sb, (float)this.opacity / 100.0f);
        }
        this.reponseSprite.draw(sb, (float)this.opacity / 100.0f);
        this.bigFont.write("R\u00e9ponse : " + this.reponseQuestion, sb, (int)(600.0f - this.bigFont.getFont().getBounds((CharSequence)new StringBuilder((String)"R\u00e9ponse : ").append((String)this.reponseQuestion).toString()).width / 2.0f), 10);
        this.drawExplanation(sb);
    }
}

