/*
 * Decompiled with CFR 0.152.
 */
package net.Uriopass.TPE;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import net.Uriopass.TPE.MyFont;

public class Button {
    MyFont font = new MyFont("Calibri.ttf");
    String text;
    ButtonType type;
    Sprite image;
    Vector2 originalPosition;
    Vector2 position;
    int fontHeight;
    int fontWidth;
    boolean inTransition = false;
    int transitionState = 0;
    float transitionSpeed = 5.0f;
    ButtonType oldType;
    Sprite oldImage;
    boolean checkClick = true;
    Sprite mask;
    ShapeRenderer debug;
    boolean centerFont = false;
    int lastScroll = 0;

    public Button(String str, ButtonType type, Vector2 position) {
        this.font.setSize(20);
        this.type = type;
        this.originalPosition = position;
        this.position = position;
        this.text = str;
        this.image = this.getImageFromType(type);
        this.mask = new Sprite(new TextureRegion(new Texture(Gdx.files.internal("blanc.png")), (int)this.image.getWidth(), 50));
        this.mask.setAlpha(0.1f);
        this.fontWidth = (int)this.font.getFont().getBounds((CharSequence)str).width;
        this.fontHeight = (int)((this.image.getHeight() - this.font.getFont().getCapHeight()) / 2.0f);
        this.debug = new ShapeRenderer();
    }

    private Sprite getImageFromType(ButtonType type) {
        String path;
        Sprite i = null;
        switch (type) {
            case QUESTION: {
                path = "questionButton.png";
                break;
            }
            case BIG: {
                path = "scores.png";
                break;
            }
            case REPONSE: {
                path = "reponseButton.png";
                break;
            }
            case REPONSE_VALIDE: {
                path = "valideButton.png";
                break;
            }
            case REPONSE_INCONNU: {
                path = "inconnuButton.png";
                break;
            }
            case REPONSE_INVALIDE: {
                path = "invalideButton.png";
                break;
            }
            case CONFIRMER: {
                path = "confirmerButton.png";
                break;
            }
            case INVISIBLE: {
                path = "invisibleButton.png";
                break;
            }
            case COTE: {
                path = "sideButton.png";
                break;
            }
            case COTE_INDISPONIBLE: {
                path = "unavailable_sideButton.png";
                break;
            }
            case ACCEUIL_COTE: {
                path = "acceuil_sideButton.png";
                break;
            }
            default: {
                path = "";
            }
        }
        i = new Sprite(new Texture(Gdx.files.internal(path)));
        i.flip(false, true);
        i.setPosition(this.position.x, this.position.y);
        return i;
    }

    public void setCheckClick(boolean checkClick) {
        this.checkClick = checkClick;
    }

    public void setCenterizeFont(boolean centerFont) {
        this.centerFont = centerFont;
    }

    public void draw(SpriteBatch sb) {
        int x = Gdx.input.getX();
        int y = Gdx.input.getY();
        if (this.inTransition) {
            Color c;
            if (this.type == ButtonType.INVISIBLE) {
                this.oldImage.draw(sb, 1.0f - (float)this.transitionState / 100.0f);
            } else {
                this.oldImage.draw(sb);
            }
            this.image.draw(sb, (float)this.transitionState / 100.0f);
            if (this.oldType == ButtonType.INVISIBLE) {
                c = this.font.currentFont.getColor();
                c.set(c.r, c.g, c.b, (float)this.transitionState / 100.0f);
                this.font.setColor(c);
            }
            if (this.type == ButtonType.INVISIBLE) {
                c = this.font.currentFont.getColor();
                c.set(c.r, c.g, c.b, 1.0f - (float)this.transitionState / 100.0f);
                this.font.setColor(c);
            }
            if (this.type == ButtonType.INVISIBLE && this.oldType == ButtonType.INVISIBLE) {
                c = this.font.currentFont.getColor();
                c.set(c.r, c.g, c.b, 0.0f);
                this.font.setColor(c);
            }
            if (!this.centerFont) {
                this.font.write(this.text, sb, (int)this.position.x + 5, (int)this.position.y + this.fontHeight);
            } else {
                int imgwidth = (int)(this.type == ButtonType.BIG ? this.image.getWidth() : this.oldImage.getWidth());
                this.font.write(this.text, sb, (int)(this.position.x + (float)(imgwidth / 2) - (float)this.fontWidth / 2.0f), (int)this.position.y + this.fontHeight);
            }
        } else {
            this.image.draw(sb);
        }
        if (this.type != ButtonType.INVISIBLE) {
            if (!this.centerFont) {
                this.font.write(this.text, sb, (int)this.position.x + 5, (int)this.position.y + this.fontHeight);
            } else {
                this.font.write(this.text, sb, (int)(this.position.x + this.image.getWidth() / 2.0f - (float)this.fontWidth / 2.0f), (int)this.position.y + this.fontHeight);
            }
            if (new Rectangle(this.position.x, this.position.y, this.image.getWidth(), this.image.getHeight()).contains(x, y) && this.checkClick && this.type != ButtonType.BIG && this.type != ButtonType.COTE_INDISPONIBLE) {
                this.mask.setPosition(this.position.x, this.position.y);
                this.mask.draw(sb);
            }
        }
    }

    public void update(int scroll) {
        if (scroll != this.lastScroll) {
            this.lastScroll = scroll;
            Vector2 nouvel = new Vector2(this.originalPosition.x, this.originalPosition.y + (float)scroll);
            this.setPosition(nouvel);
        }
        this.update();
    }

    public void update() {
        int x = Gdx.input.getX();
        int y = Gdx.input.getY();
        if (Gdx.input.isButtonPressed(0) && this.type != ButtonType.INVISIBLE && !this.inTransition && this.checkClick && this.type != ButtonType.COTE_INDISPONIBLE && new Rectangle(this.position.x, this.position.y, this.image.getWidth(), this.image.getHeight()).contains(x, y)) {
            this.onClick();
        }
        if (this.inTransition) {
            this.transitionState = (int)((float)this.transitionState + this.transitionSpeed);
            if ((float)this.transitionState >= 100.0f - this.transitionSpeed) {
                this.transitionState = 0;
                this.inTransition = false;
            }
        }
    }

    public void setButtonType(ButtonType newType, boolean force) {
        if (!this.inTransition || force) {
            this.oldType = this.type;
            this.type = newType;
            this.oldImage = this.image;
            this.oldImage = this.getImageFromType(this.oldType);
            this.image = this.getImageFromType(this.type);
            System.out.println(String.valueOf(this.text.substring(0, 4)) + " : " + (Object)((Object)this.oldType) + " --> " + (Object)((Object)this.type));
            this.inTransition = true;
        }
    }

    public void centerize(boolean x, boolean y) {
        if (x) {
            this.position.x -= (float)(this.getWidth() / 2);
        }
        if (y) {
            this.position.y -= (float)(this.getHeight() / 2);
        }
        this.image.setPosition(this.position.x, this.position.y);
    }

    public void setPosition(Vector2 newPos) {
        this.position = newPos;
        this.image.setPosition(this.position.x, this.position.y);
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public int getWidth() {
        return (int)this.image.getWidth();
    }

    public int getHeight() {
        return (int)this.image.getHeight();
    }

    public void onClick() {
    }

    public static enum ButtonType {
        QUESTION,
        BIG,
        CONFIRMER,
        REPONSE,
        REPONSE_INCONNU,
        REPONSE_VALIDE,
        REPONSE_INVALIDE,
        COTE,
        ACCEUIL_COTE,
        COTE_INDISPONIBLE,
        INVISIBLE;

    }
}

