/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tiledmappacker;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.tiledmappacker.TileSetLayout;
import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ObjectMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TiledMapPacker {
    private TexturePacker packer;
    private TiledMap map;
    private ArrayList<Integer> blendedTiles = new ArrayList();
    private TmxMapLoader mapLoader = new TmxMapLoader(new PackerFileHandleResolver());
    private TiledMapPackerSettings settings;
    private static final String TilesetsOutputDir = "tileset";
    private static final String AtlasOutputName = "packed";
    private HashMap<String, IntArray> tilesetUsedIds = new HashMap();
    static File inputDir;
    static File outputDir;

    public TiledMapPacker() {
        this(new TiledMapPackerSettings());
    }

    public TiledMapPacker(TiledMapPackerSettings settings) {
        this.settings = settings;
    }

    public void processMaps(File inputDir, File outputDir, TexturePacker.Settings settings) throws IOException {
        FileHandle inputDirHandle = new FileHandle(inputDir.getAbsolutePath());
        File[] files = inputDir.listFiles(new TmxFilter());
        ObjectMap<String, TiledMapTileSet> tilesetsToPack = new ObjectMap<String, TiledMapTileSet>();
        for (File file : files) {
            this.map = this.mapLoader.load(file.getAbsolutePath());
            if (this.settings.stripUnusedTiles) {
                int mapWidth = this.map.getProperties().get("width", Integer.class);
                int mapHeight = this.map.getProperties().get("height", Integer.class);
                int numlayers = this.map.getLayers().getCount();
                int bucketSize = mapWidth * mapHeight * numlayers;
                for (MapLayer layer : this.map.getLayers()) {
                    if (!(layer instanceof TiledMapTileLayer)) continue;
                    TiledMapTileLayer tlayer = (TiledMapTileLayer)layer;
                    for (int y = 0; y < mapHeight; ++y) {
                        for (int x = 0; x < mapWidth; ++x) {
                            if (tlayer.getCell(x, y) == null) continue;
                            int tileid = tlayer.getCell(x, y).getTile().getId() & 0x1FFFFFFF;
                            String tilesetName = this.tilesetNameFromTileId(this.map, tileid);
                            IntArray usedIds = this.getUsedIdsBucket(tilesetName, bucketSize);
                            usedIds.add(tileid);
                            if (tilesetsToPack.containsKey(tilesetName)) continue;
                            tilesetsToPack.put(tilesetName, this.map.getTileSets().getTileSet(tilesetName));
                        }
                    }
                }
            } else {
                for (TiledMapTileSet tileset : this.map.getTileSets()) {
                    String tilesetName = tileset.getName();
                    if (tilesetsToPack.containsKey(tilesetName)) continue;
                    tilesetsToPack.put(tilesetName, tileset);
                }
            }
            FileHandle tmxFile = new FileHandle(file.getAbsolutePath());
            this.writeUpdatedTMX(this.map, outputDir, tmxFile);
        }
        this.packTilesets(tilesetsToPack, inputDirHandle, outputDir, settings);
    }

    private String tilesetNameFromTileId(TiledMap map, int tileid) {
        String name = "";
        if (tileid == 0) {
            return "";
        }
        for (TiledMapTileSet tileset : map.getTileSets()) {
            int firstgid = tileset.getProperties().get("firstgid", -1, Integer.class);
            if (firstgid == -1) continue;
            if (tileid >= firstgid) {
                name = tileset.getName();
                continue;
            }
            return name;
        }
        return name;
    }

    private IntArray getUsedIdsBucket(String tilesetName, int size) {
        if (this.tilesetUsedIds.containsKey(tilesetName)) {
            return this.tilesetUsedIds.get(tilesetName);
        }
        if (size <= 0) {
            return null;
        }
        IntArray bucket = new IntArray(size);
        this.tilesetUsedIds.put(tilesetName, bucket);
        return bucket;
    }

    private void packTilesets(ObjectMap<String, TiledMapTileSet> sets, FileHandle inputDirHandle, File outputDir, TexturePacker.Settings texturePackerSettings) throws IOException {
        this.packer = new TexturePacker(texturePackerSettings);
        for (TiledMapTileSet set : sets.values()) {
            String tilesetName = set.getName();
            System.out.println("Processing tileset " + tilesetName);
            IntArray usedIds = this.settings.stripUnusedTiles ? this.getUsedIdsBucket(tilesetName, -1) : null;
            int tileWidth = set.getProperties().get("tilewidth", Integer.class);
            int tileHeight = set.getProperties().get("tileheight", Integer.class);
            int firstgid = set.getProperties().get("firstgid", Integer.class);
            String imageName = set.getProperties().get("imagesource", String.class);
            TileSetLayout layout = new TileSetLayout(firstgid, set, inputDirHandle);
            int gid = layout.firstgid;
            for (int i = 0; i < layout.numTiles; ++i) {
                if (usedIds != null && !usedIds.contains(gid)) {
                    System.out.println("Stripped id #" + gid + " from tileset \"" + tilesetName + "\"");
                } else {
                    Vector2 tileLocation = layout.getLocation(gid);
                    BufferedImage tile = new BufferedImage(tileWidth, tileHeight, 6);
                    Graphics2D g = tile.createGraphics();
                    g.drawImage(layout.image, 0, 0, tileWidth, tileHeight, (int)tileLocation.x, (int)tileLocation.y, (int)tileLocation.x + tileWidth, (int)tileLocation.y + tileHeight, null);
                    if (TiledMapPacker.isBlended(tile)) {
                        this.setBlended(gid);
                    }
                    System.out.println("Adding " + tileWidth + "x" + tileHeight + " (" + (int)tileLocation.x + ", " + (int)tileLocation.y + ")");
                    this.packer.addImage(tile, this.settings.atlasOutputName + "_" + (gid - 1));
                }
                ++gid;
            }
        }
        File outputDirTilesets = TiledMapPacker.getRelativeFile(outputDir, this.settings.tilesetOutputDirectory);
        outputDirTilesets.mkdirs();
        this.packer.pack(outputDirTilesets, this.settings.atlasOutputName + ".atlas");
    }

    private static String removeExtension(String s) {
        int extensionIndex = s.lastIndexOf(".");
        if (extensionIndex == -1) {
            return s;
        }
        return s.substring(0, extensionIndex);
    }

    private static String removePath(String s) {
        int index = s.lastIndexOf(92);
        String temp = index != -1 ? s.substring(index + 1) : s;
        index = temp.lastIndexOf(47);
        if (index != -1) {
            return s.substring(index + 1);
        }
        return s;
    }

    private static File getRelativeFile(File path, String relativePath) {
        if (relativePath.trim().length() == 0) {
            return path;
        }
        File child = path;
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "\\/");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (token.equals("..")) {
                child = child.getParentFile();
                continue;
            }
            child = new File(child, token);
        }
        return child;
    }

    private void setBlended(int tileNum) {
        this.blendedTiles.add(tileNum);
    }

    private void writeUpdatedTMX(TiledMap tiledMap, File outputDir, FileHandle tmxFileHandle) throws IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(tmxFileHandle.read());
            Node map = doc.getFirstChild();
            while (map.getNodeType() != 1 || map.getNodeName() != "map") {
                if ((map = map.getNextSibling()) != null) continue;
                throw new GdxRuntimeException("Couldn't find map node!");
            }
            TiledMapPacker.setProperty(doc, map, "blended tiles", TiledMapPacker.toCSV(this.blendedTiles));
            TiledMapPacker.setProperty(doc, map, "atlas", this.settings.tilesetOutputDirectory + "/" + this.settings.atlasOutputName + ".atlas");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            outputDir.mkdirs();
            StreamResult result = new StreamResult(new File(outputDir, tmxFileHandle.name()));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("ParserConfigurationException: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new RuntimeException("SAXException: " + e.getMessage());
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("TransformerConfigurationException: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new RuntimeException("TransformerException: " + e.getMessage());
        }
    }

    private static void setProperty(Document doc, Node parent, String name, String value) {
        Node properties = TiledMapPacker.getFirstChildNodeByName(parent, "properties");
        Node property = TiledMapPacker.getFirstChildByNameAttrValue(properties, "property", "name", name);
        NamedNodeMap attributes = property.getAttributes();
        Node valueNode = attributes.getNamedItem("value");
        if (valueNode == null) {
            valueNode = doc.createAttribute("value");
            valueNode.setNodeValue(value);
            attributes.setNamedItem(valueNode);
        } else {
            valueNode.setNodeValue(value);
        }
    }

    private static String toCSV(ArrayList<Integer> values) {
        String temp = "";
        for (int i = 0; i < values.size() - 1; ++i) {
            temp = temp + values.get(i) + ",";
        }
        if (values.size() > 0) {
            temp = temp + values.get(values.size() - 1);
        }
        return temp;
    }

    private static Node getFirstChildNodeByName(Node parent, String child) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals(child)) continue;
            return childNodes.item(i);
        }
        Element newNode = parent.getOwnerDocument().createElement(child);
        if (childNodes.item(0) != null) {
            return parent.insertBefore(newNode, childNodes.item(0));
        }
        return parent.appendChild(newNode);
    }

    private static boolean isBlended(BufferedImage tile) {
        int[] rgbArray = new int[tile.getWidth() * tile.getHeight()];
        tile.getRGB(0, 0, tile.getWidth(), tile.getHeight(), rgbArray, 0, tile.getWidth());
        for (int i = 0; i < tile.getWidth() * tile.getHeight(); ++i) {
            if ((rgbArray[i] >> 24 & 0xFF) == 255) continue;
            return true;
        }
        return false;
    }

    private static Node getFirstChildByNameAttrValue(Node node, String childName, String attr, String value) {
        NamedNodeMap attributes;
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node attribute;
            if (!childNodes.item(i).getNodeName().equals(childName) || !(attribute = (attributes = childNodes.item(i).getAttributes()).getNamedItem(attr)).getNodeValue().equals(value)) continue;
            return childNodes.item(i);
        }
        Element newNode = node.getOwnerDocument().createElement(childName);
        attributes = newNode.getAttributes();
        Attr nodeAttr = node.getOwnerDocument().createAttribute(attr);
        nodeAttr.setNodeValue(value);
        attributes.setNamedItem(nodeAttr);
        if (childNodes.item(0) != null) {
            return node.insertBefore(newNode, childNodes.item(0));
        }
        return node.appendChild(newNode);
    }

    public static void main(String[] args) {
        final TexturePacker.Settings texturePackerSettings = new TexturePacker.Settings();
        texturePackerSettings.paddingX = 2;
        texturePackerSettings.paddingY = 2;
        texturePackerSettings.edgePadding = true;
        texturePackerSettings.duplicatePadding = true;
        texturePackerSettings.bleed = true;
        texturePackerSettings.alias = true;
        texturePackerSettings.useIndexes = true;
        final TiledMapPackerSettings packerSettings = new TiledMapPackerSettings();
        switch (args.length) {
            case 3: {
                inputDir = new File(args[0]);
                outputDir = new File(args[1]);
                if (!"--strip-unused".equals(args[2])) break;
                packerSettings.stripUnusedTiles = true;
                break;
            }
            case 2: {
                inputDir = new File(args[0]);
                outputDir = new File(args[1]);
                break;
            }
            case 1: {
                inputDir = new File(args[0]);
                outputDir = new File(inputDir, "output/");
                break;
            }
            default: {
                System.out.println("Usage: INPUTDIR [OUTPUTDIR] [--strip-unused]");
                System.exit(0);
            }
        }
        TiledMapPacker packer = new TiledMapPacker(packerSettings);
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.forceExit = false;
        config.width = 100;
        config.height = 50;
        config.title = "TiledMapPacker";
        new LwjglApplication(new ApplicationListener(){

            @Override
            public void resume() {
            }

            @Override
            public void resize(int width, int height) {
            }

            @Override
            public void render() {
            }

            @Override
            public void pause() {
            }

            @Override
            public void dispose() {
            }

            @Override
            public void create() {
                TiledMapPacker packer = new TiledMapPacker(packerSettings);
                if (!inputDir.exists()) {
                    throw new RuntimeException("Input directory does not exist: " + inputDir);
                }
                try {
                    packer.processMaps(inputDir, outputDir, texturePackerSettings);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error processing map: " + e.getMessage());
                }
                Gdx.app.exit();
            }
        }, config);
    }

    public static class TiledMapPackerSettings {
        public boolean stripUnusedTiles = false;
        public String tilesetOutputDirectory = "tileset";
        public String atlasOutputName = "packed";
    }

    private static class PackerFileHandleResolver
    implements FileHandleResolver {
        @Override
        public FileHandle resolve(String fileName) {
            return new FileHandle(fileName);
        }
    }

    private static class TmxFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".tmx");
        }
    }
}

