/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import data.FontManager;
import data.GSB;
import data.MapManager;
import java.util.ArrayList;
import screens.Editor;
import screens.Game;
import screens.MainMenu;
import ui_buttons.BigButton;
import ui_buttons.ScrollClass;
import ui_buttons.TextInput;

public class MapMenu
implements Screen {
    BigButton start;
    BigButton edit;
    BigButton delete;
    BigButton exit;
    BigButton newMap;
    TextInput name;
    BigButton ok;
    ArrayList<String> maps = new ArrayList();
    String selected = "";
    boolean newMapText = false;
    int scroll = 0;

    public MapMenu() {
        try {
            FileHandle folder = Gdx.files.internal("./maps/");
            if (!folder.exists()) {
                folder.file().mkdir();
            }
            FileHandle[] fileHandleArray = folder.list();
            int n = fileHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileHandle fh = fileHandleArray[n2];
                if (fh.extension().equals("spg")) {
                    System.out.println("[LOAD][MAP] loaded : " + fh.nameWithoutExtension());
                    this.maps.add(fh.nameWithoutExtension());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.maps.isEmpty()) {
            this.maps.add("Default");
        }
        this.newMap = new BigButton("New map"){

            @Override
            protected void onClick() {
                MapMenu.this.name.setUpdate(true);
                MapMenu.this.newMapText = true;
            }
        };
        this.newMap.setLocation(Gdx.graphics.getWidth() - this.newMap.getWidth(), Gdx.graphics.getHeight() - this.newMap.getHeight());
        this.start = new BigButton("Play"){

            @Override
            protected void onClick() {
                ((com.badlogic.gdx.Game)Gdx.app.getApplicationListener()).setScreen(new Game("./maps/" + MapMenu.this.selected));
            }
        };
        this.start.setLocation(Gdx.graphics.getWidth() - this.start.getWidth(), Gdx.graphics.getHeight() / 2 + this.start.getHeight());
        this.edit = new BigButton("Edit"){

            @Override
            protected void onClick() {
                ((com.badlogic.gdx.Game)Gdx.app.getApplicationListener()).setScreen(new Editor("./maps/" + MapMenu.this.selected));
            }
        };
        this.edit.setLocation(Gdx.graphics.getWidth() - this.start.getWidth(), Gdx.graphics.getHeight() / 2);
        this.delete = new BigButton("Delete"){

            @Override
            protected void onClick() {
                Gdx.files.internal(String.valueOf(MapMenu.this.selected) + ".spg").file().delete();
                MapMenu.this.maps.remove(MapMenu.this.selected);
                MapMenu.this.selected = "";
            }
        };
        this.delete.setLocation(Gdx.graphics.getWidth() - this.start.getWidth(), Gdx.graphics.getHeight() / 2 - this.delete.getHeight());
        this.exit = new BigButton("Back to main menu"){

            @Override
            protected void onClick() {
                ((com.badlogic.gdx.Game)Gdx.app.getApplicationListener()).setScreen(new MainMenu());
            }
        };
        this.exit.setLocation(Gdx.graphics.getWidth() - this.exit.getWidth(), 0);
        this.name = new TextInput("Enter map name here");
        this.name.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
        this.name.center(true, true);
        this.name.setRegex("[a-z]|[A-Z]|\\040");
        Gdx.input.setInputProcessor(this.name);
        this.name.setUpdate(false);
        this.ok = new BigButton("Ok"){

            @Override
            protected void onClick() {
                MapMenu.this.newMapText = false;
                if (!MapMenu.this.maps.contains(MapMenu.this.name.getText()) && MapMenu.this.name.getText() != "") {
                    MapMenu.this.maps.add(MapMenu.this.name.getText());
                    MapManager.load("./maps/" + MapMenu.this.name.getText());
                }
                MapMenu.this.name.reset();
                MapMenu.this.name.setUpdate(false);
            }
        };
        this.ok.setLocation(Gdx.graphics.getWidth() / 2, this.name.getY() - 100);
        this.ok.center(true, false);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (!this.newMapText) {
            GSB.hud.begin();
            if (this.selected != "") {
                this.start.render(0);
                this.edit.render(0);
                this.delete.render(0);
            }
            this.exit.render(0);
            this.newMap.render(0);
            GSB.hud.end();
            int x = 30;
            int y = Gdx.graphics.getHeight() - 150;
            GSB.srHud.begin(ShapeRenderer.ShapeType.Filled);
            for (String s : this.maps) {
                if (s.equals(this.selected)) {
                    GSB.srHud.setColor(Color.LIGHT_GRAY);
                } else {
                    GSB.srHud.setColor(0.9f, 0.9f, 0.9f, 1.0f);
                }
                GSB.srHud.rect(x, y, 200.0f, 100.0f);
                if ((x += 250) + 250 <= Gdx.graphics.getWidth() - this.exit.getWidth() - 100) continue;
                x = 30;
                y -= 150;
            }
            GSB.srHud.end();
            GSB.hud.begin();
            x = 30;
            y = Gdx.graphics.getHeight() - 150;
            for (String s : this.maps) {
                GlyphLayout gl = new GlyphLayout(FontManager.get(18), s);
                FontManager.get(18).draw((Batch)GSB.hud, s, (float)(x + 100) - gl.width / 2.0f, (float)(y + 55));
                if ((x += 250) + 250 <= Gdx.graphics.getWidth() - this.exit.getWidth() - 100) continue;
                x = 30;
                y -= 150;
            }
            GSB.hud.end();
        } else {
            GSB.hud.begin();
            this.name.render(0);
            this.ok.render(0);
            GSB.hud.end();
        }
        this.update(delta);
    }

    public void update(float delta) {
        if (!this.newMapText) {
            if (this.selected != "") {
                this.start.update();
                this.edit.update();
                this.delete.update();
            }
            this.exit.update();
            this.newMap.update();
            int x = 30;
            int y = Gdx.graphics.getHeight() - 150;
            if (Gdx.input.justTouched()) {
                String oldSelected = new String(this.selected);
                for (String s : this.maps) {
                    if (new Rectangle(x, y, 200.0f, 100.0f).contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY())) {
                        this.selected = s;
                        break;
                    }
                    this.selected = "";
                    if ((x += 250) + 250 <= Gdx.graphics.getWidth() - this.exit.getWidth() - 100) continue;
                    x = 30;
                    y -= 150;
                }
                if (oldSelected.equals(this.selected)) {
                    this.start.forceClick();
                }
            }
        } else {
            this.ok.update();
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void show() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        Gdx.input.setInputProcessor(new ScrollClass());
    }

    @Override
    public void dispose() {
    }
}

