/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import data.FontManager;
import data.GSB;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import particles.ParticleEmitter;
import screens.MapMenu;
import screens.Options;
import screens.UpdateMenu;
import ui_buttons.BigButton;
import ui_buttons.ScrollClass;

public class MainMenu
implements Screen {
    BigButton play;
    BigButton exit;
    BigButton options;
    ArrayList<ParticleEmitter> pe = new ArrayList();
    ParticleEmitter mouse;
    String version = "0.95";
    String downloadedVersion = "ERROR";
    BigButton update;
    BigButton doNotUpdate;
    boolean updateMenu = false;
    float speed = 1.0f;
    int count = 0;

    public MainMenu() {
        this.checkForUpdate();
        this.play = new BigButton("Play"){

            @Override
            protected void onClick() {
                ((Game)Gdx.app.getApplicationListener()).setScreen(new MapMenu());
            }
        };
        this.play.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2 + 100);
        this.play.center(true, false);
        this.options = new BigButton("Options"){

            @Override
            protected void onClick() {
                ((Game)Gdx.app.getApplicationListener()).setScreen(new Options());
            }
        };
        this.options.setLocation(this.play.getX(), this.play.getY() - this.play.getHeight());
        this.exit = new BigButton("Exit"){

            @Override
            protected void onClick() {
                Gdx.app.exit();
            }
        };
        this.exit.setLocation(this.options.getX(), this.options.getY() - this.options.getHeight());
        this.update = new BigButton("Update"){

            @Override
            protected void onClick() {
                ((Game)Gdx.app.getApplicationListener()).setScreen(new UpdateMenu(MainMenu.this.downloadedVersion));
            }
        };
        this.update.setLocation(this.play.getX(), this.play.getY());
        this.doNotUpdate = new BigButton("Don't update"){

            @Override
            protected void onClick() {
                MainMenu.this.updateMenu = false;
            }
        };
        this.doNotUpdate.setLocation(this.options.getX(), this.options.getY());
        this.pe.add(new ParticleEmitter(this.play.getX() + this.play.getWidth() / 2, this.play.getY() + 25, 3.0f));
        this.pe.get(0).setRate(5);
        this.mouse = new ParticleEmitter(0, 0, 2.0f);
        this.mouse.enableGravity(-0.1f);
        this.mouse.setRate(100);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (this.updateMenu) {
            GSB.hud.begin();
            FontManager.get(25).draw(GSB.hud, "A more recent update is available", Gdx.graphics.getWidth() / 2, this.update.getY() + 200, 0.0f, 1, false);
            this.doNotUpdate.render(0);
            this.update.render(0);
            GSB.hud.end();
        } else {
            if (this.play.isHovered()) {
                for (ParticleEmitter p : this.pe) {
                    p.startEmitting();
                }
            } else {
                for (ParticleEmitter p : this.pe) {
                    p.stopEmitting();
                }
            }
            for (ParticleEmitter p : this.pe) {
                p.render();
            }
            this.mouse.render();
            GSB.hud.begin();
            this.play.render(0);
            this.options.render(0);
            this.exit.render(0);
            GSB.hud.end();
        }
        this.update(delta);
    }

    private void update(float delta) {
        if (this.updateMenu) {
            this.update.update();
            this.doNotUpdate.update();
        } else {
            this.speed += 0.01f;
            this.play.update();
            this.exit.update();
            this.options.update();
            if (Gdx.input.isButtonPressed(0)) {
                this.mouse.setX(Gdx.input.getX());
                this.mouse.setY(Gdx.graphics.getHeight() - Gdx.input.getY());
                this.mouse.startEmitting();
            } else {
                this.mouse.stopEmitting();
            }
            this.mouse.setRate(this.mouse.getRate() + -ScrollClass.getScroll());
            this.count = 0;
            for (ParticleEmitter p : this.pe) {
                p.update(delta);
                this.count += p.getParticleCount();
            }
            this.mouse.update(delta);
            this.count += this.mouse.getParticleCount();
        }
    }

    private void checkForUpdate() {
        String url = "http://lablanchisserie.fr/Parissou/SupergunRemake/version.txt";
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Java");
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            boolean bl = this.updateMenu = !this.version.equals(response.toString());
            if (this.updateMenu) {
                this.downloadedVersion = response.toString();
                System.out.println("[LOAD][UPDATE] An update is available !" + this.version + " " + response.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void show() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

