/*
 * Decompiled with CFR 0.152.
 */
package screens;

import AI.AI;
import boxs.WorldBoxs;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import data.ColorManager;
import data.FontManager;
import data.GSB;
import data.MapManager;
import data.SpriteManager;
import game.Personnage;
import game.WorldEntities;
import java.util.ArrayList;
import map.Block;
import map.Map;
import screens.MainMenu;
import screens.Options;
import ui_buttons.BigButton;
import ui_buttons.ScrollClass;
import weapons.BulletWeapon;
import weapons.Pistol;

public class Game
implements Screen {
    public static OrthographicCamera camera = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    private static Vector3 position;
    Map m = new Map();
    Animation anim;
    ArrayList<Personnage> players;
    Sprite background;
    Sprite slowed;
    float originX;
    float originY;
    WorldBoxs boxs;
    public static boolean debug;
    boolean IA = Options.get("IA");
    AI theDevil;
    Music music;
    BigButton resume;
    BigButton exit;
    boolean paused = false;
    static float minx;
    static float miny;
    static float maxx;
    static float maxy;
    public WorldEntities we = new WorldEntities();
    public static boolean invincible;
    float time = 0.0f;
    static boolean forcedMatrix;
    static float JITMatrix;
    float begin = 3.0f;
    float fps = 0.0f;
    int frames = 0;
    long temps = 0L;
    boolean wait = false;
    float cameraScroll = 0.0f;

    static {
        debug = false;
        invincible = false;
        forcedMatrix = false;
        JITMatrix = 0.0f;
    }

    public static void resetCamera() {
        Game.camera.position.x = Game.position.x;
        Game.camera.position.y = Game.position.y;
        Game.camera.zoom = 1.0f;
    }

    public static void initCameraAndGSB() {
        camera.setToOrtho(false, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        position = new Vector3(Game.camera.position);
        GSB.init(camera);
        Gdx.input.setInputProcessor(new ScrollClass());
    }

    public Game(String mapName) {
        ColorManager.reset();
        Game.camera.zoom = 2.5f;
        this.music = Gdx.audio.newMusic(Gdx.files.internal("music.mp3"));
        this.music.setLooping(true);
        if (Options.get("music")) {
            this.music.play();
        }
        this.boxs = new WorldBoxs();
        Game.camera.zoom = 5.0f;
        this.background = SpriteManager.get("sky.png");
        this.slowed = SpriteManager.get("slowed.png");
        float centerx = this.background.getWidth() / 2.0f;
        float centery = this.background.getHeight() / 2.0f;
        Game.camera.position.x = centerx;
        Game.camera.position.y = centery;
        this.originX = (float)(Gdx.graphics.getWidth() / 2) - centerx;
        this.originY = (float)(Gdx.graphics.getHeight() / 2) - centery;
        this.background.setPosition(this.originX, this.originY);
        this.slowed.setCenterX(Gdx.graphics.getWidth() / 2);
        this.slowed.setY((float)Gdx.graphics.getHeight() - this.slowed.getHeight());
        this.m = MapManager.load(mapName);
        this.m.computeTypes();
        this.boxs.setMap(this.m);
        float minY = 1.0E9f;
        float maxy = -1.0E7f;
        float minx = 1.0E9f;
        float maxx = -1.0E7f;
        for (Block c : this.m.getBlocks()) {
            if (c.getY() < minY) {
                minY = c.getY();
            }
            if (c.getY() > maxy) {
                maxy = c.getY();
            }
            if (c.getX() < minx) {
                minx = c.getX();
            }
            if (!(c.getX() > maxx)) continue;
            maxx = c.getX();
        }
        Game.minx = minx;
        miny = minY;
        Game.maxx = maxx;
        Game.maxy = maxy;
        WorldBoxs.setMaxY(maxy += 10.0f);
        minY -= 10.0f;
        minY *= 256.0f;
        WorldBoxs.setMaxx(maxx);
        WorldBoxs.setMinx(minx);
        minx -= 40.0f;
        maxx += 40.0f;
        BulletWeapon.setMinMaxX((int)(minx *= 256.0f), (int)(maxx *= 256.0f));
        this.players = new ArrayList();
        this.players.add(new Personnage(0, (int)minY, this));
        this.players.add(new Personnage(1, (int)minY, this));
        this.players.get(0).setOrigin(this.m.getGentilPos());
        this.players.get(1).setOrigin(this.m.getMechantPos());
        this.players.get(0).setEnnemy(this.players.get(1));
        this.players.get(1).setEnnemy(this.players.get(0));
        this.players.get(0).setWeapon(new Pistol());
        this.players.get(1).setWeapon(new Pistol());
        this.theDevil = new AI(this.m);
        for (Personnage p : this.players) {
            this.we.addPersonnage(p);
        }
        for (Block c : this.m.getBlocks()) {
            for (Personnage p : this.players) {
                p.addCollision(c);
            }
        }
        this.resume = new BigButton("Resume"){

            @Override
            protected void onClick() {
                Game.this.paused = false;
            }
        };
        this.resume.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
        this.resume.center(true, false);
        this.exit = new BigButton("Exit"){

            @Override
            protected void onClick() {
                Game.resetCamera();
                GSB.update(camera);
                Game.this.music.stop();
                ((com.badlogic.gdx.Game)Gdx.app.getApplicationListener()).setScreen(new MainMenu());
            }
        };
        this.exit.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2 - this.resume.getHeight());
        this.exit.center(true, false);
        try {
            FileHandle folder = Gdx.files.internal(".");
            FileHandle[] fileHandleArray = folder.list();
            int n = fileHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileHandle fh = fileHandleArray[n2];
                if (fh.extension().equals("spg")) {
                    System.out.println("[LOAD][MAP] loaded : " + fh.nameWithoutExtension());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
    }

    public static boolean isGameSlowed() {
        return forcedMatrix || JITMatrix > 0.0f;
    }

    @Override
    public void render(float delta) {
        this.fps += delta;
        ++this.frames;
        if (this.fps > 1.0f) {
            this.fps = 0.0f;
            Gdx.graphics.setTitle("Supergun Arena : " + this.frames);
            this.frames = 0;
        }
        JITMatrix -= delta;
        if (Game.isGameSlowed()) {
            delta /= 5.0f;
        }
        if (JITMatrix < 0.0f) {
            JITMatrix = 0.0f;
        }
        int count = 0;
        for (Personnage p : this.players) {
            if (Math.abs(p.getVx()) > 90.0f && !this.wait && JITMatrix == 0.0f) {
                JITMatrix = 1.0f;
                this.wait = true;
            }
            if (!(Math.abs(p.getVx()) < 90.0f)) continue;
            ++count;
        }
        if (count == this.players.size()) {
            this.wait = false;
        }
        this.time += delta;
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        this.background.setPosition(this.originX - Game.camera.position.x / 80.0f, this.originY - Game.camera.position.y / 80.0f);
        this.background.setScale((float)Gdx.graphics.getWidth() / (this.background.getWidth() / 2.0f));
        GSB.hud.begin();
        this.background.draw(GSB.hud);
        GSB.hud.end();
        this.m.render(delta);
        GSB.sb.begin();
        this.boxs.render();
        for (Personnage p : this.players) {
            p.render(delta);
        }
        GSB.sb.end();
        this.we.render();
        for (Personnage p : this.players) {
            p.renderUI();
        }
        if (debug) {
            this.players.get(0).renderCollision();
            this.theDevil.renderPath();
        }
        if (this.begin > 0.0f) {
            GSB.srHud.begin(ShapeRenderer.ShapeType.Filled);
            Gdx.gl.glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
            GSB.srHud.setColor(1.0f, 1.0f, 1.0f, 0.4f);
            GSB.srHud.rect(0.0f, Gdx.graphics.getHeight() / 2 - 100, Gdx.graphics.getWidth(), 150.0f);
            GSB.srHud.end();
            GSB.hud.begin();
            float ratio = (this.begin - (float)((int)this.begin)) * 2.0f - 1.0f;
            float xratio = ratio * ratio;
            if (ratio < 0.0f) {
                xratio = -xratio;
            }
            xratio /= 2.0f;
            FontManager.get(85).draw((Batch)GSB.hud, "" + (int)(this.begin + 1.0f), (xratio += 0.5f) * (float)Gdx.graphics.getWidth(), (float)(Gdx.graphics.getHeight() / 2));
            GSB.hud.end();
        }
        if (Game.isGameSlowed()) {
            GSB.hud.begin();
            this.slowed.draw(GSB.hud, 0.7f);
            GSB.hud.end();
        }
        if (this.paused) {
            Gdx.gl.glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
            GSB.srHud.begin(ShapeRenderer.ShapeType.Filled);
            GSB.srHud.setColor(1.0f, 1.0f, 1.0f, 0.4f);
            GSB.srHud.rect(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            GSB.srHud.end();
            GSB.hud.begin();
            this.resume.render(0);
            this.exit.render(0);
            GSB.hud.end();
        }
        this.update(delta);
    }

    public void update(float delta) {
        if (!this.paused) {
            this.cameraScroll += (float)ScrollClass.getScroll() / 5.0f;
            if (Gdx.input.isKeyJustPressed(41)) {
                boolean bl = forcedMatrix = !forcedMatrix;
            }
            if (Gdx.input.isKeyJustPressed(246)) {
                boolean bl = debug = !debug;
            }
            if (this.begin <= 0.0f) {
                if (Gdx.input.isKeyPressed(47)) {
                    this.players.get(0).move(false, delta);
                }
                if (Gdx.input.isKeyPressed(34)) {
                    this.players.get(0).move(true, delta);
                }
                if (Gdx.input.isKeyJustPressed(33)) {
                    this.players.get(0).jump();
                }
                if (Gdx.input.isKeyPressed(62)) {
                    this.players.get(0).fire();
                }
                if (!this.IA) {
                    if (Gdx.input.isKeyPressed(21)) {
                        this.players.get(1).move(false, delta);
                    }
                    if (Gdx.input.isKeyPressed(22)) {
                        this.players.get(1).move(true, delta);
                    }
                    if (Gdx.input.isKeyJustPressed(19)) {
                        this.players.get(1).jump();
                    }
                    if (Gdx.input.isKeyPressed(130) || Gdx.input.isKeyPressed(66)) {
                        this.players.get(1).fire();
                    }
                } else {
                    this.theDevil.update(this.players.get(1), this.players.get(0), delta);
                }
            } else {
                this.begin -= delta;
            }
            this.we.update(delta);
            this.music.setVolume(1.0f);
            this.players.get(0).testWeapon(this.players.get(1), delta);
            this.players.get(1).testWeapon(this.players.get(0), delta);
            this.boxs.update(delta, this.players.get(0), this.players.get(1));
            for (Personnage p : this.players) {
                p.update(delta);
            }
            this.computeCamera(delta);
        }
        if (Gdx.input.isKeyJustPressed(131)) {
            this.paused = true;
        }
        if (Gdx.input.isKeyJustPressed(37)) {
            boolean bl = invincible = !invincible;
        }
        if (this.paused) {
            this.resume.update();
            this.exit.update();
        }
        camera.update();
        GSB.update(camera);
    }

    private void computeCamera(float delta) {
        float centerx = this.players.get(0).getX() + this.players.get(1).getX();
        float centery = this.players.get(0).getY() + this.players.get(1).getY();
        float lerp = 0.05f;
        Vector3 position = Game.camera.position;
        position.x += ((centerx /= 2.0f) - position.x) * lerp * delta * 60.0f;
        position.y += ((centery /= 2.0f) - position.y) * lerp * delta * 60.0f;
        double distance = Math.sqrt(Math.pow(this.players.get(0).getX() - this.players.get(1).getX(), 2.0) + Math.pow(this.players.get(0).getY() - this.players.get(1).getY(), 2.0));
        Game.camera.position.x = (float)Math.round(Game.camera.position.x * 1000.0f) / 1000.0f;
        Game.camera.position.y = (float)Math.round(Game.camera.position.y * 1000.0f) / 1000.0f;
        lerp = 0.03f;
        Game.camera.zoom = Game.camera.zoom + (this.cameraScroll + 2.5f + (float)(Options.get("parkour") ? 3 : 0) + (float)(distance / (double)Gdx.graphics.getWidth()) - Game.camera.zoom) * lerp * delta * 60.0f;
        Game.camera.zoom = (float)Math.round(Game.camera.zoom * 1000.0f) / 1000.0f;
    }

    public static float getMaxx() {
        return maxx;
    }

    public static float getMaxy() {
        return maxy;
    }

    public static float getMinx() {
        return minx;
    }

    public static float getMiny() {
        return miny;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.paused = true;
    }

    @Override
    public void dispose() {
        this.music.dispose();
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
    }
}

