/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.badlogic.gdx.Gdx;
import data.Coord;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import map.Map;

public class MapManager {
    public static void save(Map toSave, String path) {
        try {
            if (!Gdx.files.internal(String.valueOf(path) + ".spg").exists()) {
                Gdx.files.internal(String.valueOf(path) + ".spg").file().createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(Gdx.files.internal(String.valueOf(path) + ".spg").file());
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(toSave);
            oos.close();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map load(String path) {
        try {
            if (!Gdx.files.internal(String.valueOf(path) + ".spg").exists()) {
                Gdx.files.internal(String.valueOf(path) + ".spg").file().createNewFile();
                MapManager.save(MapManager.getDefaultMap(), path);
                return MapManager.getDefaultMap();
            }
            FileInputStream fin = new FileInputStream(Gdx.files.internal(String.valueOf(path) + ".spg").file());
            ObjectInputStream ois = new ObjectInputStream(fin);
            try {
                Map m = (Map)ois.readObject();
                ois.close();
                return m;
            }
            catch (Exception e) {
                System.out.println("[LOAD][MAP] Version map error detected !");
                Gdx.files.internal(String.valueOf(path) + ".spg").file().delete();
                Gdx.files.internal(String.valueOf(path) + ".spg").file().createNewFile();
                MapManager.save(MapManager.getDefaultMap(), path);
                ois.close();
                return MapManager.getDefaultMap();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map getDefaultMap() {
        Map m = new Map();
        m.addBox(new Coord(0.0f, 1.0f));
        m.addBox(new Coord(1.0f, 1.0f));
        m.addBox(new Coord(2.0f, 1.0f));
        m.addBox(new Coord(3.0f, 1.0f));
        m.addBox(new Coord(4.0f, 1.0f));
        m.addBox(new Coord(-1.0f, 1.0f));
        m.addBox(new Coord(0.0f, 4.0f));
        m.addBox(new Coord(1.0f, 4.0f));
        m.addBox(new Coord(2.0f, 4.0f));
        m.addBox(new Coord(3.0f, 4.0f));
        m.addBox(new Coord(-2.0f, 1.0f));
        m.addBox(new Coord(5.0f, 1.0f));
        m.addBox(new Coord(1.0f, 6.0f));
        m.addBox(new Coord(2.0f, 6.0f));
        m.addBox(new Coord(-5.0f, -1.0f));
        m.addBox(new Coord(-4.0f, -1.0f));
        m.addBox(new Coord(-3.0f, -1.0f));
        m.addBox(new Coord(6.0f, -1.0f));
        m.addBox(new Coord(7.0f, -1.0f));
        m.addBox(new Coord(8.0f, -1.0f));
        m.addBox(new Coord(-4.0f, 4.0f));
        m.addBox(new Coord(-4.0f, 3.0f));
        m.addBox(new Coord(7.0f, 4.0f));
        m.addBox(new Coord(7.0f, 3.0f));
        m.setPlayersPosition(new Coord(200.0f, 300.0f), new Coord(500.0f, 300.0f));
        return m;
    }

    public static Map generateParkour() {
        Map m = new Map();
        m.addBox(new Coord(0.0f, 1.0f));
        m.addBox(new Coord(1.0f, 1.0f));
        m.addBox(new Coord(2.0f, 1.0f));
        ArrayList<Coord> moves = new ArrayList<Coord>();
        moves.add(new Coord(8.0f, -1.0f));
        moves.add(new Coord(5.0f, 2.0f));
        moves.add(new Coord(7.0f, -1.0f));
        moves.add(new Coord(7.0f, 1.0f));
        moves.add(new Coord(6.0f, 2.0f));
        moves.add(new Coord(9.0f, -2.0f));
        moves.add(new Coord(10.0f, -3.0f));
        moves.add(new Coord(5.0f, 4.0f));
        moves.add(new Coord(7.0f, 3.0f));
        int mapSize = 30;
        Coord current = new Coord(2.0f, 1.0f);
        int i = 0;
        while (i < mapSize) {
            current.add((Coord)moves.get((int)(Math.random() * (double)moves.size())));
            m.addBox(new Coord(current));
            current.x += 1.0f;
            m.addBox(new Coord(current));
            ++i;
        }
        m.setPlayersPosition(new Coord(200.0f, 300.0f), new Coord(500.0f, 300.0f));
        return m;
    }
}

